/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.msrandom.witchery.block.WitcheryWoodType;
import net.msrandom.witchery.entity.item.EntityWitchBoat;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lnet/msrandom/witchery/item/WitcheryItemBoat;", "Lnet/minecraft/item/Item;", "woodType", "Lnet/msrandom/witchery/block/WitcheryWoodType;", "(Lnet/msrandom/witchery/block/WitcheryWoodType;)V", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "WitcheryResurrected"})
public final class WitcheryItemBoat
extends Item {
    private final WitcheryWoodType woodType;

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World world, @NotNull EntityPlayer player, @NotNull EnumHand hand) {
        ActionResult actionResult;
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(player, "player");
        Intrinsics.checkParameterIsNotNull(hand, "hand");
        ItemStack stack = player.func_184586_b(hand);
        float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C);
        float yaw = player.field_70126_B + (player.field_70177_z - player.field_70126_B);
        double x = player.field_70169_q + (player.field_70165_t - player.field_70169_q);
        double y = player.field_70167_r + (player.field_70163_u - player.field_70167_r) + (double)player.func_70047_e();
        double z = player.field_70166_s + (player.field_70161_v - player.field_70166_s);
        Vec3d vec3d = new Vec3d(x, y, z);
        float rotation = -MathHelper.func_76134_b((float)(-WitcheryUtils.asRadians(pitch)));
        Vec3d vec3d1 = vec3d.func_72441_c((double)(MathHelper.func_76126_a((float)(-WitcheryUtils.asRadians(yaw) - (float)Math.PI)) * rotation) * 5.0, (double)MathHelper.func_76126_a((float)(-WitcheryUtils.asRadians(pitch))) * 5.0, (double)(MathHelper.func_76134_b((float)(-WitcheryUtils.asRadians(yaw) - (float)Math.PI)) * rotation) * 5.0);
        RayTraceResult hit = world.func_72901_a(vec3d, vec3d1, true);
        if (hit == null) {
            actionResult = new ActionResult(EnumActionResult.PASS, (Object)stack);
        } else {
            Vec3d vec3d2 = player.func_70676_i(1.0f);
            boolean colliding = false;
            for (Entity entity : world.func_72839_b((Entity)player, player.func_174813_aQ().func_72321_a(vec3d2.field_72450_a * 5.0, vec3d2.field_72448_b * 5.0, vec3d2.field_72449_c * 5.0).func_186662_g(1.0))) {
                if (!entity.func_70067_L()) continue;
                Entity entity2 = entity;
                Intrinsics.checkExpressionValueIsNotNull(entity2, "entity");
                if (!entity2.func_174813_aQ().func_186662_g((double)entity.func_70111_Y()).func_72318_a(vec3d)) continue;
                colliding = true;
            }
            if (colliding) {
                actionResult = new ActionResult(EnumActionResult.PASS, (Object)stack);
            } else if (hit.field_72313_a != RayTraceResult.Type.BLOCK) {
                actionResult = new ActionResult(EnumActionResult.PASS, (Object)stack);
            } else {
                IBlockState iBlockState = world.func_180495_p(hit.func_178782_a());
                Intrinsics.checkExpressionValueIsNotNull(iBlockState, "world.getBlockState(hit.blockPos)");
                Block block = iBlockState.func_177230_c();
                boolean onWater = block == Blocks.field_150355_j || block == Blocks.field_150358_i;
                EntityWitchBoat boat2 = new EntityWitchBoat(world, hit.field_72307_f.field_72450_a, onWater ? hit.field_72307_f.field_72448_b - 0.12 : hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c, this.woodType);
                boat2.field_70177_z = player.field_70177_z;
                if (world.func_184144_a((Entity)boat2, boat2.func_174813_aQ().func_186662_g(-0.1)).isEmpty()) {
                    if (!world.field_72995_K) {
                        world.func_72838_d((Entity)boat2);
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    player.func_71029_a(StatList.func_188057_b((Item)this));
                    actionResult = new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                } else {
                    actionResult = new ActionResult(EnumActionResult.FAIL, (Object)stack);
                }
            }
        }
        return actionResult;
    }

    public WitcheryItemBoat(@NotNull WitcheryWoodType woodType) {
        Intrinsics.checkParameterIsNotNull(woodType, "woodType");
        this.woodType = woodType;
        this.field_77777_bU = 1;
        this.func_77637_a(WitcheryGeneralItems.TAB);
    }
}

