/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityPoppetShelf;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.entity.EntityWitchHunter;
import net.msrandom.witchery.infusion.spirit.InfusedSpiritEffect;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.item.ItemHunterClothes;
import net.msrandom.witchery.item.ItemTaglockKit;
import net.msrandom.witchery.item.Taglockable;
import net.msrandom.witchery.network.PacketPushTarget;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.registry.RegistryWrappers;
import net.msrandom.witchery.registry.WitcheryNamespacedInitializer;

public class WitcheryPoppetItems
extends WitcheryNamespacedInitializer<Item> {
    public static final WitcheryPoppetItems INSTANCE = new WitcheryPoppetItems();
    public static final ItemPoppet POPPET = WitcheryPoppetItems.register("poppet", new ItemPoppet(EnumRarity.COMMON));
    public static final ItemPoppet EARTH_PROTECTION = WitcheryPoppetItems.register("earth_protection_poppet", new ItemPoppet());
    public static final ItemPoppet WATER_PROTECTION = WitcheryPoppetItems.register("water_protection_poppet", new ItemPoppet());
    public static final ItemPoppet FIRE_PROTECTION = WitcheryPoppetItems.register("fire_protection_poppet", new ItemPoppet());
    public static final ItemPoppet STARVATION_PROTECTION = WitcheryPoppetItems.register("hunger_protection_poppet", new ItemPoppet());
    public static final ItemPoppet TOOL_PROTECTION = WitcheryPoppetItems.register("tool_protection_poppet", new ItemPoppet());
    public static final ItemPoppet DEATH_PROTECTION = WitcheryPoppetItems.register("death_protection_poppet", new ItemPoppet(EnumRarity.RARE));
    public static final ItemPoppet VOODOO_PROTECTION = WitcheryPoppetItems.register("voodoo_protection_poppet", new ItemPoppet());
    public static final ItemPoppet VOODOO = WitcheryPoppetItems.register("voodoo_poppet", new ItemPoppet().doesNotBreak());
    public static final ItemPoppet VAMPIRIC = WitcheryPoppetItems.register("vampiric_poppet", new ItemPoppet(EnumRarity.RARE){

        @Override
        public int getTaglockCount() {
            return 2;
        }
    }.doesNotBreak());
    public static final ItemPoppet POPPET_PROTECTION = WitcheryPoppetItems.register("poppet_protection_poppet", new ItemPoppet(EnumRarity.RARE).doesNotBreak());
    public static final ItemPoppet ARMOR_PROTECTION = WitcheryPoppetItems.register("armor_protection_poppet", new ItemPoppet());

    public WitcheryPoppetItems() {
        super(RegistryWrappers.ITEMS, "witchery", "items/poppets");
    }

    private static <A extends Item> A register(String name2, A poppet) {
        return WitcheryGeneralItems.register0(name2, poppet, INSTANCE.getRegistrar());
    }

    public static ItemStack findBoundPoppetInWorld(ItemPoppet poppetType, EntityPlayer player, int foundItemDamage) {
        return WitcheryPoppetItems.findBoundPoppetInWorld(poppetType, player, foundItemDamage, false, false);
    }

    public static ItemStack findBoundPoppetInWorld(ItemPoppet poppetType, EntityPlayer player, int foundItemDamage, boolean allIndices, boolean onlyBoosted) {
        if (ItemHunterClothes.isFullSetWorn((EntityLivingBase)player, false)) {
            return null;
        }
        ItemStack poppetStack = WitcheryPoppetItems.findBoundPoppetInInventory(poppetType, player, (IInventory)player.field_71071_by, foundItemDamage, allIndices, onlyBoosted);
        if (poppetStack != null) {
            return poppetStack;
        }
        if (!player.field_70170_p.field_72995_K && !onlyBoosted) {
            MinecraftServer server = player.func_184102_h();
            for (WorldServer world : server.field_71305_c) {
                if (WitcheryConfigOptions.restrictPoppetShelvesToVanillaAndSpiritDimensions && world.field_73011_w.getDimension() != 0 && world.field_73011_w.getDimension() != -1 && world.field_73011_w.getDimension() != 1 && !WitcheryDimensions.SPIRIT_WORLD.isCurrentDimension((World)world)) continue;
                for (TileEntity obj : world.field_147482_g) {
                    if (!(obj instanceof TileEntityPoppetShelf) || (poppetStack = WitcheryPoppetItems.findBoundPoppetInInventory(poppetType, player, (IInventory)obj, foundItemDamage, allIndices, false)) == null) continue;
                    return poppetStack;
                }
            }
        }
        return null;
    }

    @Nullable
    private static ItemStack findBoundPoppetInInventory(ItemPoppet item, EntityPlayer player, IInventory inventory, int foundItemDamage, boolean allIndices, boolean onlyBoosted) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            if (itemstack.func_77973_b() != item || !ItemTaglockKit.containsTaglockForEntity(itemstack, (Entity)player, 0) || allIndices && !ItemTaglockKit.isTaglockPresent(itemstack, 1)) continue;
            if (!onlyBoosted) {
                ItemStack result2 = itemstack.func_77946_l();
                item.applyDamageOnUse(player, itemstack, foundItemDamage);
                return result2;
            }
            if (WitcheryPoppetItems.voodooProtection(player)) {
                ItemStack result3 = itemstack.func_77946_l();
                item.applyDamageOnUse(player, itemstack, foundItemDamage);
                return result3;
            }
            return null;
        }
        return null;
    }

    private static boolean voodooProtection(EntityPlayer player) {
        for (Map.Entry entry2 : InfusedSpiritEffect.REGISTRY) {
            if (!((InfusedSpiritEffect)entry2.getValue()).isVoodooProtection() || !((InfusedSpiritEffect)entry2.getValue()).isNearTo(player)) continue;
            return true;
        }
        return false;
    }

    public static boolean voodooProtectionActivated(EntityPlayer attackingEntity, ItemStack voodooStack, EntityLivingBase targetEntity, boolean allowLightning, boolean onlyBoosted) {
        EntityPlayer targetPlayer;
        ItemStack defenseStack;
        if (targetEntity instanceof EntityPlayer && (defenseStack = WitcheryPoppetItems.findBoundPoppetInWorld(VOODOO_PROTECTION, targetPlayer = (EntityPlayer)targetEntity, 350, false, onlyBoosted)) != null && !targetPlayer.field_70170_p.field_72995_K) {
            if (attackingEntity != null && !voodooStack.func_190926_b()) {
                voodooStack.func_77972_a(350, (EntityLivingBase)attackingEntity);
            }
            if (attackingEntity != null && allowLightning) {
                EntityLightningBolt lightning = new EntityLightningBolt(attackingEntity.field_70170_p, attackingEntity.field_70165_t, attackingEntity.field_70163_u, attackingEntity.field_70161_v, false);
                attackingEntity.field_70170_p.func_72942_c((Entity)lightning);
            }
            return true;
        }
        return false;
    }

    public static boolean voodooProtectionActivated(EntityPlayer attackingEntity, ItemStack voodooStack, EntityLivingBase targetEntity, int strength) {
        if (!(strength <= 1 || targetEntity instanceof EntityPlayer && WitcheryPoppetItems.voodooProtection((EntityPlayer)targetEntity))) {
            for (int i = 1; i <= strength; ++i) {
                boolean allowLightning;
                boolean bl = allowLightning = i == strength;
                if (WitcheryPoppetItems.voodooProtectionActivated(attackingEntity, voodooStack, targetEntity, allowLightning, false)) continue;
                return false;
            }
            return true;
        }
        return WitcheryPoppetItems.voodooProtectionActivated(attackingEntity, voodooStack, targetEntity, true, false);
    }

    public static boolean poppetProtectionActivated(EntityPlayer attackingEntity, ItemStack voodooStack, EntityLivingBase targetEntity, boolean allowLightning) {
        EntityPlayer targetPlayer;
        ItemStack defenseStack;
        if (targetEntity instanceof EntityPlayer && (defenseStack = WitcheryPoppetItems.findBoundPoppetInWorld(POPPET_PROTECTION, targetPlayer = (EntityPlayer)targetEntity, 350)) != null && !attackingEntity.field_70170_p.field_72995_K) {
            if (!voodooStack.func_190926_b()) {
                voodooStack.func_77972_a(350, (EntityLivingBase)attackingEntity);
            }
            if (allowLightning) {
                EntityLightningBolt lightning = new EntityLightningBolt(attackingEntity.field_70170_p, attackingEntity.field_70165_t, attackingEntity.field_70163_u, attackingEntity.field_70161_v, false);
                attackingEntity.field_70170_p.func_72942_c((Entity)lightning);
            }
            return true;
        }
        return false;
    }

    public static void destroyAntiVoodooPoppets(EntityLivingBase targetEntity, int poppetsToDestroy) {
        if (targetEntity instanceof EntityPlayer) {
            EntityPlayer targetPlayer = (EntityPlayer)targetEntity;
            for (int i = 0; i < poppetsToDestroy; ++i) {
                ItemStack defenseStack = WitcheryPoppetItems.findBoundPoppetInWorld(VOODOO_PROTECTION, targetPlayer, 1000);
                if (defenseStack != null) continue;
                return;
            }
        }
    }

    public static void cancelEventIfPoppetFound(EntityPlayer player, ItemPoppet poppetType, LivingHurtEvent event, boolean heal, boolean onlyHandheld) {
        ItemStack stack = WitcheryPoppetItems.findBoundPoppetInWorld(poppetType, player, 1000, false, onlyHandheld);
        if (stack != null) {
            event.setCanceled(true);
            if (heal && player.func_110143_aJ() < 10.0f) {
                player.func_70606_j(10.0f);
            }
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, player.func_184176_by(), 0.5f, 0.4f / (player.func_70681_au().nextFloat() * 0.4f + 0.8f));
        }
    }

    public static void cancelEventIfPoppetFound(EntityPlayer player, ItemPoppet poppetType, LivingHurtEvent event, boolean heal) {
        WitcheryPoppetItems.cancelEventIfPoppetFound(player, poppetType, event, heal, false);
    }

    public static void checkForArmorProtection(EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.field_70460_b.size(); ++i) {
            ItemStack protectStack;
            int maxDamage;
            int repairThreshold;
            int itemDamage;
            ItemStack armorPiece = (ItemStack)player.field_71071_by.field_70460_b.get(i);
            if (armorPiece.func_190926_b() || !armorPiece.func_77984_f() || (itemDamage = armorPiece.func_77952_i()) < (repairThreshold = (int)((float)(maxDamage = armorPiece.func_77958_k()) * 0.9f)) || (protectStack = WitcheryPoppetItems.findBoundPoppetInWorld(ARMOR_PROTECTION, player, 1000)) == null) continue;
            armorPiece.func_77964_b(0);
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, player.func_184176_by(), 0.5f, 0.4f / ((float)player.field_70170_p.field_73012_v.nextDouble() * 0.4f + 0.8f));
        }
    }

    public static class ItemPoppet
    extends Item
    implements Taglockable {
        private final EnumRarity rarity;
        private boolean destroyOnUse = true;

        private ItemPoppet() {
            this(EnumRarity.UNCOMMON);
        }

        private ItemPoppet(EnumRarity rarity) {
            this.rarity = rarity;
            this.func_77637_a(WitcheryGeneralItems.TAB);
            this.setNoRepair();
            this.func_77625_d(1);
            this.func_77656_e(1000);
        }

        @SideOnly(value=Side.CLIENT)
        public EnumRarity func_77613_e(ItemStack itemstack) {
            return ((ItemPoppet)itemstack.func_77973_b()).rarity;
        }

        public void func_77624_a(ItemStack stack, World worldIn, List<String> list2, ITooltipFlag advTooltips) {
            ItemPoppet type2 = (ItemPoppet)stack.func_77973_b();
            int count = type2.getTaglockCount();
            boolean empty = true;
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < count; ++i) {
                ITextComponent name2 = this.getBloodName(stack, i);
                if (name2 != null) {
                    empty = false;
                }
                builder.append(name2 == null ? "??" : name2.func_150254_d());
                if (i == count - 1) continue;
                builder.append(" -> ");
            }
            if (empty) {
                list2.add(I18n.func_135052_a((String)(WitcheryGeneralItems.TAGLOCK_KIT.func_77658_a() + ".unbound"), (Object[])new Object[0]));
            } else {
                list2.add(TextFormatting.DARK_PURPLE + builder.toString());
            }
        }

        public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
            EntityLivingBase boundEntity;
            if (!world.field_72995_K && stack.func_77973_b() == VOODOO && entity.func_70055_a(Material.field_151586_h) && entity.func_70086_ai() <= 0 && (boundEntity = ItemTaglockKit.getBoundEntity(world, stack, 0)) != null && boundEntity.func_70089_S() && !WitcheryPoppetItems.voodooProtectionActivated(entity instanceof EntityPlayer ? (EntityPlayer)entity : null, stack, boundEntity, true, false)) {
                boolean damageDisabled;
                if (entity instanceof EntityPlayer) {
                    EntityWitchHunter.blackMagicPerformed((EntityPlayer)entity);
                }
                boolean bl = damageDisabled = boundEntity instanceof EntityPlayer && ((EntityPlayer)boundEntity).field_71075_bZ.field_75102_a;
                if (ItemHunterClothes.isMagicalProtectionActive(boundEntity) && !boundEntity.func_70648_aU() && !boundEntity.func_70644_a(MobEffects.field_76427_o) && !damageDisabled) {
                    for (int i = 0; i < 8; ++i) {
                        float f = world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat();
                        float f2 = world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat();
                        float f3 = world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat();
                        world.func_175688_a(EnumParticleTypes.WATER_BUBBLE, boundEntity.field_70165_t + (double)f, boundEntity.field_70163_u + (double)f2, boundEntity.field_70161_v + (double)f3, boundEntity.field_70159_w, boundEntity.field_70181_x, boundEntity.field_70179_y, new int[0]);
                    }
                    boundEntity.func_70097_a(DamageSource.field_76369_e, 1.0f);
                }
                boundEntity.func_70066_B();
            }
            super.func_77663_a(stack, world, entity, par4, par5);
        }

        public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
            if (player.func_184586_b(hand).func_77973_b() == VOODOO) {
                player.func_184598_c(hand);
            }
            return super.func_77659_a(world, player, hand);
        }

        public int func_77626_a(ItemStack par1ItemStack) {
            return 80;
        }

        public EnumAction func_77661_b(ItemStack par1ItemStack) {
            return EnumAction.BOW;
        }

        public void func_77615_a(ItemStack itemstack, World world, EntityLivingBase livingBase, int ticks) {
            if (!world.field_72995_K && livingBase instanceof EntityPlayer) {
                EntityLivingBase entity;
                EntityPlayer player = (EntityPlayer)livingBase;
                if (itemstack.func_77973_b() == VOODOO && (entity = ItemTaglockKit.getBoundEntity(world, itemstack, 0)) != null) {
                    IBlockState hitBlock;
                    Material hitMaterial;
                    EntityWitchHunter.blackMagicPerformed(player);
                    RayTraceResult hitObject = this.func_77621_a(world, player, true);
                    if (hitObject != null && hitObject.field_72313_a == RayTraceResult.Type.BLOCK && (hitMaterial = (hitBlock = world.func_180495_p(hitObject.func_178782_a())).func_185904_a()) == Material.field_151587_i) {
                        if (!WitcheryPoppetItems.voodooProtectionActivated(player, itemstack, entity, true, false) && ItemHunterClothes.isMagicalProtectionActive((EntityLivingBase)player)) {
                            entity.func_70015_d(10);
                        }
                        itemstack.func_190918_g(1);
                        world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187646_bt, player.func_184176_by(), 0.4f, 2.0f + world.field_73012_v.nextFloat() * 0.4f);
                        return;
                    }
                    if (player.func_70093_af()) {
                        int index = -1;
                        boolean found = player.field_71075_bZ.field_75098_d;
                        if (!found) {
                            for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                                if (((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_77973_b() != WitcheryIngredientItems.DISRUPTED_DREAMS_CHARM) continue;
                                index = i;
                                found = true;
                                break;
                            }
                        }
                        if (found) {
                            PoppetDamageSource damageSource = new PoppetDamageSource((Entity)player);
                            if (!WitcheryPoppetItems.voodooProtectionActivated(player, itemstack, entity, true, false)) {
                                entity.func_70097_a((DamageSource)damageSource, 0.5f);
                                if (!player.field_71075_bZ.field_75098_d) {
                                    if (index != -1) {
                                        player.field_71071_by.func_70301_a(index).func_190918_g(1);
                                    }
                                    itemstack.func_77972_a(10, (EntityLivingBase)player);
                                }
                            }
                        }
                        return;
                    }
                    if (!WitcheryPoppetItems.voodooProtectionActivated(player, itemstack, entity, true, false) && ItemHunterClothes.isMagicalProtectionActive((EntityLivingBase)player)) {
                        Vec3d look = player.func_70040_Z();
                        float scaling = (this.func_77626_a(itemstack) - ticks) / 20;
                        double motionX = look.field_72450_a * 0.9 * (double)scaling;
                        double motionY = look.field_72448_b * 0.3 * (double)scaling;
                        double motionZ = look.field_72449_c * 0.9 * (double)scaling;
                        if (entity instanceof EntityPlayerMP) {
                            EntityPlayerMP targetPlayer = (EntityPlayerMP)entity;
                            WitcheryNetworkChannel.sendTo(new PacketPushTarget(motionX, motionY, motionZ), targetPlayer);
                        } else {
                            entity.field_70159_w = motionX;
                            entity.field_70181_x = motionY;
                            entity.field_70179_y = motionZ;
                        }
                        itemstack.func_77972_a(10, (EntityLivingBase)player);
                    }
                    return;
                }
                super.func_77615_a(itemstack, world, (EntityLivingBase)player, ticks);
            }
        }

        public ItemPoppet doesNotBreak() {
            this.destroyOnUse = false;
            return this;
        }

        private void applyDamageOnUse(EntityPlayer player, ItemStack itemstack, int itemDamage) {
            if (itemstack.func_77958_k() <= 0 && this.destroyOnUse) {
                itemstack.func_190918_g(1);
            } else {
                itemstack.func_77972_a(itemDamage, (EntityLivingBase)player);
            }
        }
    }

    private static class PoppetDamageSource
    extends EntityDamageSource {
        private PoppetDamageSource(Entity source) {
            super(DamageSource.field_76376_m.func_76355_l(), source);
            this.func_76348_h();
            this.func_82726_p();
        }
    }
}

