/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item.brews;

import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.EntityWitchProjectile;
import net.msrandom.witchery.item.brews.ItemKettleBrew;
import net.msrandom.witchery.potion.PotionIllFitting;
import net.msrandom.witchery.util.EarthItems;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J2\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0016J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J(\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0013H\u0002\u00a8\u0006\u001a"}, d2={"Lnet/msrandom/witchery/item/brews/ItemErosionBrew;", "Lnet/msrandom/witchery/item/brews/ItemKettleBrew;", "()V", "damageEquipment", "", "stack", "Lnet/minecraft/item/ItemStack;", "caster", "Lnet/minecraft/entity/EntityLivingBase;", "impact", "", "world", "Lnet/minecraft/world/World;", "projectile", "Lnet/msrandom/witchery/entity/EntityWitchProjectile;", "hit", "Lnet/minecraft/util/math/RayTraceResult;", "enhanced", "meltLine", "", "start", "Lnet/minecraft/util/math/BlockPos;", "end", "meltObsidian", "pos", "radius", "WitcheryResurrected"})
public final class ItemErosionBrew
extends ItemKettleBrew {
    /*
     * WARNING - void declaration
     */
    @Override
    public boolean impact(@NotNull World world, @NotNull EntityWitchProjectile projectile, @Nullable EntityLivingBase caster, @NotNull RayTraceResult hit, boolean enhanced) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull((Object)projectile, "projectile");
        Intrinsics.checkParameterIsNotNull(hit, "hit");
        if (hit.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos blockPos = hit.func_178782_a();
            Intrinsics.checkExpressionValueIsNotNull(blockPos, "hit.blockPos");
            if (WitcheryUtils.isBlockBreakable$default(world, blockPos, null, 2, null)) {
                int obsidianMelted = 0;
                int n = 2;
                boolean bl = false;
                while (n >= 0) {
                    void i;
                    int y = 2 - i;
                    BlockPos blockPos2 = hit.func_178782_a().func_177981_b(y);
                    Intrinsics.checkExpressionValueIsNotNull(blockPos2, "hit.blockPos.up(y)");
                    obsidianMelted += this.meltObsidian(world, projectile, blockPos2, (int)i);
                    if (y != 0) {
                        BlockPos blockPos3 = hit.func_178782_a().func_177979_c(y);
                        Intrinsics.checkExpressionValueIsNotNull(blockPos3, "hit.blockPos.down(y)");
                        obsidianMelted += this.meltObsidian(world, projectile, blockPos3, (int)i);
                    }
                    --i;
                }
                if (obsidianMelted > 0) {
                    BlockPos blockPos4 = hit.func_178782_a();
                    Intrinsics.checkExpressionValueIsNotNull(blockPos4, "hit.blockPos");
                    double d = (double)blockPos4.func_177958_n() + 0.5;
                    BlockPos blockPos5 = hit.func_178782_a();
                    Intrinsics.checkExpressionValueIsNotNull(blockPos5, "hit.blockPos");
                    double d2 = (double)blockPos5.func_177956_o() + 0.5;
                    BlockPos blockPos6 = hit.func_178782_a();
                    Intrinsics.checkExpressionValueIsNotNull(blockPos6, "hit.blockPos");
                    world.func_72838_d((Entity)new EntityItem(world, d, d2, (double)blockPos6.func_177952_p() + 0.5, new ItemStack(Blocks.field_150343_Z, obsidianMelted)));
                }
            }
        } else if (hit.field_72313_a == RayTraceResult.Type.ENTITY) {
            Entity entity = hit.field_72308_g;
            if (entity instanceof EntityLivingBase) {
                float damage = enhanced ? 10.0f : 8.0f;
                entity.func_70097_a(DamageSource.func_76356_a((Entity)entity, (Entity)((Entity)caster)), damage);
                for (EntityEquipmentSlot slot : PotionIllFitting.SLOTS) {
                    ItemStack itemStack = ((EntityLivingBase)entity).func_184582_a(slot);
                    Intrinsics.checkExpressionValueIsNotNull(itemStack, "entity.getItemStackFromSlot(slot)");
                    this.damageEquipment(itemStack, caster);
                }
            } else {
                world.func_72838_d((Entity)new EntityItem(world, hit.field_72308_g.field_70165_t, hit.field_72308_g.field_70163_u, hit.field_72308_g.field_70161_v, new ItemStack((Item)this)));
                return false;
            }
        }
        return true;
    }

    private final int meltObsidian(World world, EntityWitchProjectile projectile, BlockPos pos, int radius) {
        int x = radius;
        int z = 0;
        int radiusError = 1 - x;
        int obsidianMelted = 0;
        while (x >= z) {
            BlockPos blockPos = pos.func_177982_a(-x, 0, z);
            Intrinsics.checkExpressionValueIsNotNull(blockPos, "pos.add(-x, 0, z)");
            BlockPos blockPos2 = pos.func_177982_a(x, 0, z);
            Intrinsics.checkExpressionValueIsNotNull(blockPos2, "pos.add(x, 0, z)");
            obsidianMelted += this.meltLine(world, projectile, blockPos, blockPos2);
            BlockPos blockPos3 = pos.func_177982_a(-z, 0, x);
            Intrinsics.checkExpressionValueIsNotNull(blockPos3, "pos.add(-z, 0, x)");
            BlockPos blockPos4 = pos.func_177982_a(z, 0, x);
            Intrinsics.checkExpressionValueIsNotNull(blockPos4, "pos.add(z, 0, x)");
            obsidianMelted += this.meltLine(world, projectile, blockPos3, blockPos4);
            BlockPos blockPos5 = pos.func_177982_a(-x, 0, -z);
            Intrinsics.checkExpressionValueIsNotNull(blockPos5, "pos.add(-x, 0, -z)");
            BlockPos blockPos6 = pos.func_177982_a(x, 0, -z);
            Intrinsics.checkExpressionValueIsNotNull(blockPos6, "pos.add(x, 0, -z)");
            obsidianMelted += this.meltLine(world, projectile, blockPos5, blockPos6);
            BlockPos blockPos7 = pos.func_177982_a(-z, 0, -z);
            Intrinsics.checkExpressionValueIsNotNull(blockPos7, "pos.add(-z, 0, -z)");
            BlockPos blockPos8 = pos.func_177982_a(z, 0, -z);
            Intrinsics.checkExpressionValueIsNotNull(blockPos8, "pos.add(z, 0, -z)");
            obsidianMelted += this.meltLine(world, projectile, blockPos7, blockPos8);
            radiusError += radiusError < 0 ? 2 * z + 1 : 2 * (++z - --x + 1);
        }
        return obsidianMelted;
    }

    private final int meltLine(World world, EntityWitchProjectile projectile, BlockPos start, BlockPos end) {
        int obsidianMelted = 0;
        for (BlockPos pos : WitcheryUtils.rangeTo(start, end)) {
            IBlockState state;
            IBlockState iBlockState = state = world.func_180495_p(pos);
            Intrinsics.checkExpressionValueIsNotNull(iBlockState, "state");
            if (iBlockState.func_177230_c() == Blocks.field_150343_Z) {
                ++obsidianMelted;
            }
            if (!WitcheryUtils.isBlockBreakable(world, pos, state) || !state.func_185917_h()) continue;
            world.func_175698_g(pos);
            WitcheryUtils.addNewParticles$default(world, EnumParticleTypes.WATER_SPLASH, projectile.field_70165_t, projectile.field_70163_u, projectile.field_70161_v, 0.0, 20, 0.0, 0.0, 192, null);
        }
        return obsidianMelted;
    }

    private final void damageEquipment(ItemStack stack, EntityLivingBase caster) {
        if (stack.func_77984_f() && EarthItems.instance().isMatch(stack)) {
            EntityLivingBase entityLivingBase = caster;
            if (entityLivingBase != null) {
                EntityLivingBase entityLivingBase2 = entityLivingBase;
                boolean bl = false;
                boolean bl2 = false;
                EntityLivingBase it = entityLivingBase2;
                boolean bl3 = false;
                stack.func_77972_a(100, it);
            } else {
                stack.func_96631_a(100, ItemErosionBrew.access$getItemRand$p$s2289459(), null);
            }
        }
    }

    public ItemErosionBrew() {
        super(false, 1, null);
    }

    public static final /* synthetic */ Random access$getItemRand$p$s2289459() {
        return Item.field_77697_d;
    }

    public static final /* synthetic */ void access$setItemRand$p$s2289459(Random random) {
        Item.field_77697_d = random;
    }
}

