/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item.brews;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.EntityWitchProjectile;
import net.msrandom.witchery.entity.monster.EntityHornedHuntsman;
import net.msrandom.witchery.item.brews.ItemKettleBrew;
import net.msrandom.witchery.network.PacketPushTarget;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0016J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0002\u00a8\u0006\u0016"}, d2={"Lnet/msrandom/witchery/item/brews/ItemFrogsTongueBrew;", "Lnet/msrandom/witchery/item/brews/ItemKettleBrew;", "()V", "impact", "", "world", "Lnet/minecraft/world/World;", "projectile", "Lnet/msrandom/witchery/entity/EntityWitchProjectile;", "caster", "Lnet/minecraft/entity/EntityLivingBase;", "hit", "Lnet/minecraft/util/math/RayTraceResult;", "enhanced", "pull", "", "entity", "Lnet/minecraft/entity/Entity;", "posX", "", "posY", "posZ", "WitcheryResurrected"})
public final class ItemFrogsTongueBrew
extends ItemKettleBrew {
    @Override
    public boolean impact(@NotNull World world, @NotNull EntityWitchProjectile projectile, @Nullable EntityLivingBase caster, @NotNull RayTraceResult hit, boolean enhanced) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull((Object)projectile, "projectile");
        Intrinsics.checkParameterIsNotNull(hit, "hit");
        if (!world.field_72995_K && caster != null) {
            double r = 4.0;
            for (EntityLivingBase livingEntity : world.func_72872_a(EntityLivingBase.class, projectile.func_174813_aQ().func_72321_a(r, 2.0, r))) {
                double distanceSq = livingEntity.func_70092_e(projectile.field_70165_t, projectile.field_70163_u, projectile.field_70161_v);
                if (!(distanceSq < r * r) || livingEntity == caster) continue;
                EntityLivingBase entityLivingBase = livingEntity;
                Intrinsics.checkExpressionValueIsNotNull(entityLivingBase, "livingEntity");
                this.pull((Entity)entityLivingBase, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v);
            }
        }
        return true;
    }

    private final void pull(Entity entity, double posX, double posY, double posZ) {
        if (entity instanceof EntityDragon || entity instanceof EntityHornedHuntsman) {
            return;
        }
        double d = posX - entity.field_70165_t;
        double d2 = posY - entity.field_70163_u;
        double d3 = posZ - entity.field_70161_v;
        float distance = MathHelper.func_76133_a((double)(d * d + d2 * d2 + d3 * d3));
        float f2 = 0.15f;
        double mx = d / (double)distance * (double)f2 * (double)distance;
        double my = 0.4;
        double mz = d3 / (double)distance * (double)f2 * (double)distance;
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76430_j, 20, 1));
        }
        if (entity instanceof EntityPlayerMP) {
            WitcheryNetworkChannel.sendTo(new PacketPushTarget(mx, my, mz), (EntityPlayerMP)entity);
        } else {
            entity.field_70159_w = mx;
            entity.field_70181_x = my;
            entity.field_70179_y = mz;
        }
    }

    public ItemFrogsTongueBrew() {
        super(false, 1, null);
    }
}

