/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item.brews;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.EntityWitchProjectile;
import net.msrandom.witchery.item.brews.ItemKettleBrew;
import net.msrandom.witchery.util.EntityUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0016\u00a8\u0006\u000f"}, d2={"Lnet/msrandom/witchery/item/brews/ItemInkBrew;", "Lnet/msrandom/witchery/item/brews/ItemKettleBrew;", "()V", "impact", "", "world", "Lnet/minecraft/world/World;", "projectile", "Lnet/msrandom/witchery/entity/EntityWitchProjectile;", "caster", "Lnet/minecraft/entity/EntityLivingBase;", "hit", "Lnet/minecraft/util/math/RayTraceResult;", "enhanced", "Companion", "WitcheryResurrected"})
public final class ItemInkBrew
extends ItemKettleBrew {
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean impact(@NotNull World world, @NotNull EntityWitchProjectile projectile, @Nullable EntityLivingBase caster, @NotNull RayTraceResult hit, boolean enhanced) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull((Object)projectile, "projectile");
        Intrinsics.checkParameterIsNotNull(hit, "hit");
        BlockPos blockPos = projectile.func_180425_c();
        Intrinsics.checkExpressionValueIsNotNull(blockPos, "projectile.position");
        Entity entity = hit.field_72308_g;
        AxisAlignedBB axisAlignedBB = projectile.func_174813_aQ();
        Intrinsics.checkExpressionValueIsNotNull(axisAlignedBB, "projectile.entityBoundingBox");
        Companion.impactInk(world, blockPos, entity, axisAlignedBB, enhanced);
        return true;
    }

    public ItemInkBrew() {
        super(false, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lnet/msrandom/witchery/item/brews/ItemInkBrew$Companion;", "", "()V", "impactInk", "", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "entity", "Lnet/minecraft/entity/Entity;", "boundingBox", "Lnet/minecraft/util/math/AxisAlignedBB;", "enhanced", "", "WitcheryResurrected"})
    public static final class Companion {
        public final void impactInk(@NotNull World world, @NotNull BlockPos pos, @Nullable Entity entity, @NotNull AxisAlignedBB boundingBox, boolean enhanced) {
            Intrinsics.checkParameterIsNotNull(world, "world");
            Intrinsics.checkParameterIsNotNull(pos, "pos");
            Intrinsics.checkParameterIsNotNull(boundingBox, "boundingBox");
            double radius = enhanced ? 5.0 : 4.0;
            for (EntityLivingBase living2 : world.func_72872_a(EntityLivingBase.class, boundingBox.func_72321_a(radius, 2.0, radius))) {
                double distance = living2.func_174818_b(pos);
                if (!(distance < radius * radius)) continue;
                double d = 1.0;
                boolean bl = false;
                double d2 = Math.sqrt(distance);
                double multiplier = d - d2 / radius;
                if (living2 == entity) {
                    multiplier = 1.0;
                }
                living2.func_70690_d(new PotionEffect(MobEffects.field_76440_q, (int)(multiplier * 400.0 + 0.5), 0));
                if (!(living2 instanceof EntityLiving)) continue;
                EntityUtil.dropAttackTarget((EntityLiving)living2);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

