/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.item.contracts;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.init.WitcheryEntities;
import net.msrandom.witchery.init.items.WitcheryContractItems;
import net.msrandom.witchery.item.contracts.ItemContract;
import net.msrandom.witchery.item.contracts.ItemTormentContract;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0017J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J@\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000fH\u0002J&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u001f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0016J \u0010\"\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0016H\u0016\u00a8\u0006%"}, d2={"Lnet/msrandom/witchery/item/contracts/ItemTormentContract;", "Lnet/msrandom/witchery/item/contracts/ItemContract;", "()V", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "worldIn", "Lnet/minecraft/world/World;", "tooltip", "", "", "flagIn", "Lnet/minecraft/client/util/ITooltipFlag;", "circleNear", "", "world", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "getItemUseAction", "Lnet/minecraft/item/EnumAction;", "getMaxItemUseDuration", "", "isPost", "x", "y", "z", "bottomSolid", "midSolid", "topSolid", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "hand", "Lnet/minecraft/util/EnumHand;", "onUsingTick", "Lnet/minecraft/entity/EntityLivingBase;", "count", "WitcheryResurrected"})
public final class ItemTormentContract
extends ItemContract {
    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<String> tooltip, @NotNull ITooltipFlag flagIn) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        Intrinsics.checkParameterIsNotNull(tooltip, "tooltip");
        Intrinsics.checkParameterIsNotNull(flagIn, "flagIn");
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        String string = I18n.func_135052_a((String)(this.func_77658_a() + ".tip"), (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull(string, "I18n.format(\"$translationKey.tip\")");
        tooltip.addAll(StringsKt.split$default((CharSequence)string, new String[]{"\\n"}, false, 0, 6, null));
    }

    public int func_77626_a(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        return 1200;
    }

    @NotNull
    public EnumAction func_77661_b(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        return EnumAction.BOW;
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World world, @NotNull EntityPlayer player, @NotNull EnumHand hand) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(player, "player");
        Intrinsics.checkParameterIsNotNull(hand, "hand");
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onUsingTick(@NotNull ItemStack stack, @NotNull EntityLivingBase player, int count) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        Intrinsics.checkParameterIsNotNull(player, "player");
        super.onUsingTick(stack, player, count);
        World world = player.field_70170_p;
        if (world.field_72995_K) return;
        if (!(player instanceof EntityPlayer)) return;
        int elapsedTicks = stack.func_77988_m() - count;
        if (elapsedTicks % 40 != 0) return;
        if (elapsedTicks <= 40) {
            if (!Infusion.acquireEnergy(world, (EntityPlayer)player, 10, true)) return;
            if (elapsedTicks <= 0) {
                World world2 = world;
                Intrinsics.checkExpressionValueIsNotNull(world2, "world");
                if (!this.circleNear(world2, (EntityPlayer)player)) {
                    EntityPlayer entityPlayer = (EntityPlayer)player;
                    SoundEvent soundEvent = SoundEvents.field_187688_dI;
                    Intrinsics.checkExpressionValueIsNotNull(soundEvent, "SoundEvents.BLOCK_NOTE_SNARE");
                    WitcheryUtils.playSoundAt(entityPlayer, soundEvent, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    player.func_145747_a(new TextComponentTranslation(WitcheryContractItems.TORMENT_CONTRACT.func_77658_a() + ".not_centered", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                    player.func_184602_cy();
                    return;
                }
            }
            EntityPlayer entityPlayer = (EntityPlayer)player;
            SoundEvent soundEvent = SoundEvents.field_187600_C;
            Intrinsics.checkExpressionValueIsNotNull(soundEvent, "SoundEvents.ENTITY_BLAZE_DEATH");
            WitcheryUtils.playSoundAt(entityPlayer, soundEvent, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            return;
        }
        int n = elapsedTicks;
        if (80 <= n && 120 >= n) {
            if (!Infusion.acquireEnergy(world, (EntityPlayer)player, 10, true)) return;
            world.func_184133_a(null, ((EntityPlayer)player).func_180425_c(), SoundEvents.field_187600_C, ((EntityPlayer)player).func_184176_by(), 0.5f, 0.4f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
            World world3 = world;
            Intrinsics.checkExpressionValueIsNotNull(world3, "world");
            WitcheryUtils.addNewParticles(world3, EnumParticleTypes.SPELL_MOB, player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0, 20, 1.0, 2.0);
            return;
        }
        n = elapsedTicks;
        if (160 <= n && 240 >= n) {
            if (!Infusion.acquireEnergy(world, (EntityPlayer)player, 10, true)) return;
            world.func_184133_a(null, ((EntityPlayer)player).func_180425_c(), SoundEvents.field_187600_C, ((EntityPlayer)player).func_184176_by(), 0.5f, 0.4f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
            World world4 = world;
            Intrinsics.checkExpressionValueIsNotNull(world4, "world");
            WitcheryUtils.addNewParticles(world4, EnumParticleTypes.SPELL_MOB, player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0, 20, 1.0, 2.0);
            WitcheryUtils.addNewParticles(world, EnumParticleTypes.FLAME, player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0, 20, 1.0, 2.0);
            return;
        }
        if (elapsedTicks < 280) return;
        if (!Infusion.acquireEnergy(world, (EntityPlayer)player, 10, true)) return;
        World world5 = world;
        Intrinsics.checkExpressionValueIsNotNull(world5, "world");
        if (!this.circleNear(world5, (EntityPlayer)player)) {
            EntityPlayer entityPlayer = (EntityPlayer)player;
            SoundEvent soundEvent = SoundEvents.field_187688_dI;
            Intrinsics.checkExpressionValueIsNotNull(soundEvent, "SoundEvents.BLOCK_NOTE_SNARE");
            WitcheryUtils.playSoundAt(entityPlayer, soundEvent, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            player.func_184602_cy();
            return;
        }
        WitcheryUtils.addNewParticles(world, EnumParticleTypes.SPELL_MOB, player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0, 20, 1.0, 2.0);
        WitcheryUtils.addNewParticles(world, EnumParticleTypes.FLAME, player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0, 40, 1.0, 2.0);
        player.func_184602_cy();
        BlockPos blockPos = ((EntityPlayer)player).func_180425_c();
        Intrinsics.checkExpressionValueIsNotNull(blockPos, "player.position");
        EntityLiving living2 = (EntityLiving)WitcheryUtils.summonEntity(world, WitcheryEntities.LORD_OF_TORMENT, blockPos, 2, 4, (Function1)onUsingTick.living.1.INSTANCE);
        if (living2 == null) {
            EntityPlayer entityPlayer = (EntityPlayer)player;
            SoundEvent soundEvent = SoundEvents.field_187688_dI;
            Intrinsics.checkExpressionValueIsNotNull(soundEvent, "SoundEvents.BLOCK_NOTE_SNARE");
            WitcheryUtils.playSoundAt(entityPlayer, soundEvent, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            return;
        }
        if (!((EntityPlayer)player).field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        living2.func_110163_bv();
        world.func_72885_a((Entity)living2, living2.field_70165_t, living2.field_70163_u + (double)living2.func_70047_e(), living2.field_70161_v, 7.0f, false, world.func_82736_K().func_82766_b("mobGriefing"));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean circleNear(World world, EntityPlayer player) {
        int midX = MathHelper.func_76128_c((double)player.field_70165_t);
        int midY = MathHelper.func_76128_c((double)player.field_70163_u);
        int midZ = MathHelper.func_76128_c((double)player.field_70161_v);
        int[][] pattern = new int[][]{{0, 0, 0, 0, 4, 3, 4, 0, 0, 0, 0}, {0, 0, 4, 3, 1, 1, 1, 3, 4, 0, 0}, {0, 4, 1, 1, 1, 1, 1, 1, 1, 4, 0}, {0, 3, 1, 1, 1, 1, 1, 1, 1, 3, 0}, {4, 1, 1, 1, 2, 2, 2, 1, 1, 1, 4}, {3, 1, 1, 1, 2, 1, 2, 1, 1, 1, 3}, {4, 1, 1, 1, 2, 2, 2, 1, 1, 1, 4}, {0, 3, 1, 1, 1, 1, 1, 1, 1, 3, 0}, {0, 4, 1, 1, 1, 1, 1, 1, 1, 4, 0}, {0, 0, 4, 3, 1, 1, 1, 3, 4, 0, 0}, {0, 0, 0, 0, 4, 3, 4, 0, 0, 0, 0}};
        int offsetZ = (((Object[])pattern).length - 1) / 2;
        int n = 0;
        int n2 = ((Object[])pattern).length - 1;
        while (n < n2) {
            void z;
            int worldZ = midZ - offsetZ + z;
            int offsetX = (pattern[z].length - 1) / 2;
            int n3 = 0;
            int n4 = pattern[z].length;
            while (n3 < n4) {
                void x;
                int worldX = midX - offsetX + x;
                int value = pattern[((Object[])pattern).length - 1 - z][x];
                if (value != 0 && !this.isPost(world, worldX, midY, worldZ, value == 2 || value == 4, value == 4, value == 3 || value == 4)) {
                    return false;
                }
                ++x;
            }
            ++z;
        }
        return true;
    }

    private final boolean isPost(World world, int x, int y, int z, boolean bottomSolid, boolean midSolid, boolean topSolid) {
        IBlockState blockBelow = BlockUtil.getBlock(world, x, y - 1, z);
        IBlockState blockBottom = BlockUtil.getBlock(world, x, y, z);
        IBlockState blockMid = BlockUtil.getBlock(world, x, y + 1, z);
        IBlockState blockTop = BlockUtil.getBlock(world, x, y + 2, z);
        IBlockState blockAbove = BlockUtil.getBlock(world, x, y + 3, z);
        IBlockState iBlockState = blockBelow;
        Intrinsics.checkExpressionValueIsNotNull(iBlockState, "blockBelow");
        Material material = iBlockState.func_185904_a();
        Intrinsics.checkExpressionValueIsNotNull(material, "blockBelow.material");
        if (!material.func_76220_a()) {
            return false;
        }
        if (bottomSolid) {
            IBlockState iBlockState2 = blockBottom;
            Intrinsics.checkExpressionValueIsNotNull(iBlockState2, "blockBottom");
            Material material2 = iBlockState2.func_185904_a();
            Intrinsics.checkExpressionValueIsNotNull(material2, "blockBottom.material");
            if (!material2.func_76220_a()) {
                return false;
            }
        } else {
            IBlockState iBlockState3 = blockBottom;
            Intrinsics.checkExpressionValueIsNotNull(iBlockState3, "blockBottom");
            Material material3 = iBlockState3.func_185904_a();
            Intrinsics.checkExpressionValueIsNotNull(material3, "blockBottom.material");
            if (material3.func_76220_a()) {
                return false;
            }
        }
        if (midSolid) {
            IBlockState iBlockState4 = blockMid;
            Intrinsics.checkExpressionValueIsNotNull(iBlockState4, "blockMid");
            Material material4 = iBlockState4.func_185904_a();
            Intrinsics.checkExpressionValueIsNotNull(material4, "blockMid.material");
            if (!material4.func_76220_a()) {
                return false;
            }
        } else {
            IBlockState iBlockState5 = blockMid;
            Intrinsics.checkExpressionValueIsNotNull(iBlockState5, "blockMid");
            Material material5 = iBlockState5.func_185904_a();
            Intrinsics.checkExpressionValueIsNotNull(material5, "blockMid.material");
            if (material5.func_76220_a()) {
                return false;
            }
        }
        if (topSolid) {
            IBlockState iBlockState6 = blockTop;
            Intrinsics.checkExpressionValueIsNotNull(iBlockState6, "blockTop");
            Material material6 = iBlockState6.func_185904_a();
            Intrinsics.checkExpressionValueIsNotNull(material6, "blockTop.material");
            if (!material6.func_76220_a()) {
                return false;
            }
        } else {
            IBlockState iBlockState7 = blockTop;
            Intrinsics.checkExpressionValueIsNotNull(iBlockState7, "blockTop");
            Material material7 = iBlockState7.func_185904_a();
            Intrinsics.checkExpressionValueIsNotNull(material7, "blockTop.material");
            if (material7.func_76220_a()) {
                return false;
            }
        }
        IBlockState iBlockState8 = blockAbove;
        Intrinsics.checkExpressionValueIsNotNull(iBlockState8, "blockAbove");
        Material material8 = iBlockState8.func_185904_a();
        Intrinsics.checkExpressionValueIsNotNull(material8, "blockAbove.material");
        return !material8.func_76220_a();
    }
}

