/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.network;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.msrandom.witchery.extensions.VillagerExtendedData;
import net.msrandom.witchery.init.WitcheryDataExtensions;
import net.msrandom.witchery.network.WitcheryNetworkPacket;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lnet/msrandom/witchery/network/PacketExtendedVillagerSync;", "Lnet/msrandom/witchery/network/WitcheryNetworkPacket;", "villagerEx", "Lnet/msrandom/witchery/extensions/VillagerExtendedData;", "(Lnet/msrandom/witchery/extensions/VillagerExtendedData;)V", "buffer", "Lnet/minecraft/network/PacketBuffer;", "(Lnet/minecraft/network/PacketBuffer;)V", "blood", "", "entityId", "sleeping", "", "apply", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "write", "WitcheryResurrected"})
public final class PacketExtendedVillagerSync
implements WitcheryNetworkPacket {
    private final int entityId;
    private final int blood;
    private final boolean sleeping;

    @Override
    public void write(@NotNull PacketBuffer buffer) {
        Intrinsics.checkParameterIsNotNull(buffer, "buffer");
        buffer.func_150787_b(this.entityId);
        buffer.func_150787_b(this.blood);
        buffer.writeBoolean(this.sleeping);
    }

    @Override
    public void apply(@NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull(player, "player");
        Entity entity = player.field_70170_p.func_73045_a(this.entityId);
        if (entity instanceof EntityVillager) {
            VillagerExtendedData ext = WitcheryDataExtensions.VILLAGER.get((EntityVillager)entity);
            ext.setBlood(this.blood);
            ext.setSleeping(this.sleeping);
        }
    }

    public PacketExtendedVillagerSync(@NotNull VillagerExtendedData villagerEx) {
        Intrinsics.checkParameterIsNotNull(villagerEx, "villagerEx");
        Object e = villagerEx.getEntity();
        Intrinsics.checkExpressionValueIsNotNull(e, "villagerEx.entity");
        this.entityId = ((EntityVillager)e).func_145782_y();
        this.blood = villagerEx.getBlood();
        this.sleeping = villagerEx.isSleeping();
    }

    public PacketExtendedVillagerSync(@NotNull PacketBuffer buffer) {
        Intrinsics.checkParameterIsNotNull(buffer, "buffer");
        this.entityId = buffer.func_150792_a();
        this.blood = buffer.func_150792_a();
        this.sleeping = buffer.readBoolean();
    }
}

