/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.network;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.init.WitcheryCreatureTraits;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.data.WitcheryAlternateForms;
import net.msrandom.witchery.network.PacketHowl;
import net.msrandom.witchery.network.WitcheryNetworkPacket;
import net.msrandom.witchery.resources.CreatureFormStatManager;
import net.msrandom.witchery.transformation.CreatureForm;
import net.msrandom.witchery.transformation.WerewolfCreatureTrait;
import net.msrandom.witchery.util.CreatureUtil;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lnet/msrandom/witchery/network/PacketHowl;", "Lnet/msrandom/witchery/network/WitcheryNetworkPacket;", "buffer", "Lnet/minecraft/network/PacketBuffer;", "(Lnet/minecraft/network/PacketBuffer;)V", "()V", "apply", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "WitcheryResurrected"})
public final class PacketHowl
implements WitcheryNetworkPacket {
    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void apply(@NotNull EntityPlayer player) {
        Object object;
        Intrinsics.checkParameterIsNotNull(player, "player");
        PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
        WerewolfCreatureTrait transformation = playerEx.getTransformation(WitcheryCreatureTraits.WEREWOLF);
        if (transformation.getLevel() == 6 && (object = playerEx.getCurrentForm()) != null && (object = CreatureFormStatManager.INSTANCE.getStats((CreatureForm)object)) != null && ((CreatureForm.Stats)object).canHowl() && transformation.getQuestState() == WerewolfCreatureTrait.QuestState.STARTED) {
            World world = player.field_70170_p;
            Intrinsics.checkExpressionValueIsNotNull(world, "player.world");
            if (!world.func_72935_r()) {
                WitcheryUtils.playSoundAt(player, WitcherySounds.ENTITY_WEREWOLF_HOWL, 1.0f, 0.4f / (player.func_70681_au().nextFloat() * 0.4f + 0.8f));
                if (transformation.getVisitedChunks().add(new ChunkPos(MathHelper.func_76128_c((double)player.field_70165_t) >> 4, MathHelper.func_76128_c((double)player.field_70161_v) >> 4))) {
                    WerewolfCreatureTrait werewolfCreatureTrait = transformation;
                    werewolfCreatureTrait.setQuestCount(werewolfCreatureTrait.getQuestCount() + 1);
                    werewolfCreatureTrait.getQuestCount();
                    return;
                }
                player.func_145747_a(new TextComponentTranslation("witchery.werewolf.already_visited_chunk", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                return;
            }
        }
        if (Intrinsics.areEqual(playerEx.getCurrentForm(), WitcheryAlternateForms.WOLF) && transformation.getLevel() >= 8) {
            long lastHowl = transformation.getLastHowl();
            long serverTime = MinecraftServer.func_130071_aq();
            if (!player.field_71075_bZ.field_75098_d && lastHowl + (long)60000 >= serverTime) {
                WitcheryUtils.playSoundAt(player, WitcherySounds.ENTITY_WEREWOLF_HOWL, 1.0f, 0.4f / (player.func_70681_au().nextFloat() * 0.4f + 0.8f));
                return;
            }
            WitcheryUtils.playSoundAt(player, WitcherySounds.ENTITY_WEREWOLF_HOWL, 1.0f, 0.4f / (player.func_70681_au().nextFloat() * 0.4f + 0.8f));
            transformation.setLastHowl(serverTime);
            int n = 0;
            int n2 = 2 + player.field_70170_p.field_73012_v.nextInt(transformation.getLevel() - 7);
            while (n < n2) {
                void i;
                World world = player.field_70170_p;
                Intrinsics.checkExpressionValueIsNotNull(world, "player.world");
                Function1 function1 = apply.creature.1.INSTANCE;
                BlockPos blockPos = player.func_180425_c();
                Intrinsics.checkExpressionValueIsNotNull(blockPos, "player.position");
                EntityWolf creature2 = (EntityWolf)WitcheryUtils.summonEntity(world, function1, blockPos, 1, 6, (Function1)new Function1<EntityWolf, Unit>(player){
                    final /* synthetic */ EntityPlayer $player;

                    public final void invoke(@NotNull EntityWolf $this$summonEntity) {
                        Intrinsics.checkParameterIsNotNull($this$summonEntity, "$receiver");
                        World world = $this$summonEntity.field_70170_p;
                        Intrinsics.checkExpressionValueIsNotNull(world, "world");
                        WitcheryUtils.addNewParticles(world, EnumParticleTypes.SMOKE_NORMAL, $this$summonEntity.field_70165_t, $this$summonEntity.field_70163_u, $this$summonEntity.field_70161_v, 0.0, 20, 1.0, $this$summonEntity.field_70131_O);
                        $this$summonEntity.func_70624_b(this.$player.func_110144_aD());
                    }
                    {
                        this.$player = entityPlayer;
                        super(1);
                    }
                });
                if (creature2 != null) {
                    creature2.func_70690_d(new PotionEffect(WitcheryPotionEffects.MORTAL_COIL, 200));
                    EntityWolf wolf = creature2;
                    wolf.func_70903_f(true);
                    wolf.func_184754_b(player.func_110124_au());
                    wolf.field_70728_aV = 0;
                    WitcheryUtils.setNoDrops((EntityLivingBase)wolf, true);
                }
                ++i;
            }
            return;
        }
        if (!Intrinsics.areEqual(playerEx.getCurrentForm(), WitcheryAlternateForms.WOLFMAN)) return;
        if (transformation.getLevel() < 7) return;
        long lastHowl = transformation.getLastHowl();
        long serverTime = MinecraftServer.func_130071_aq();
        if (!player.field_71075_bZ.field_75098_d && lastHowl + (long)60000 >= serverTime) {
            SoundEvent soundEvent = SoundEvents.field_187688_dI;
            Intrinsics.checkExpressionValueIsNotNull(soundEvent, "SoundEvents.BLOCK_NOTE_SNARE");
            WitcheryUtils.playSoundAt(player, soundEvent, 1.0f, 0.4f / (player.func_70681_au().nextFloat() * 0.4f + 0.8f));
            return;
        }
        WitcheryUtils.playSoundAt(player, WitcherySounds.ENTITY_WEREWOLF_HOWL, 1.0f, 0.4f / (player.func_70681_au().nextFloat() * 0.4f + 0.8f));
        transformation.setLastHowl(serverTime);
        double radius = 16.0;
        List entities = player.field_70170_p.func_72872_a(EntityLivingBase.class, player.func_174813_aQ().func_72321_a(radius, radius, radius));
        Iterator iterator2 = entities.iterator();
        while (iterator2.hasNext()) {
            EntityLivingBase entity = (EntityLivingBase)iterator2.next();
            if (CreatureUtil.isWerewolf((Entity)entity, true) || CreatureUtil.isVampire((Entity)entity)) continue;
            entity.func_70690_d(new PotionEffect(WitcheryPotionEffects.PARALYSED, (4 + player.field_70170_p.field_73012_v.nextInt(transformation.getLevel() - 6)) * 20, 3));
        }
    }

    public PacketHowl() {
    }

    public PacketHowl(@NotNull PacketBuffer buffer) {
        Intrinsics.checkParameterIsNotNull(buffer, "buffer");
        this();
    }
}

