/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.network;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.network.WitcheryNetworkPacket;
import net.msrandom.witchery.transformation.CreatureForm;
import net.msrandom.witchery.util.WitcheryUtils;
import net.msrandom.witchery.world.dimension.spirit.SpiritWorldData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnet/msrandom/witchery/network/PacketPlayerStyle;", "Lnet/msrandom/witchery/network/WitcheryNetworkPacket;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "(Lnet/minecraft/entity/player/EntityPlayer;)V", "buffer", "Lnet/minecraft/network/PacketBuffer;", "(Lnet/minecraft/network/PacketBuffer;)V", "blood", "", "creatureType", "Lnet/msrandom/witchery/transformation/CreatureForm;", "ghost", "", "grotesqueTicks", "nightmareLevel", "Lnet/msrandom/witchery/world/dimension/spirit/SpiritWorldData$NightmareLevel;", "playerId", "playerSkin", "Lcom/mojang/authlib/GameProfile;", "apply", "", "write", "WitcheryResurrected"})
public final class PacketPlayerStyle
implements WitcheryNetworkPacket {
    private final int playerId;
    private final int grotesqueTicks;
    private final SpiritWorldData.NightmareLevel nightmareLevel;
    private final boolean ghost;
    private final CreatureForm creatureType;
    private final int blood;
    private final GameProfile playerSkin;

    @Override
    public void write(@NotNull PacketBuffer buffer) {
        block6: {
            GameProfile gameProfile;
            block5: {
                ByteBuf byteBuf;
                Intrinsics.checkParameterIsNotNull(buffer, "buffer");
                buffer.func_150787_b(this.playerId);
                buffer.func_150787_b(this.grotesqueTicks);
                buffer.func_179249_a((Enum)this.nightmareLevel);
                buffer.writeBoolean(this.ghost);
                buffer.func_150787_b(CreatureForm.REGISTRY.getId(this.creatureType));
                buffer.func_150787_b(this.blood);
                gameProfile = this.playerSkin;
                if (gameProfile == null) break block5;
                GameProfile gameProfile2 = gameProfile;
                boolean bl = false;
                boolean bl2 = false;
                GameProfile it = gameProfile2;
                boolean bl3 = false;
                buffer.writeBoolean(true);
                buffer.func_179252_a(EntityPlayer.func_146094_a((GameProfile)this.playerSkin));
                if (this.playerSkin.getName() != null) {
                    buffer.writeBoolean(true);
                    byteBuf = (ByteBuf)buffer.func_180714_a(this.playerSkin.getName());
                } else {
                    byteBuf = buffer.writeBoolean(false);
                }
                gameProfile = byteBuf;
                if (byteBuf != null) break block6;
            }
            gameProfile = buffer.writeBoolean(false);
        }
    }

    @Override
    public void apply(@NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull(player, "player");
        Entity otherPlayer = player.field_70170_p.func_73045_a(this.playerId);
        if (otherPlayer instanceof EntityPlayer) {
            PlayerExtendedData playerEx = WitcheryUtils.getExtension((EntityPlayer)otherPlayer);
            playerEx.grotesqueTicks = this.grotesqueTicks;
            playerEx.getSpiritData().setNightmareLevel(this.nightmareLevel);
            playerEx.getSpiritData().setGhost(this.ghost);
            playerEx.setCurrentForm(this.creatureType);
            playerEx.setHumanBlood(this.blood);
            playerEx.setOtherPlayer(this.playerSkin);
        }
    }

    public PacketPlayerStyle(@NotNull EntityPlayer player) {
        GameProfile gameProfile;
        Intrinsics.checkParameterIsNotNull(player, "player");
        PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
        this.playerId = player.func_145782_y();
        this.grotesqueTicks = playerEx.grotesqueTicks;
        this.nightmareLevel = playerEx.getSpiritData().getNightmareLevel();
        this.ghost = playerEx.getSpiritData().isGhost();
        this.creatureType = playerEx.getCurrentForm();
        this.blood = playerEx.getHumanBlood();
        PacketPlayerStyle packetPlayerStyle = this;
        UUID uUID = playerEx.getOtherPlayerId();
        if (uUID != null) {
            UUID uUID2 = uUID;
            PacketPlayerStyle packetPlayerStyle2 = packetPlayerStyle;
            boolean bl = false;
            boolean bl2 = false;
            UUID it = uUID2;
            boolean bl3 = false;
            GameProfile gameProfile2 = new GameProfile(it, playerEx.getOtherPlayerName(player.field_70170_p));
            packetPlayerStyle = packetPlayerStyle2;
            gameProfile = gameProfile2;
        } else {
            gameProfile = null;
        }
        packetPlayerStyle.playerSkin = gameProfile;
    }

    public PacketPlayerStyle(@NotNull PacketBuffer buffer) {
        Intrinsics.checkParameterIsNotNull(buffer, "buffer");
        this.playerId = buffer.func_150792_a();
        this.grotesqueTicks = buffer.func_150792_a();
        Enum enum_ = buffer.func_179257_a(SpiritWorldData.NightmareLevel.class);
        Intrinsics.checkExpressionValueIsNotNull(enum_, "buffer.readEnumValue(Spi\u2026ghtmareLevel::class.java)");
        this.nightmareLevel = (SpiritWorldData.NightmareLevel)enum_;
        this.ghost = buffer.readBoolean();
        this.creatureType = CreatureForm.REGISTRY.get(buffer.func_150792_a());
        this.blood = buffer.func_150792_a();
        this.playerSkin = buffer.readBoolean() ? new GameProfile(buffer.func_179253_g(), buffer.readBoolean() ? buffer.func_150789_c(64) : null) : null;
    }
}

