/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.network;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.msrandom.witchery.init.WitcheryCreatureTraits;
import net.msrandom.witchery.network.WitcheryNetworkPacket;
import net.msrandom.witchery.transformation.VampireCreatureTrait;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnet/msrandom/witchery/network/PacketSelectPlayerAbility;", "Lnet/msrandom/witchery/network/WitcheryNetworkPacket;", "transformation", "Lnet/msrandom/witchery/transformation/VampireCreatureTrait;", "trigger", "", "(Lnet/msrandom/witchery/transformation/VampireCreatureTrait;Z)V", "buffer", "Lnet/minecraft/network/PacketBuffer;", "(Lnet/minecraft/network/PacketBuffer;)V", "vampirePower", "Lnet/msrandom/witchery/transformation/VampireCreatureTrait$Power;", "apply", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "write", "WitcheryResurrected"})
public final class PacketSelectPlayerAbility
implements WitcheryNetworkPacket {
    private final VampireCreatureTrait.Power vampirePower;
    private final boolean trigger;

    @Override
    public void write(@NotNull PacketBuffer buffer) {
        Intrinsics.checkParameterIsNotNull(buffer, "buffer");
        buffer.writeByte(this.vampirePower.ordinal());
        buffer.writeBoolean(this.trigger);
    }

    @Override
    public void apply(@NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull(player, "player");
        VampireCreatureTrait transformation = WitcheryUtils.getExtension(player).getTransformation(WitcheryCreatureTraits.VAMPIRE);
        transformation.setSelectedPower(this.vampirePower);
        if (this.trigger) {
            transformation.triggerSelectedPower(null);
        }
    }

    public PacketSelectPlayerAbility(@NotNull VampireCreatureTrait transformation, boolean trigger2) {
        Intrinsics.checkParameterIsNotNull(transformation, "transformation");
        this.vampirePower = transformation.getSelectedPower();
        this.trigger = trigger2;
    }

    public PacketSelectPlayerAbility(@NotNull PacketBuffer buffer) {
        Intrinsics.checkParameterIsNotNull(buffer, "buffer");
        this.vampirePower = VampireCreatureTrait.Power.VALUES[buffer.readByte()];
        this.trigger = buffer.readBoolean();
    }
}

