/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.network;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.msrandom.witchery.network.WitcheryNetworkPacket;
import net.msrandom.witchery.util.ResizingUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lnet/msrandom/witchery/network/PacketSyncEntitySize;", "Lnet/msrandom/witchery/network/WitcheryNetworkPacket;", "entity", "Lnet/minecraft/entity/Entity;", "(Lnet/minecraft/entity/Entity;)V", "buffer", "Lnet/minecraft/network/PacketBuffer;", "(Lnet/minecraft/network/PacketBuffer;)V", "entityID", "", "eyeHeight", "", "height", "stepSize", "width", "apply", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "write", "WitcheryResurrected"})
public final class PacketSyncEntitySize
implements WitcheryNetworkPacket {
    private final int entityID;
    private final float width;
    private final float height;
    private final float stepSize;
    private final float eyeHeight;

    @Override
    public void write(@NotNull PacketBuffer buffer) {
        Intrinsics.checkParameterIsNotNull(buffer, "buffer");
        buffer.func_150787_b(this.entityID);
        buffer.writeFloat(this.width);
        buffer.writeFloat(this.height);
        buffer.writeFloat(this.stepSize);
        buffer.writeFloat(this.eyeHeight);
    }

    @Override
    public void apply(@NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull(player, "player");
        Entity entity = player.field_70170_p.func_73045_a(this.entityID);
        if (entity != null) {
            ResizingUtils.setSize(entity, this.width, this.height);
            entity.field_70138_W = this.stepSize;
        }
    }

    public PacketSyncEntitySize(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull(entity, "entity");
        this.entityID = entity.func_145782_y();
        this.width = entity.field_70130_N;
        this.height = entity.field_70131_O;
        this.stepSize = entity.field_70138_W;
        this.eyeHeight = entity instanceof EntityPlayer ? ((EntityPlayer)entity).eyeHeight : -1.0f;
    }

    public PacketSyncEntitySize(@NotNull PacketBuffer buffer) {
        Intrinsics.checkParameterIsNotNull(buffer, "buffer");
        this.entityID = buffer.func_150792_a();
        this.width = buffer.readFloat();
        this.height = buffer.readFloat();
        this.stepSize = buffer.readFloat();
        this.eyeHeight = buffer.readFloat();
    }
}

