/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.potion;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.potion.IHandleLivingHurt;
import net.msrandom.witchery.potion.IHandleLivingUpdate;
import net.msrandom.witchery.potion.WitcheryPotion;
import net.msrandom.witchery.util.EntityUtil;

public class PotionFeelNoPain
extends WitcheryPotion
implements IHandleLivingHurt,
IHandleLivingUpdate {
    public PotionFeelNoPain(int color2) {
        super(color2);
        this.setIncurable();
    }

    @Override
    public void onLivingUpdate(World world, EntityLivingBase entity, LivingEvent.LivingUpdateEvent event, int amplifier, int duration) {
        if (!(world.field_72995_K || world.func_72820_D() % 20L != 2L || amplifier <= 0 || entity.func_70644_a(MobEffects.field_76431_k) || entity.func_70644_a(WitcheryPotionEffects.STOUT_BELLY) || world.field_73012_v.nextInt(5 - Math.min(amplifier, 3)) != 0)) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76431_k, (6 + amplifier * 2) * 20));
        }
    }

    @Override
    public boolean handleAllHurtEvents() {
        return false;
    }

    @Override
    public void onLivingHurt(World world, EntityLivingBase entity, LivingHurtEvent event, int amplifier) {
        if (!world.field_72995_K && entity instanceof EntityPlayer && (event.getSource().func_76355_l().equals("mob") || event.getSource().func_76355_l().equals("player") || event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityLivingBase)) {
            EntityPlayer player = (EntityPlayer)entity;
            float currentHealth = entity.func_110143_aJ();
            float newHealth = EntityUtil.getHealthAfterDamage(event, currentHealth, entity);
            float damage = currentHealth - newHealth;
            int food = player.func_71024_bL().func_75116_a();
            if (food > 0) {
                int modifiedDamage = (int)Math.ceil(amplifier > 0 ? (double)Math.max(damage / (float)amplifier, amplifier > 1 ? 1.0f : 2.0f) : (double)Math.max(damage * 2.0f, 3.0f));
                int foodPenalty = Math.min(modifiedDamage, food);
                player.func_71024_bL().func_75122_a(-foodPenalty, 2.0f);
                event.setCanceled(true);
            }
        }
    }
}

