/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.potion;

import kotlin.Unit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.EntityIllusion;
import net.msrandom.witchery.init.WitcheryEntities;
import net.msrandom.witchery.potion.WitcheryPotion;
import net.msrandom.witchery.util.WitcheryUtils;

public class PotionInsanity
extends WitcheryPotion {
    public PotionInsanity(int color2) {
        super(true, color2);
        this.setIncurable();
        this.setPermanent();
        this.hideInventoryText();
        this.hideUnknownText = true;
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return duration % 20 == 13;
    }

    public void func_76394_a(EntityLivingBase entity, int amplifier) {
        if (entity instanceof EntityPlayer) {
            World world = entity.field_70170_p;
            int level = Math.max(0, amplifier) + 1;
            if (world.field_73012_v.nextInt(level > 2 ? 25 : (level > 1 ? 30 : 35)) == 0) {
                EntityType<EntityIllusion> creatureType;
                switch (world.field_73012_v.nextInt(3)) {
                    default: {
                        creatureType = WitcheryEntities.ILLUSION_CREEPER;
                        break;
                    }
                    case 1: {
                        creatureType = WitcheryEntities.ILLUSION_SPIDER;
                        break;
                    }
                    case 2: {
                        creatureType = WitcheryEntities.ILLUSION_ZOMBIE;
                    }
                }
                WitcheryUtils.summonEntity(world, creatureType, entity.func_180425_c(), 4, 9, illusion -> {
                    illusion.func_70624_b(entity);
                    illusion.setVictimId(entity.func_110124_au());
                    return Unit.INSTANCE;
                });
            } else if (level >= 4 && world.field_73012_v.nextInt(20) == 0) {
                SoundEvent sound = world.field_73012_v.nextInt(3) == 1 ? SoundEvents.field_187529_aS : SoundEvents.field_187539_bB;
                WitcheryUtils.playSoundAt((EntityPlayer)entity, sound, entity.func_184176_by(), 1.0f, 1.0f);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventoryEffect(PotionEffect effect, Gui gui, int x, int y, float z) {
        super.renderInventoryEffect(effect, gui, x, y, z);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int factor = effect.func_76459_b() / 60 % 7;
        fontRenderer.func_175063_a(I18n.func_135052_a((String)(this.func_76393_a() + "." + factor), (Object[])new Object[0]), (float)(x + 10 + 18), (float)(y + 6), 0xFFFFFF);
        fontRenderer.func_175063_a(PotionInsanity.func_188410_a((PotionEffect)effect, (float)1.0f), (float)(x + 28), (float)(y + 16), 0x7F7F7F);
    }
}

