/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.potion;

import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.msrandom.witchery.entity.EntityVillageGuard;
import net.msrandom.witchery.entity.ai.EntityAIMoveTowardsVampire;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.potion.IHandleLivingHurt;
import net.msrandom.witchery.potion.IHandleLivingUpdate;
import net.msrandom.witchery.potion.WitcheryPotion;

public class PotionParalysis
extends WitcheryPotion
implements IHandleLivingUpdate,
IHandleLivingHurt {
    public PotionParalysis(int color2) {
        super(true, color2);
        this.setIncurable();
    }

    public static boolean isVillager(Entity entity) {
        return entity instanceof EntityVillager || entity instanceof EntityVillageGuard;
    }

    @Override
    public void init() {
        this.func_111184_a(SharedMonsterAttributes.field_111263_d, "E69059D5-CAE6-4695-9BE3-C6F0F22151E8", -40.0, 2);
    }

    @Override
    public void func_111185_a(EntityLivingBase entity, AbstractAttributeMap attributes, int amplifier) {
        if (this.canApplyToEntity(entity, amplifier)) {
            super.func_111185_a(entity, attributes, amplifier);
        } else if (PotionParalysis.isVillager((Entity)entity)) {
            EntityCreature creature2 = (EntityCreature)entity;
            creature2.func_70624_b(null);
            creature2.func_70604_c(null);
            creature2.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIMoveTowardsVampire(creature2, 0.8, 1.0f, 16.0f));
        }
    }

    @Override
    public void func_111187_a(EntityLivingBase entity, AbstractAttributeMap attributes, int amplifier) {
        if (this.canApplyToEntity(entity, amplifier)) {
            super.func_111187_a(entity, attributes, amplifier);
        } else if (PotionParalysis.isVillager((Entity)entity) && amplifier >= 5) {
            EntityCreature creature2 = (EntityCreature)entity;
            Iterator itr = creature2.field_70714_bg.field_75782_a.iterator();
            EntityAIBase task = null;
            while (itr.hasNext()) {
                EntityAITasks.EntityAITaskEntry entityaitaskentry = (EntityAITasks.EntityAITaskEntry)itr.next();
                EntityAIBase entityaibase1 = entityaitaskentry.field_75733_a;
                if (!(entityaibase1 instanceof EntityAIMoveTowardsVampire)) continue;
                task = entityaibase1;
                break;
            }
            if (task != null) {
                creature2.field_70714_bg.func_85156_a(task);
            }
        }
    }

    @Override
    public void onLivingUpdate(World world, EntityLivingBase entity, LivingEvent.LivingUpdateEvent event, int amplifier, int duration) {
        if (this.canApplyToEntity(entity, amplifier)) {
            if (!world.field_72995_K) {
                if (entity instanceof EntityCreeper) {
                    ((EntityCreeper)entity).func_70829_a(-1);
                }
                if (amplifier >= 4 && duration <= 1 && entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entity;
                    player.func_70690_d(new PotionEffect(WitcheryPotionEffects.QUEASY, 1800, 0, true, true));
                }
            }
            if (entity.field_70173_aa % 20 != 2 || !PotionParalysis.isVillager((Entity)entity) || amplifier < 5) {
                entity.field_70181_x = -0.2;
            }
        }
    }

    private boolean canApplyToEntity(EntityLivingBase entity, int amplifier) {
        return !(!entity.func_184222_aU() || amplifier >= 5 && PotionParalysis.isVillager((Entity)entity) || entity instanceof EntityPlayer && amplifier < 2);
    }

    @Override
    public void onLivingHurt(World world, EntityLivingBase entity, LivingHurtEvent event, int amplifier) {
        if (!world.field_72995_K && amplifier >= 4 && event.getAmount() >= 1.0f) {
            entity.func_184589_d((Potion)this);
        }
    }

    @Override
    public boolean handleAllHurtEvents() {
        return false;
    }
}

