/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.potion;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.msrandom.witchery.network.PacketSyncEntitySize;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.potion.IHandleLivingHurt;
import net.msrandom.witchery.potion.IHandleLivingJump;
import net.msrandom.witchery.potion.IHandleLivingUpdate;
import net.msrandom.witchery.potion.IHandlePreRenderLiving;
import net.msrandom.witchery.potion.IHandleRenderLiving;
import net.msrandom.witchery.potion.WitcheryPotion;
import net.msrandom.witchery.util.EntitySizeInfo;
import net.msrandom.witchery.util.ResizingUtils;

public class PotionResizing
extends WitcheryPotion
implements IHandlePreRenderLiving,
IHandleRenderLiving,
IHandleLivingUpdate,
IHandleLivingHurt,
IHandleLivingJump {
    public PotionResizing(int color2) {
        super(color2);
    }

    public static float getModifiedScaleFactor(EntityLivingBase entity, int amplifier) {
        float currentHeight = entity.field_70131_O;
        EntitySizeInfo sizeInfo = new EntitySizeInfo(entity);
        float ratio = currentHeight / PotionResizing.getDefaultHeight(sizeInfo, amplifier);
        float factor = PotionResizing.getTargetHeight(sizeInfo, amplifier);
        return factor < 1.0f ? Math.max(ratio, factor) : Math.min(ratio, factor);
    }

    public static float getScaleFactor(int amplifier) {
        amplifier = MathHelper.func_76130_a((int)amplifier);
        return MathHelper.func_76126_a((float)((float)amplifier * 0.7f - 3.0f)) + (float)amplifier + (float)MathHelper.func_76141_d((float)MathHelper.func_76125_a((int)(amplifier - 1), (int)0, (int)1)) * 0.5f + 0.38f;
    }

    private static float getDefaultHeight(EntitySizeInfo sizeInfo, int amplifier) {
        return amplifier < 0 ? PotionResizing.getScaleFactor(amplifier) * 2.0f : sizeInfo.defaultHeight;
    }

    private static float getTargetHeight(EntitySizeInfo sizeInfo, int amplifier) {
        return amplifier < 0 ? 1.0f : PotionResizing.getScaleFactor(amplifier);
    }

    private static int getSize(PotionEffect amplifier) {
        if (amplifier == null) {
            return 3;
        }
        switch (amplifier.func_76458_c()) {
            default: {
                return 3;
            }
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: 
        }
        return 5;
    }

    public static float getDamageMultiplier(PotionEffect amplifierA, PotionEffect amplifierB) {
        int sizeA = PotionResizing.getSize(amplifierA);
        int sizeB = PotionResizing.getSize(amplifierB);
        return sizeA / sizeB;
    }

    @Override
    public void func_111187_a(EntityLivingBase entity, AbstractAttributeMap attributes, int amplifier) {
        EntitySizeInfo sizeInfo = new EntitySizeInfo(entity);
        ResizingUtils.setSize((Entity)entity, sizeInfo.defaultWidth, sizeInfo.defaultHeight);
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            player.eyeHeight = sizeInfo.eyeHeight;
        }
        entity.field_70138_W = sizeInfo.stepSize;
        WitcheryNetworkChannel.sendToAll(new PacketSyncEntitySize((Entity)entity));
        super.func_111187_a(entity, attributes, amplifier);
    }

    @Override
    public void onLivingRender(EntityLivingBase entity, RenderLivingEvent.Pre<EntityLivingBase> event, int amplifier) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)event.getX(), (double)event.getY(), (double)event.getZ());
        float scale = PotionResizing.getModifiedScaleFactor(entity, amplifier);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179137_b((double)(-event.getX()), (double)(-event.getY()), (double)(-event.getZ()));
    }

    @Override
    public void onLivingRender(EntityLivingBase entity, RenderLivingEvent.Post<EntityLivingBase> event) {
        GlStateManager.func_179121_F();
    }

    @Override
    public void onLivingUpdate(World world, EntityLivingBase entity, LivingEvent.LivingUpdateEvent event, int amplifier, int duration) {
        float reductionFactor = 0.03f * (float)(event.getEntity().field_70170_p.field_72995_K ? 1 : 20);
        if (world.field_72995_K || entity.field_70173_aa % 20 == 0) {
            EntitySizeInfo sizeInfo = new EntitySizeInfo(entity);
            float scale = PotionResizing.getScaleFactor(amplifier);
            float requiredHeight = sizeInfo.defaultHeight * scale;
            float requiredWidth = sizeInfo.defaultWidth * scale;
            float currentHeight = event.getEntityLiving().field_70131_O;
            if (requiredHeight != currentHeight) {
                if (entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entity;
                    if (!world.field_72995_K) {
                        player.eyeHeight = currentHeight * 0.92f;
                    }
                }
                float f = entity.field_70138_W = scale < 1.0f ? 0.0f : scale - 1.0f;
                if (scale < 1.0f) {
                    ResizingUtils.setSize((Entity)entity, Math.max(entity.field_70130_N - reductionFactor, requiredWidth), Math.max(currentHeight - reductionFactor, requiredHeight));
                } else {
                    ResizingUtils.setSize((Entity)entity, Math.min(entity.field_70130_N + reductionFactor, requiredWidth), Math.min(currentHeight + reductionFactor, requiredHeight));
                }
            }
        }
    }

    @Override
    public boolean handleAllHurtEvents() {
        return true;
    }

    @Override
    public void onLivingHurt(World world, EntityLivingBase entity, LivingHurtEvent event, int amplifier) {
        if (!world.field_72995_K) {
            PotionEffect effectDefender = entity.func_70660_b((Potion)this);
            boolean isDefenderShrunken = effectDefender != null;
            DamageSource source = event.getSource();
            if (source.func_76355_l().equals("mob") || source.func_76355_l().equals("player")) {
                if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityLivingBase) {
                    EntityLivingBase attacker = (EntityLivingBase)source.func_76346_g();
                    PotionEffect effectAttacker = attacker.func_70660_b((Potion)this);
                    if (isDefenderShrunken || effectAttacker != null) {
                        float scale = PotionResizing.getDamageMultiplier(effectAttacker, effectDefender);
                        event.setAmount(event.getAmount() * Math.max(Math.min(scale, 3.0f), 0.5f));
                    }
                }
            } else if (source == DamageSource.field_76379_h && isDefenderShrunken && PotionResizing.getScaleFactor(effectDefender.func_76458_c()) > event.getAmount()) {
                event.setCanceled(true);
            }
        }
    }

    @Override
    public void onLivingJump(LivingEvent.LivingJumpEvent event, int amplifier) {
        float scale = PotionResizing.getScaleFactor(amplifier);
        if (scale > 1.0f) {
            EntityLivingBase entityLiving = event.getEntityLiving();
            entityLiving.field_70181_x *= (double)scale * 0.5 + 0.5;
        } else {
            EntityLivingBase entityLiving2 = event.getEntityLiving();
            entityLiving2.field_70181_x *= Math.max((double)scale, 0.5) * 1.5;
        }
    }
}

