/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.potion;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.msrandom.witchery.potion.WitcheryPotion;
import net.msrandom.witchery.util.BlockActionCircle;
import net.msrandom.witchery.util.WitcheryUtils;

public class PotionSnowTrail
extends WitcheryPotion {
    public PotionSnowTrail(int color2) {
        super(color2);
    }

    public static void createSnowCovering(World world, BlockPos pos, int radius, EntityPlayer source) {
        if (WitcheryUtils.isBlockBreakable(world, pos)) {
            new BlockActionCircle(){

                @Override
                public void onBlock(World world, BlockPos pos) {
                    int maxSearch = 8;
                    if (world.func_175623_d(pos)) {
                        for (BlockPos dy : BlockPos.func_177980_a((BlockPos)pos, (BlockPos)pos.func_177979_c(maxSearch - 1))) {
                            IBlockState block = world.func_180495_p(dy);
                            if (block.func_185904_a() == Material.field_151579_a) continue;
                            this.setBlockToSnow(world, dy.func_177984_a(), block);
                            break;
                        }
                    } else {
                        for (BlockPos dy : BlockPos.func_177980_a((BlockPos)pos, (BlockPos)pos.func_177981_b(maxSearch - 1))) {
                            IBlockState block = world.func_180495_p(dy);
                            if (block.func_185904_a() != Material.field_151579_a) continue;
                            IBlockState blockBelow = world.func_180495_p(dy.func_177977_b());
                            this.setBlockToSnow(world, dy, blockBelow);
                            break;
                        }
                    }
                }

                private void setBlockToSnow(World world, BlockPos pos, IBlockState blockBelow) {
                    if (blockBelow.func_185914_p() || blockBelow.func_185904_a() == Material.field_151584_j) {
                        world.func_175656_a(pos, Blocks.field_150431_aC.func_176223_P());
                    }
                }
            }.processFilledCircle(world, pos, radius);
        }
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return duration % 10 == 0;
    }

    public void func_76394_a(EntityLivingBase entity, int amplifier) {
        if (!entity.field_70170_p.field_72995_K) {
            for (int l = 0; l < 4; ++l) {
                float temp;
                int k;
                int j;
                int i = MathHelper.func_76128_c((double)(entity.field_70165_t + (double)((float)(l % 2 * 2 - 1) * 0.25f)));
                BlockPos pos = new BlockPos(i, j = MathHelper.func_76128_c((double)entity.field_70163_u), k = MathHelper.func_76128_c((double)(entity.field_70161_v + (double)(((float)l / 2.0f % 2.0f * 2.0f - 1.0f) * 0.25f))));
                if (entity.field_70170_p.func_180495_p(pos).func_185904_a() != Material.field_151579_a || !((temp = entity.field_70170_p.getBiomeForCoordsBody(pos).func_180626_a(pos)) < 1.6f) || !Blocks.field_150431_aC.func_176196_c(entity.field_70170_p, pos)) continue;
                entity.field_70170_p.func_175656_a(pos, Blocks.field_150431_aC.func_176223_P());
            }
            if (entity instanceof EntitySnowman && entity.field_70170_p.field_73012_v.nextInt(20) == 0) {
                entity.field_70170_p.func_72876_a((Entity)entity, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 3.0f, false);
                PotionSnowTrail.createSnowCovering(entity.field_70170_p, entity.func_180425_c(), 8, null);
                entity.func_70106_y();
            }
        }
    }
}

