/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.potion;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.potion.IHandleLivingHurt;
import net.msrandom.witchery.potion.WitcheryPotion;
import net.msrandom.witchery.util.WitcheryUtils;

public class PotionVolatility
extends WitcheryPotion
implements IHandleLivingHurt {
    public PotionVolatility(int color2) {
        super(true, color2);
        this.setIncurable();
    }

    @Override
    public boolean handleAllHurtEvents() {
        return false;
    }

    @Override
    public void onLivingHurt(World world, EntityLivingBase entity, LivingHurtEvent event, int amplifier) {
        if (!world.field_72995_K && this.canExplode(event.getSource())) {
            boolean breakable = WitcheryConfigOptions.allowVolatilityPotionBlockDamage;
            if (breakable) {
                breakable = WitcheryUtils.isBlockBreakable(world, entity.func_180425_c());
            }
            if (event.getSource().func_94541_c() || world.field_73012_v.nextInt(5 - Math.min(amplifier, 3)) == 0) {
                if (world.field_73012_v.nextInt(amplifier + 3) == 0) {
                    entity.func_184589_d((Potion)this);
                }
                world.func_72876_a((Entity)(event.getSource().func_94541_c() ? entity : null), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, Math.min(2.0f + 0.5f * (float)amplifier, 3.0f), breakable);
            }
        }
    }

    private boolean canExplode(DamageSource source) {
        return source != DamageSource.field_76369_e && source != DamageSource.field_76368_d && source != DamageSource.field_76379_h && source != DamageSource.field_76380_i && source != DamageSource.field_76366_f;
    }
}

