/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.potion;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketRemoveEntityEffect;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.potion.IHandleRenderLiving;

public class WitcheryPotion
extends Potion {
    private static final ResourceLocation UNKNOWN = new ResourceLocation("witchery", "textures/mob_effect/unknown.png");
    private static final Map<WitcheryPotion, ResourceLocation> TEXTURES = new HashMap<WitcheryPotion, ResourceLocation>();
    protected boolean hideUnknownText;
    private boolean inventoryTextHidden;
    private boolean incurable;
    private boolean permanent;

    public WitcheryPotion(int color2) {
        this(false, color2);
    }

    public WitcheryPotion(boolean debuff, int color2) {
        super(debuff, color2);
    }

    public static boolean isDebuff(Potion potion) {
        return potion.func_76398_f();
    }

    public static boolean isCurable(Potion potion) {
        return !(potion instanceof WitcheryPotion) || ((WitcheryPotion)potion).isCurable();
    }

    public WitcheryPotion getPotion() {
        return this;
    }

    public boolean isCurable() {
        return !this.incurable;
    }

    public boolean isPermanent() {
        return this.permanent;
    }

    public void setIncurable() {
        this.incurable = true;
    }

    public void setPermanent() {
        this.permanent = true;
    }

    protected void hideInventoryText() {
        this.inventoryTextHidden = true;
    }

    public void init() {
    }

    public void func_111185_a(EntityLivingBase entity, AbstractAttributeMap attributes, int amplifier) {
        super.func_111185_a(entity, attributes, amplifier);
        if (this instanceof IHandleRenderLiving) {
            PotionEffect effect = entity.func_70660_b((Potion)this);
            for (EntityPlayer player : entity.field_70170_p.field_73010_i) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(entity.func_145782_y(), effect));
            }
        }
    }

    public void func_111187_a(EntityLivingBase entity, AbstractAttributeMap attributes, int amplifier) {
        super.func_111187_a(entity, attributes, amplifier);
        if (this instanceof IHandleRenderLiving) {
            for (EntityPlayer player : entity.field_70170_p.field_73010_i) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketRemoveEntityEffect(entity.func_145782_y(), (Potion)this));
            }
        }
    }

    public boolean shouldRenderInvText(PotionEffect effect) {
        return !this.inventoryTextHidden;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventoryEffect(PotionEffect effect, Gui gui, int x, int y, float z) {
        if (this.inventoryTextHidden && !this.hideUnknownText) {
            Minecraft.func_71410_x().field_71466_p.func_175063_a(I18n.func_135052_a((String)"effect.witchery.unknown", (Object[])new Object[0]), (float)(x + 10 + 18), (float)(y + 6), 0xFFFFFF);
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getTexture());
        Gui.func_146110_a((int)(x + 6), (int)(y + 7), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUDEffect(PotionEffect effect, Gui gui, int x, int y, float z, float alpha) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getTexture());
        Gui.func_146110_a((int)(x + 3), (int)(y + 3), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
    }

    private ResourceLocation getTexture() {
        return TEXTURES.computeIfAbsent(this, k -> {
            if (k.inventoryTextHidden) {
                return UNKNOWN;
            }
            ResourceLocation id = (ResourceLocation)Potion.field_188414_b.func_177774_c((Object)k);
            return new ResourceLocation(id.func_110624_b(), "textures/mob_effect/" + id.func_110623_a() + ".png");
        });
    }
}

