/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.prediction;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Constructor;
import java.util.function.BiConsumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.prediction.Prediction;
import net.msrandom.witchery.prediction.PredictionSerializer;
import org.jetbrains.annotations.NotNull;

public class PredictionFight<T extends EntityLiving>
extends Prediction {
    private final Class<T> entityClass;
    private final String damage;
    private final BiConsumer<EntityPlayer, T> spawnAction;

    public PredictionFight(int weight, String translationKey, Class<T> entityClass, String damage, BiConsumer<EntityPlayer, T> spawnAction) {
        super(weight, translationKey);
        this.entityClass = entityClass;
        this.damage = damage;
        this.spawnAction = spawnAction;
    }

    @Override
    public boolean doSelfFulfillment(EntityPlayer player) {
        try {
            BlockPos pos = player.func_180425_c();
            World world = player.field_70170_p;
            if (!world.field_72995_K) {
                int hy;
                int az;
                int radius = 2;
                int rangeSq = radius * radius;
                int ax = world.field_73012_v.nextInt(radius * 2 + 1);
                if (ax > radius) {
                    ax += rangeSq;
                }
                if ((az = world.field_73012_v.nextInt(radius * 2 + 1)) > radius) {
                    az += rangeSq;
                }
                BlockPos p = pos.func_177982_a(ax - rangeSq, 0, az - rangeSq);
                while (!world.func_175623_d(p) && p.func_177956_o() < pos.func_177956_o() + 8) {
                    p = p.func_177984_a();
                }
                while (world.func_175623_d(p) && p.func_177956_o() > 0) {
                    p = p.func_177977_b();
                }
                for (hy = 0; world.func_175623_d(p.func_177981_b(hy + 1)) && hy < 6; ++hy) {
                }
                Constructor<T> ctor = this.entityClass.getConstructor(World.class);
                EntityLiving entity = (EntityLiving)ctor.newInstance(world);
                if ((float)hy < entity.field_70131_O) {
                    return false;
                }
                entity.func_70012_b((double)p.func_177958_n() + 0.5, (double)p.func_177956_o() + 1.05, (double)p.func_177952_p() + 0.5, 0.0f, 0.0f);
                entity.func_180482_a(world.func_175649_E(entity.func_180425_c()), null);
                this.spawnAction.accept(player, (EntityPlayer)entity);
                world.func_72838_d((Entity)entity);
                WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.5f, 2.0f, EnumParticleTypes.SMOKE_NORMAL), (Entity)entity);
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public boolean checkHurtFulfillment(World world, EntityPlayer player, DamageSource source) {
        if (this.damage == null) {
            Entity attackingEntity = source.func_76346_g();
            return attackingEntity != null && this.entityClass.isAssignableFrom(attackingEntity.getClass());
        }
        return source.field_76373_n.equals(this.damage);
    }

    public static class Serializer<T extends EntityLiving>
    implements PredictionSerializer<PredictionFight<T>> {
        private final BiConsumer<EntityPlayer, T> spawnAction;

        public Serializer(BiConsumer<EntityPlayer, T> spawnAction) {
            this.spawnAction = spawnAction;
        }

        @Override
        @NotNull
        public PredictionFight<T> read(int weight, @NotNull String translationKey, @NotNull JsonObject json) {
            JsonElement element = json.get("damage_type");
            return new PredictionFight<T>(weight, translationKey, EntityList.getClass((ResourceLocation)new ResourceLocation(json.get("entity").getAsString())), element == null ? null : element.getAsString(), this.spawnAction);
        }
    }
}

