/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.prediction;

import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.msrandom.witchery.prediction.Prediction;
import net.msrandom.witchery.util.WitcheryUtils;

public class PredictionNetherTrip
extends Prediction {
    public PredictionNetherTrip(int weight, String translationKey) {
        super(weight, translationKey);
    }

    @Override
    public boolean isPredictionPossible(EntityPlayer player) {
        return player.field_71093_bK != -1 && WitcheryUtils.getExtension(player).hasVisitedNether();
    }

    @Override
    public boolean doSelfFulfillment(EntityPlayer player) {
        int RADIUS = 1;
        int x = MathHelper.func_76128_c((double)player.field_70165_t);
        int y = MathHelper.func_76128_c((double)player.field_70163_u) - RADIUS;
        int z = MathHelper.func_76128_c((double)player.field_70161_v);
        if (!player.field_70170_p.field_72995_K && player.field_71093_bK != -1) {
            int hy;
            int ny;
            player.func_145747_a(new TextComponentTranslation("prediction.witchery.nether_trip.summoned", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.LIGHT_PURPLE)));
            player.func_181015_d(player.func_180425_c());
            World world3 = player.field_70170_p;
            int MAX_DISTANCE = 4;
            int MIN_DISTANCE = 2;
            int activeRadius = 2;
            int ax = world3.field_73012_v.nextInt(activeRadius * MIN_DISTANCE + RADIUS);
            if (ax > activeRadius) {
                ax += MAX_DISTANCE;
            }
            int nx = x - 4 + ax;
            int az = world3.field_73012_v.nextInt(activeRadius * MIN_DISTANCE + RADIUS);
            if (az > activeRadius) {
                az += MAX_DISTANCE;
            }
            int nz = z - 4 + az;
            for (ny = y; !world3.func_175623_d(new BlockPos(nx, ny, nz)) && ny < y + 8; ++ny) {
            }
            while (world3.func_175623_d(new BlockPos(nx, ny, nz)) && ny > 0) {
                --ny;
            }
            for (hy = 0; world3.func_175623_d(new BlockPos(nx, ny + hy + RADIUS, nz)) && hy < 6; ++hy) {
            }
            EntityBlaze entity = new EntityBlaze(world3);
            if ((float)hy >= entity.field_70131_O) {
                entity.func_70012_b((double)nx, (double)ny, (double)nz, 0.0f, 0.0f);
                world3.func_72838_d((Entity)entity);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean checkNormalFulfillment(World world, EntityPlayer player, boolean isPastDue) {
        return player.field_71093_bK == -1;
    }
}

