/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.prediction;

import com.google.gson.JsonObject;
import java.lang.reflect.Constructor;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.prediction.PredictionAlwaysForced;
import net.msrandom.witchery.prediction.PredictionSerializer;
import org.jetbrains.annotations.NotNull;

public class PredictionRescue<T extends EntityLiving>
extends PredictionAlwaysForced {
    private final Class<T> entityClass;
    private final Consumer<T> spawnAction;

    public PredictionRescue(int weight, String translationKey, int duration, Class<T> entityClass, Consumer<T> spawnAction) {
        super(weight, translationKey, duration);
        this.entityClass = entityClass;
        this.spawnAction = spawnAction;
    }

    @Override
    public boolean checkHurtFulfillment(World world, EntityPlayer player, DamageSource source) {
        Entity attackingEntity = source.func_76346_g();
        if (attackingEntity instanceof EntityLivingBase) {
            try {
                int x = MathHelper.func_76128_c((double)player.field_70165_t);
                int y = MathHelper.func_76128_c((double)player.field_70163_u);
                int z = MathHelper.func_76128_c((double)player.field_70161_v);
                if (!world.field_72995_K) {
                    int hy;
                    int ny;
                    int MAX_DISTANCE = 4;
                    int activeRadius = 2;
                    int ax = world.field_73012_v.nextInt(activeRadius * 2 + 1);
                    if (ax > activeRadius) {
                        ax += MAX_DISTANCE;
                    }
                    int nx = x - MAX_DISTANCE + ax;
                    int az = world.field_73012_v.nextInt(activeRadius * 2 + 1);
                    if (az > activeRadius) {
                        az += MAX_DISTANCE;
                    }
                    int nz = z - MAX_DISTANCE + az;
                    for (ny = y; !world.func_175623_d(new BlockPos(nx, ny, nz)) && ny < y + 8; ++ny) {
                    }
                    while (world.func_175623_d(new BlockPos(nx, ny, nz)) && ny > 0) {
                        --ny;
                    }
                    for (hy = 0; world.func_175623_d(new BlockPos(nx, ny + hy + 1, nz)) && hy < 6; ++hy) {
                    }
                    Constructor<T> ctor = this.entityClass.getConstructor(World.class);
                    EntityLiving entity = (EntityLiving)ctor.newInstance(world);
                    if ((float)hy >= entity.field_70131_O) {
                        entity.func_70012_b(0.5 + (double)nx, 0.05 + (double)ny + 1.0, 0.5 + (double)nz, 0.0f, 0.0f);
                        world.func_72838_d((Entity)entity);
                        entity.func_180482_a(world.func_175649_E(entity.func_180425_c()), null);
                        if (this.spawnAction != null) {
                            this.spawnAction.accept(entity);
                        }
                        entity.func_70624_b((EntityLivingBase)attackingEntity);
                        if (entity instanceof EntityCreature) {
                            entity.func_70604_c((EntityLivingBase)attackingEntity);
                        }
                        WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.5f, 2.0f, EnumParticleTypes.SMOKE_NORMAL), (Entity)entity);
                        return true;
                    }
                    return false;
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return false;
    }

    public static class Serializer
    implements PredictionSerializer<PredictionRescue<?>> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        @NotNull
        public PredictionRescue<?> read(int weight, String translationKey, @NotNull JsonObject json) {
            return new PredictionRescue(weight, translationKey, json.get("fulfillment_duration").getAsInt(), EntityList.getClass((ResourceLocation)new ResourceLocation(json.get("rescuer").getAsString())), null);
        }
    }
}

