/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.prediction;

import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.msrandom.witchery.prediction.Prediction;
import net.msrandom.witchery.util.WitcheryUtils;

public class PredictionWet
extends Prediction {
    private final int depth;

    public PredictionWet(int weight, String translationKey, int depth) {
        super(weight, translationKey);
        this.depth = depth;
    }

    @Override
    public boolean doSelfFulfillment(EntityPlayer player) {
        int RADIUS = 1;
        int x0 = MathHelper.func_76128_c((double)player.field_70165_t);
        int y0 = MathHelper.func_76128_c((double)player.field_70163_u) - RADIUS;
        int z0 = MathHelper.func_76128_c((double)player.field_70161_v);
        World world = player.field_70170_p;
        if (!world.field_72995_K && y0 > 5 && !world.field_73011_w.func_177495_o()) {
            int z2;
            int x2;
            int dirtCount = 0;
            for (x2 = x0 - RADIUS; x2 <= x0 + RADIUS; ++x2) {
                for (z2 = z0 - RADIUS; z2 <= z0 + RADIUS; ++z2) {
                    Material material = world.func_180495_p(new BlockPos(x2, y0, z2)).func_185904_a();
                    if (material != Material.field_151578_c && material != Material.field_151577_b) continue;
                    ++dirtCount;
                }
            }
            if (dirtCount == 9) {
                for (x2 = x0 - RADIUS; x2 <= x0 + RADIUS; ++x2) {
                    for (z2 = z0 - RADIUS; z2 <= z0 + RADIUS; ++z2) {
                        for (int y2 = y0; y2 > y0 - this.depth; --y2) {
                            BlockPos pos = new BlockPos(x2, y2, z2);
                            if (y2 == y0) {
                                world.func_175656_a(pos, Blocks.field_150351_n.func_176223_P());
                                continue;
                            }
                            if (!WitcheryUtils.canBreak(world.func_180495_p(pos))) continue;
                            world.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean checkNormalFulfillment(World world, EntityPlayer player, boolean isPastDue) {
        return player.func_70026_G();
    }
}

