/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.recipe;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.msrandom.witchery.block.BlockWitchCrop;
import net.msrandom.witchery.init.data.recipes.WitcheryRecipeSerializers;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.recipe.brazier.BrazierRecipe;
import net.msrandom.witchery.util.CreatureUtil;
import org.jetbrains.annotations.NotNull;

public class BrazierDrainGrowthRecipe
extends BrazierRecipe {
    public BrazierDrainGrowthRecipe(@NotNull ResourceLocation id, @NotNull NonNullList<Ingredient> inputs, int burnTime, boolean needsPower, boolean hidden) {
        super(id, WitcheryRecipeSerializers.getBrazierDrainGrowth(), inputs, burnTime, needsPower, hidden);
    }

    @Override
    public int onBurning(World world, BlockPos pos, long ticks) {
        if (ticks % 5L == 0L) {
            int offsetY = (int)(ticks % 30L) / 5;
            int radius = 3;
            BlockPos p = pos.func_177982_a(world.field_73012_v.nextInt(7) - radius, offsetY - 2, world.field_73012_v.nextInt(7) - radius);
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() instanceof IPlantable) {
                IBlockState currentState;
                IPlantable plantable = (IPlantable)state;
                if ((state instanceof BlockWitchCrop || plantable.getPlantType((IBlockAccess)world, p) == EnumPlantType.Crop) && (currentState = plantable.getPlant((IBlockAccess)world, p)) != state.func_177230_c().func_176223_P()) {
                    world.func_175656_a(p, state.func_177230_c().func_176223_P());
                    WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, 0.3f, 0.5f, EnumParticleTypes.SPELL_MOB), world, pos.func_177984_a(), 8.0);
                    this.healNearbyUndead(world, p, radius);
                    return 2;
                }
            }
        }
        return 0;
    }

    private void healNearbyUndead(World world, BlockPos pos, int radius) {
        AxisAlignedBB bb = new AxisAlignedBB(pos.func_177982_a(-radius, -radius, -radius), pos.func_177982_a(radius, radius, radius));
        List entities = world.func_72872_a(EntityLivingBase.class, bb);
        for (EntityLivingBase entity : entities) {
            if (!CreatureUtil.isUndead((Entity)entity)) continue;
            float maxHealth = entity.func_110138_aP();
            if (entity.func_110143_aJ() >= maxHealth) continue;
            entity.func_70691_i(maxHealth * 0.1f);
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.5f, 1.0f, EnumParticleTypes.HEART), (Entity)entity);
        }
    }
}

