/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCauldron;
import net.msrandom.witchery.init.data.recipes.WitcheryRecipeTypes;
import net.msrandom.witchery.recipe.WitcheryRecipe;
import net.msrandom.witchery.recipe.WitcheryRecipeSerializer;
import net.msrandom.witchery.recipe.WitcheryRecipeType;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002%&B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00022\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0011H\u0016J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\b\u0010\u001f\u001a\u00020\u0006H\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\bH\u0016J\b\u0010\"\u001a\u00020\fH\u0016J\u000e\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006'"}, d2={"Lnet/msrandom/witchery/recipe/CauldronRecipe;", "Lnet/msrandom/witchery/recipe/WitcheryRecipe;", "Lnet/msrandom/witchery/block/entity/TileEntityCauldron;", "id", "Lnet/minecraft/util/ResourceLocation;", "recipeGroup", "", "inputs", "Lnet/minecraft/util/NonNullList;", "Lnet/msrandom/witchery/recipe/CauldronRecipe$PoweredItem;", "triggerIngredient", "result", "Lnet/minecraft/item/ItemStack;", "(Lnet/minecraft/util/ResourceLocation;Ljava/lang/String;Lnet/minecraft/util/NonNullList;Lnet/msrandom/witchery/recipe/CauldronRecipe$PoweredItem;Lnet/minecraft/item/ItemStack;)V", "getInputs", "()Lnet/minecraft/util/NonNullList;", "power", "", "getPower", "()I", "getTriggerIngredient", "()Lnet/msrandom/witchery/recipe/CauldronRecipe$PoweredItem;", "canCraft", "", "inventory", "world", "Lnet/minecraft/world/World;", "canFit", "width", "height", "craft", "getGroup", "getIngredients", "Lnet/minecraft/item/crafting/Ingredient;", "getRecipeOutput", "isItemValid", "stack", "PoweredItem", "Serializer", "WitcheryResurrected"})
public final class CauldronRecipe
extends WitcheryRecipe<TileEntityCauldron> {
    private final String recipeGroup;
    @NotNull
    private final NonNullList<PoweredItem> inputs;
    @NotNull
    private final PoweredItem triggerIngredient;
    private final ItemStack result;

    public final int getPower() {
        int power = this.triggerIngredient.getPower();
        for (PoweredItem input : this.inputs) {
            power += input.getPower();
        }
        return power;
    }

    @Override
    public boolean canCraft(@NotNull TileEntityCauldron inventory, @Nullable World world) {
        Intrinsics.checkParameterIsNotNull(inventory, "inventory");
        return this.triggerIngredient.getIngredient().test((Object)inventory.getTopStack());
    }

    @Override
    @NotNull
    public ItemStack craft(@NotNull TileEntityCauldron inventory) {
        ItemStack itemStack;
        Intrinsics.checkParameterIsNotNull(inventory, "inventory");
        ArrayList inputsToFind = new ArrayList((Collection)this.inputs);
        Iterator iterator2 = inputsToFind.iterator();
        Intrinsics.checkExpressionValueIsNotNull(iterator2, "inputsToFind.iterator()");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            PoweredItem ingredient = (PoweredItem)iterator3.next();
            for (ItemStack item : inventory.getActions().items) {
                if (!ingredient.getIngredient().test((Object)item)) continue;
                iterator3.remove();
            }
        }
        if (inputsToFind.size() == 0) {
            ItemStack itemStack2 = this.result.func_77946_l();
            itemStack = itemStack2;
            Intrinsics.checkExpressionValueIsNotNull(itemStack2, "result.copy()");
        } else {
            ItemStack itemStack3 = ItemStack.field_190927_a;
            itemStack = itemStack3;
            Intrinsics.checkExpressionValueIsNotNull(itemStack3, "ItemStack.EMPTY");
        }
        return itemStack;
    }

    public boolean func_194133_a(int width, int height2) {
        return true;
    }

    @NotNull
    public ItemStack func_77571_b() {
        return this.result;
    }

    @NotNull
    public String func_193358_e() {
        String string = this.recipeGroup;
        if (string == null) {
            String string2 = super.func_193358_e();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull(string2, "super.getGroup()");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public NonNullList<Ingredient> func_192400_c() {
        void var2_2;
        void $this$mapTo$iv;
        Iterable iterable = (Iterable)this.inputs;
        Collection destination$iv = (Collection)NonNullList.func_191196_a();
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv.iterator();
        while (iterator2.hasNext()) {
            void receiver;
            Object item$iv;
            Object t = item$iv = iterator2.next();
            Collection collection = destination$iv;
            boolean bl = false;
            Ingredient ingredient = ((PoweredItem)receiver).getIngredient();
            collection.add(ingredient);
        }
        iterable = var2_2;
        boolean bl = false;
        boolean bl2 = false;
        NonNullList $this$apply = (NonNullList)iterable;
        boolean bl3 = false;
        $this$apply.add((Object)this.triggerIngredient.getIngredient());
        Iterable iterable2 = iterable;
        Intrinsics.checkExpressionValueIsNotNull(iterable2, "inputs.mapTo(NonNullList\u2026rIngredient.ingredient) }");
        return (NonNullList)iterable2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isItemValid(@NotNull ItemStack stack) {
        PoweredItem it;
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        if (this.triggerIngredient.getIngredient().test((Object)stack)) return true;
        Iterable $this$any$iv = (Iterable)this.inputs;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (PoweredItem)element$iv;
            boolean bl = false;
        } while (!it.getIngredient().test((Object)stack));
        return true;
    }

    @NotNull
    public final NonNullList<PoweredItem> getInputs() {
        return this.inputs;
    }

    @NotNull
    public final PoweredItem getTriggerIngredient() {
        return this.triggerIngredient;
    }

    public CauldronRecipe(@NotNull ResourceLocation id, @Nullable String recipeGroup, @NotNull NonNullList<PoweredItem> inputs, @NotNull PoweredItem triggerIngredient, @NotNull ItemStack result2) {
        Intrinsics.checkParameterIsNotNull(id, "id");
        Intrinsics.checkParameterIsNotNull(inputs, "inputs");
        Intrinsics.checkParameterIsNotNull(triggerIngredient, "triggerIngredient");
        Intrinsics.checkParameterIsNotNull(result2, "result");
        super(id, WitcheryRecipeTypes.CAULDRON.getSerializer());
        this.recipeGroup = recipeGroup;
        this.inputs = inputs;
        this.triggerIngredient = triggerIngredient;
        this.result = result2;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lnet/msrandom/witchery/recipe/CauldronRecipe$PoweredItem;", "", "ingredient", "Lnet/minecraft/item/crafting/Ingredient;", "power", "", "(Lnet/minecraft/item/crafting/Ingredient;I)V", "getIngredient", "()Lnet/minecraft/item/crafting/Ingredient;", "getPower", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "WitcheryResurrected"})
    public static final class PoweredItem {
        @NotNull
        private final Ingredient ingredient;
        private final int power;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final Ingredient getIngredient() {
            return this.ingredient;
        }

        public final int getPower() {
            return this.power;
        }

        public PoweredItem(@NotNull Ingredient ingredient, int power) {
            Intrinsics.checkParameterIsNotNull(ingredient, "ingredient");
            this.ingredient = ingredient;
            this.power = power;
        }

        @NotNull
        public final Ingredient component1() {
            return this.ingredient;
        }

        public final int component2() {
            return this.power;
        }

        @NotNull
        public final PoweredItem copy(@NotNull Ingredient ingredient, int power) {
            Intrinsics.checkParameterIsNotNull(ingredient, "ingredient");
            return new PoweredItem(ingredient, power);
        }

        public static /* synthetic */ PoweredItem copy$default(PoweredItem poweredItem, Ingredient ingredient, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                ingredient = poweredItem.ingredient;
            }
            if ((n2 & 2) != 0) {
                n = poweredItem.power;
            }
            return poweredItem.copy(ingredient, n);
        }

        @NotNull
        public String toString() {
            return "PoweredItem(ingredient=" + this.ingredient + ", power=" + this.power + ")";
        }

        public int hashCode() {
            Ingredient ingredient = this.ingredient;
            return (ingredient != null ? ingredient.hashCode() : 0) * 31 + Integer.hashCode(this.power);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PoweredItem)) break block3;
                    PoweredItem poweredItem = (PoweredItem)object;
                    if (!Intrinsics.areEqual(this.ingredient, poweredItem.ingredient) || this.power != poweredItem.power) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lnet/msrandom/witchery/recipe/CauldronRecipe$PoweredItem$Companion;", "", "()V", "parse", "Lnet/msrandom/witchery/recipe/CauldronRecipe$PoweredItem;", "json", "Lcom/google/gson/JsonObject;", "WitcheryResurrected"})
        public static final class Companion {
            @NotNull
            public final PoweredItem parse(@NotNull JsonObject json) {
                Intrinsics.checkParameterIsNotNull(json, "json");
                JsonElement jsonElement = json.get("ingredient");
                Intrinsics.checkExpressionValueIsNotNull(jsonElement, "json[\"ingredient\"]");
                JsonElement jsonElement2 = json.get("power");
                return new PoweredItem(WitcheryUtils.parseIngredient(jsonElement), jsonElement2 != null ? jsonElement2.getAsInt() : 0);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lnet/msrandom/witchery/recipe/CauldronRecipe$Serializer;", "Lnet/msrandom/witchery/recipe/WitcheryRecipeSerializer;", "Lnet/msrandom/witchery/recipe/CauldronRecipe;", "()V", "type", "Lnet/msrandom/witchery/recipe/WitcheryRecipeType;", "getType", "()Lnet/msrandom/witchery/recipe/WitcheryRecipeType;", "read", "id", "Lnet/minecraft/util/ResourceLocation;", "json", "Lcom/google/gson/JsonObject;", "buffer", "Lnet/minecraft/network/PacketBuffer;", "write", "", "recipe", "WitcheryResurrected"})
    public static final class Serializer
    implements WitcheryRecipeSerializer<CauldronRecipe> {
        @NotNull
        public WitcheryRecipeType<CauldronRecipe> getType() {
            return WitcheryRecipeTypes.CAULDRON;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public CauldronRecipe read(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            JsonArray jsonArray;
            String string;
            ResourceLocation resourceLocation;
            block4: {
                block3: {
                    void var14_12;
                    void destination$iv;
                    void $this$mapTo$iv;
                    Intrinsics.checkParameterIsNotNull(id, "id");
                    Intrinsics.checkParameterIsNotNull(json, "json");
                    resourceLocation = id;
                    JsonElement jsonElement = json.get("group");
                    string = jsonElement != null ? jsonElement.getAsString() : null;
                    jsonArray = json.getAsJsonArray("ingredients");
                    if (jsonArray == null) break block3;
                    Iterable iterable = (Iterable)jsonArray;
                    Collection collection = (Collection)NonNullList.func_191196_a();
                    String string2 = string;
                    ResourceLocation resourceLocation2 = resourceLocation;
                    boolean $i$f$mapTo = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        void it;
                        JsonElement jsonElement2 = (JsonElement)item$iv;
                        var14_12 = destination$iv;
                        boolean bl = false;
                        void v4 = it;
                        Intrinsics.checkExpressionValueIsNotNull(v4, "it");
                        JsonObject jsonObject = v4.getAsJsonObject();
                        Intrinsics.checkExpressionValueIsNotNull(jsonObject, "it.asJsonObject");
                        PoweredItem poweredItem = PoweredItem.Companion.parse(jsonObject);
                        var14_12.add(poweredItem);
                    }
                    var14_12 = destination$iv;
                    resourceLocation = resourceLocation2;
                    string = string2;
                    jsonArray = (NonNullList)var14_12;
                    if (jsonArray != null) break block4;
                }
                NonNullList nonNullList = NonNullList.func_191196_a();
                jsonArray = nonNullList;
                Intrinsics.checkExpressionValueIsNotNull(nonNullList, "NonNullList.create()");
            }
            JsonObject jsonObject = json.getAsJsonObject("trigger_ingredient");
            Intrinsics.checkExpressionValueIsNotNull(jsonObject, "json.getAsJsonObject(\"trigger_ingredient\")");
            PoweredItem poweredItem = PoweredItem.Companion.parse(jsonObject);
            JsonObject jsonObject2 = json.getAsJsonObject("result");
            Intrinsics.checkExpressionValueIsNotNull(jsonObject2, "json.getAsJsonObject(\"result\")");
            ItemStack itemStack = WitcheryUtils.parseStack(jsonObject2);
            PoweredItem poweredItem2 = poweredItem;
            JsonArray jsonArray2 = jsonArray;
            String string3 = string;
            ResourceLocation resourceLocation3 = resourceLocation;
            return new CauldronRecipe(resourceLocation3, string3, (NonNullList<PoweredItem>)jsonArray2, poweredItem2, itemStack);
        }

        @Override
        @NotNull
        public CauldronRecipe read(@NotNull ResourceLocation id, @NotNull PacketBuffer buffer) {
            NonNullList nonNullList;
            Intrinsics.checkParameterIsNotNull(id, "id");
            Intrinsics.checkParameterIsNotNull(buffer, "buffer");
            NonNullList nonNullList2 = NonNullList.func_191196_a();
            String string = buffer.readBoolean() ? buffer.func_150789_c(Short.MAX_VALUE) : null;
            ResourceLocation resourceLocation = id;
            boolean bl = false;
            boolean bl2 = false;
            NonNullList $this$apply = nonNullList2;
            boolean bl3 = false;
            int n = buffer.func_150792_a();
            boolean bl4 = false;
            int n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it = n2++;
                boolean bl5 = false;
                $this$apply.add((Object)new PoweredItem(WitcheryUtils.readIngredient(buffer), buffer.func_150792_a()));
            }
            NonNullList nonNullList3 = nonNullList = nonNullList2;
            Intrinsics.checkExpressionValueIsNotNull(nonNullList3, "NonNullList.create<Power\u2026          }\n            }");
            PoweredItem poweredItem = new PoweredItem(WitcheryUtils.readIngredient(buffer), buffer.func_150792_a());
            ItemStack itemStack = buffer.func_150791_c();
            Intrinsics.checkExpressionValueIsNotNull(itemStack, "buffer.readItemStack()");
            ItemStack itemStack2 = itemStack;
            PoweredItem poweredItem2 = poweredItem;
            NonNullList nonNullList4 = nonNullList3;
            String string2 = string;
            ResourceLocation resourceLocation2 = resourceLocation;
            return new CauldronRecipe(resourceLocation2, string2, (NonNullList<PoweredItem>)nonNullList4, poweredItem2, itemStack2);
        }

        @Override
        public void write(@NotNull PacketBuffer buffer, @NotNull CauldronRecipe recipe) {
            Intrinsics.checkParameterIsNotNull(buffer, "buffer");
            Intrinsics.checkParameterIsNotNull((Object)recipe, "recipe");
            if (recipe.recipeGroup == null) {
                buffer.writeBoolean(false);
            } else {
                buffer.writeBoolean(true);
                buffer.func_180714_a(recipe.recipeGroup);
            }
            buffer.func_150787_b(recipe.getInputs().size());
            for (PoweredItem input : recipe.getInputs()) {
                WitcheryUtils.writeIngredient(buffer, input.getIngredient());
                buffer.func_150787_b(input.getPower());
            }
            WitcheryUtils.writeIngredient(buffer, recipe.getTriggerIngredient().getIngredient());
            buffer.func_150787_b(recipe.getTriggerIngredient().getPower());
            buffer.func_150788_a(recipe.result);
        }
    }
}

