/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityDistillery;
import net.msrandom.witchery.init.data.recipes.WitcheryRecipeTypes;
import net.msrandom.witchery.init.items.WitcheryFumeItems;
import net.msrandom.witchery.recipe.WitcheryRecipe;
import net.msrandom.witchery.recipe.WitcheryRecipeSerializer;
import net.msrandom.witchery.recipe.WitcheryRecipeType;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00022\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\tH\u0016J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\b\u0010\u001e\u001a\u00020\fH\u0016J\b\u0010\u001f\u001a\u00020\u0016H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006!"}, d2={"Lnet/msrandom/witchery/recipe/DistilleryRecipe;", "Lnet/msrandom/witchery/recipe/WitcheryRecipe;", "Lnet/msrandom/witchery/block/entity/TileEntityDistillery;", "id", "Lnet/minecraft/util/ResourceLocation;", "primaryIngredient", "Lnet/minecraft/item/crafting/Ingredient;", "secondaryIngredient", "jars", "", "outputs", "Lnet/minecraft/util/NonNullList;", "Lnet/minecraft/item/ItemStack;", "(Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/item/crafting/Ingredient;Lnet/minecraft/item/crafting/Ingredient;ILnet/minecraft/util/NonNullList;)V", "getJars", "()I", "getOutputs", "()Lnet/minecraft/util/NonNullList;", "getPrimaryIngredient", "()Lnet/minecraft/item/crafting/Ingredient;", "getSecondaryIngredient", "canCraft", "", "inventory", "world", "Lnet/minecraft/world/World;", "canFit", "width", "height", "craft", "getRecipeOutput", "isDynamic", "Serializer", "WitcheryResurrected"})
public final class DistilleryRecipe
extends WitcheryRecipe<TileEntityDistillery> {
    @NotNull
    private final Ingredient primaryIngredient;
    @NotNull
    private final Ingredient secondaryIngredient;
    private final int jars;
    @NotNull
    private final NonNullList<ItemStack> outputs;

    @Override
    public boolean canCraft(@NotNull TileEntityDistillery inventory, @Nullable World world) {
        ItemStack jarStack;
        Intrinsics.checkParameterIsNotNull((Object)inventory, "inventory");
        ItemStack itemStack = jarStack = inventory.func_70301_a(2);
        Intrinsics.checkExpressionValueIsNotNull(itemStack, "jarStack");
        if (Intrinsics.areEqual(itemStack.func_77973_b(), WitcheryFumeItems.CLAY_JAR) ^ true || jarStack.func_190916_E() < this.jars) {
            return false;
        }
        return this.primaryIngredient.test((Object)inventory.func_70301_a(0)) && this.secondaryIngredient.test((Object)inventory.func_70301_a(1));
    }

    @Override
    @NotNull
    public ItemStack craft(@NotNull TileEntityDistillery inventory) {
        Intrinsics.checkParameterIsNotNull((Object)inventory, "inventory");
        return this.func_77571_b();
    }

    public boolean func_194133_a(int width, int height2) {
        int i = 3;
        if (Intrinsics.areEqual(this.primaryIngredient, Ingredient.field_193370_a)) {
            --i;
        }
        if (Intrinsics.areEqual(this.secondaryIngredient, Ingredient.field_193370_a)) {
            --i;
        }
        if (this.jars <= 0) {
            --i;
        }
        return width * height2 >= i;
    }

    @NotNull
    public ItemStack func_77571_b() {
        ItemStack itemStack = ItemStack.field_190927_a;
        Intrinsics.checkExpressionValueIsNotNull(itemStack, "ItemStack.EMPTY");
        return itemStack;
    }

    public boolean func_192399_d() {
        return true;
    }

    @NotNull
    public final Ingredient getPrimaryIngredient() {
        return this.primaryIngredient;
    }

    @NotNull
    public final Ingredient getSecondaryIngredient() {
        return this.secondaryIngredient;
    }

    public final int getJars() {
        return this.jars;
    }

    @NotNull
    public final NonNullList<ItemStack> getOutputs() {
        return this.outputs;
    }

    public DistilleryRecipe(@NotNull ResourceLocation id, @NotNull Ingredient primaryIngredient, @NotNull Ingredient secondaryIngredient, int jars, @NotNull NonNullList<ItemStack> outputs) {
        Intrinsics.checkParameterIsNotNull(id, "id");
        Intrinsics.checkParameterIsNotNull(primaryIngredient, "primaryIngredient");
        Intrinsics.checkParameterIsNotNull(secondaryIngredient, "secondaryIngredient");
        Intrinsics.checkParameterIsNotNull(outputs, "outputs");
        super(id, WitcheryRecipeTypes.DISTILLERY.getSerializer());
        this.primaryIngredient = primaryIngredient;
        this.secondaryIngredient = secondaryIngredient;
        this.jars = jars;
        this.outputs = outputs;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lnet/msrandom/witchery/recipe/DistilleryRecipe$Serializer;", "Lnet/msrandom/witchery/recipe/WitcheryRecipeSerializer;", "Lnet/msrandom/witchery/recipe/DistilleryRecipe;", "()V", "type", "Lnet/msrandom/witchery/recipe/WitcheryRecipeType;", "getType", "()Lnet/msrandom/witchery/recipe/WitcheryRecipeType;", "read", "id", "Lnet/minecraft/util/ResourceLocation;", "json", "Lcom/google/gson/JsonObject;", "buffer", "Lnet/minecraft/network/PacketBuffer;", "readIngredient", "Lnet/minecraft/item/crafting/Ingredient;", "name", "", "write", "", "recipe", "WitcheryResurrected"})
    public static final class Serializer
    implements WitcheryRecipeSerializer<DistilleryRecipe> {
        @NotNull
        public WitcheryRecipeType<DistilleryRecipe> getType() {
            return WitcheryRecipeTypes.DISTILLERY;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public DistilleryRecipe read(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            void var16_14;
            void destination$iv;
            void $this$mapTo$iv;
            Intrinsics.checkParameterIsNotNull(id, "id");
            Intrinsics.checkParameterIsNotNull(json, "json");
            Ingredient ingredient = this.readIngredient(json, "primary_ingredient");
            Ingredient ingredient2 = this.readIngredient(json, "secondary_ingredient");
            int n = JsonUtils.func_151203_m((JsonObject)json, (String)"clay_jars");
            JsonArray jsonArray = json.getAsJsonArray("result");
            Intrinsics.checkExpressionValueIsNotNull(jsonArray, "json.getAsJsonArray(\"result\")");
            Iterable iterable = (Iterable)jsonArray;
            Collection collection = (Collection)NonNullList.func_191196_a();
            int n2 = n;
            Ingredient ingredient3 = ingredient2;
            Ingredient ingredient4 = ingredient;
            ResourceLocation resourceLocation = id;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                JsonElement jsonElement = (JsonElement)item$iv;
                var16_14 = destination$iv;
                boolean bl = false;
                void v4 = it;
                Intrinsics.checkExpressionValueIsNotNull(v4, "it");
                JsonObject jsonObject = v4.getAsJsonObject();
                Intrinsics.checkExpressionValueIsNotNull(jsonObject, "it.asJsonObject");
                ItemStack itemStack = WitcheryUtils.parseStack(jsonObject);
                var16_14.add(itemStack);
            }
            void v6 = var16_14 = destination$iv;
            Intrinsics.checkExpressionValueIsNotNull(v6, "json.getAsJsonArray(\"res\u2026eStack(it.asJsonObject) }");
            NonNullList nonNullList = (NonNullList)v6;
            int n3 = n2;
            Ingredient ingredient5 = ingredient3;
            Ingredient ingredient6 = ingredient4;
            ResourceLocation resourceLocation2 = resourceLocation;
            return new DistilleryRecipe(resourceLocation2, ingredient6, ingredient5, n3, (NonNullList<ItemStack>)nonNullList);
        }

        private final Ingredient readIngredient(JsonObject json, String name2) {
            JsonElement jsonElement = json.get(name2);
            if (jsonElement == null) {
                Ingredient ingredient = Ingredient.field_193370_a;
                Intrinsics.checkExpressionValueIsNotNull(ingredient, "Ingredient.EMPTY");
                return ingredient;
            }
            JsonElement element = jsonElement;
            return WitcheryUtils.parseIngredient(element);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public DistilleryRecipe read(@NotNull ResourceLocation id, @NotNull PacketBuffer buffer) {
            Intrinsics.checkParameterIsNotNull(id, "id");
            Intrinsics.checkParameterIsNotNull(buffer, "buffer");
            int jars = buffer.func_150792_a();
            Ingredient primaryIngredient = WitcheryUtils.readIngredient(buffer);
            Ingredient secondaryIngredient = WitcheryUtils.readIngredient(buffer);
            NonNullList result2 = NonNullList.func_191197_a((int)buffer.func_150792_a(), (Object)ItemStack.field_190927_a);
            int n = 0;
            NonNullList nonNullList = result2;
            Intrinsics.checkExpressionValueIsNotNull(nonNullList, "result");
            int n2 = ((Collection)nonNullList).size();
            while (n < n2) {
                void index;
                result2.set((int)index, (Object)buffer.func_150791_c());
                ++index;
            }
            return new DistilleryRecipe(id, primaryIngredient, secondaryIngredient, jars, (NonNullList<ItemStack>)result2);
        }

        @Override
        public void write(@NotNull PacketBuffer buffer, @NotNull DistilleryRecipe recipe) {
            Intrinsics.checkParameterIsNotNull(buffer, "buffer");
            Intrinsics.checkParameterIsNotNull((Object)recipe, "recipe");
            buffer.func_150787_b(recipe.getJars());
            WitcheryUtils.writeIngredient(buffer, recipe.getPrimaryIngredient());
            WitcheryUtils.writeIngredient(buffer, recipe.getSecondaryIngredient());
            buffer.func_150787_b(recipe.getOutputs().size());
            for (ItemStack output : recipe.getOutputs()) {
                buffer.func_150788_a(output);
            }
        }
    }
}

