/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.recipe.brazier;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.init.data.recipes.WitcheryRecipeSerializers;
import net.msrandom.witchery.recipe.brazier.BrazierRecipe;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000fJ \u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnet/msrandom/witchery/recipe/brazier/BrazierEffectRecipe;", "Lnet/msrandom/witchery/recipe/brazier/BrazierRecipe;", "id", "Lnet/minecraft/util/ResourceLocation;", "inputs", "Lnet/minecraft/util/NonNullList;", "Lnet/minecraft/item/crafting/Ingredient;", "burnTime", "", "needsPower", "", "hidden", "effect", "Lnet/minecraft/potion/Potion;", "radius", "(Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/util/NonNullList;IZZLnet/minecraft/potion/Potion;I)V", "onBurning", "world", "Lnet/minecraft/world/World;", "position", "Lnet/minecraft/util/math/BlockPos;", "ticks", "", "Serializer", "WitcheryResurrected"})
public final class BrazierEffectRecipe
extends BrazierRecipe {
    private final Potion effect;
    private final int radius;

    @Override
    public int onBurning(@NotNull World world, @NotNull BlockPos position, long ticks) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(position, "position");
        if (ticks % (long)60 == 0L) {
            for (EntityLivingBase entity : world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(position.func_177982_a(-this.radius, -this.radius, -this.radius), position.func_177982_a(this.radius, this.radius, this.radius)))) {
                if (!(entity.func_174818_b(position) <= (double)(this.radius * this.radius))) continue;
                entity.func_70690_d(new PotionEffect(this.effect, 120, 0));
            }
        }
        return 0;
    }

    public BrazierEffectRecipe(@NotNull ResourceLocation id, @NotNull NonNullList<Ingredient> inputs, int burnTime, boolean needsPower, boolean hidden, @NotNull Potion effect, int radius) {
        Intrinsics.checkParameterIsNotNull(id, "id");
        Intrinsics.checkParameterIsNotNull(inputs, "inputs");
        Intrinsics.checkParameterIsNotNull(effect, "effect");
        super(id, WitcheryRecipeSerializers.getBrazierEffect(), inputs, burnTime, needsPower, hidden);
        this.effect = effect;
        this.radius = radius;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J>\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J>\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0002H\u0016\u00a8\u0006\u0016"}, d2={"Lnet/msrandom/witchery/recipe/brazier/BrazierEffectRecipe$Serializer;", "Lnet/msrandom/witchery/recipe/brazier/BrazierRecipe$BaseSerializer;", "Lnet/msrandom/witchery/recipe/brazier/BrazierEffectRecipe;", "()V", "read", "id", "Lnet/minecraft/util/ResourceLocation;", "json", "Lcom/google/gson/JsonObject;", "ingredients", "Lnet/minecraft/util/NonNullList;", "Lnet/minecraft/item/crafting/Ingredient;", "burnTime", "", "needsPower", "", "hidden", "buffer", "Lnet/minecraft/network/PacketBuffer;", "write", "", "recipe", "WitcheryResurrected"})
    public static final class Serializer
    extends BrazierRecipe.BaseSerializer<BrazierEffectRecipe> {
        @Override
        @NotNull
        public BrazierEffectRecipe read(@NotNull ResourceLocation id, @NotNull JsonObject json, @NotNull NonNullList<Ingredient> ingredients, int burnTime, boolean needsPower, boolean hidden) {
            Intrinsics.checkParameterIsNotNull(id, "id");
            Intrinsics.checkParameterIsNotNull(json, "json");
            Intrinsics.checkParameterIsNotNull(ingredients, "ingredients");
            JsonElement jsonElement = json.get("effect");
            Intrinsics.checkExpressionValueIsNotNull(jsonElement, "json[\"effect\"]");
            Potion potion = Potion.func_180142_b((String)jsonElement.getAsString());
            if (potion == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(potion, "Potion.getPotionFromReso\u2026son[\"effect\"].asString)!!");
            return new BrazierEffectRecipe(id, ingredients, burnTime, needsPower, hidden, potion, JsonUtils.func_151208_a((JsonObject)json, (String)"radius", (int)4));
        }

        @Override
        @NotNull
        public BrazierEffectRecipe read(@NotNull ResourceLocation id, @NotNull PacketBuffer buffer, @NotNull NonNullList<Ingredient> ingredients, int burnTime, boolean needsPower, boolean hidden) {
            Intrinsics.checkParameterIsNotNull(id, "id");
            Intrinsics.checkParameterIsNotNull(buffer, "buffer");
            Intrinsics.checkParameterIsNotNull(ingredients, "ingredients");
            Potion potion = Potion.func_188412_a((int)buffer.func_150792_a());
            if (potion == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(potion, "Potion.getPotionById(buffer.readVarInt())!!");
            return new BrazierEffectRecipe(id, ingredients, burnTime, needsPower, hidden, potion, buffer.func_150792_a());
        }

        @Override
        public void write(@NotNull PacketBuffer buffer, @NotNull BrazierEffectRecipe recipe) {
            Intrinsics.checkParameterIsNotNull(buffer, "buffer");
            Intrinsics.checkParameterIsNotNull((Object)recipe, "recipe");
            super.write(buffer, (BrazierRecipe)recipe);
            buffer.func_150787_b(Potion.func_188409_a((Potion)recipe.effect));
            buffer.func_150787_b(recipe.radius);
        }
    }
}

