/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.recipe.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.init.PotionTypes;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.msrandom.witchery.init.data.recipes.WitcheryRecipeSerializers;
import net.msrandom.witchery.recipe.WitcheryRecipe;
import net.msrandom.witchery.recipe.WitcheryRecipeSerializer;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001!B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tH\u0016J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0011H\u0016J\b\u0010 \u001a\u00020\u0015H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\""}, d2={"Lnet/msrandom/witchery/recipe/crafting/AddPotionsRecipe;", "Lnet/msrandom/witchery/recipe/WitcheryRecipe;", "Lnet/minecraft/inventory/InventoryCrafting;", "id", "Lnet/minecraft/util/ResourceLocation;", "ingredient", "Lnet/minecraft/item/crafting/Ingredient;", "potion", "max", "", "(Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/item/crafting/Ingredient;Lnet/minecraft/item/crafting/Ingredient;I)V", "getIngredient", "()Lnet/minecraft/item/crafting/Ingredient;", "getMax", "()I", "getPotion", "addPotions", "Lnet/minecraft/item/ItemStack;", "stack", "potionStack", "canCraft", "", "inventory", "world", "Lnet/minecraft/world/World;", "canFit", "width", "height", "craft", "getIngredients", "Lnet/minecraft/util/NonNullList;", "getRecipeOutput", "isDynamic", "Serializer", "WitcheryResurrected"})
public final class AddPotionsRecipe
extends WitcheryRecipe<InventoryCrafting> {
    @NotNull
    private final Ingredient ingredient;
    @NotNull
    private final Ingredient potion;
    private final int max;

    @Override
    public boolean canCraft(@NotNull InventoryCrafting inventory, @Nullable World world) {
        Intrinsics.checkParameterIsNotNull(inventory, "inventory");
        boolean hasPotion = false;
        boolean hasItem = false;
        IInventory $this$forEach$iv = (IInventory)inventory;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.func_70302_i_();
        boolean bl = false;
        int n2 = 0;
        int n3 = n;
        for (n2 = 0; n2 < n3; ++n2) {
            ItemStack it;
            int it$iv = n2;
            boolean bl2 = false;
            Intrinsics.checkExpressionValueIsNotNull($this$forEach$iv.func_70301_a(it$iv), "getStackInSlot(it)");
            boolean bl3 = false;
            if (this.potion.test((Object)it)) {
                if (hasPotion || Intrinsics.areEqual(PotionUtils.func_185191_c((ItemStack)it), PotionTypes.field_185229_a)) {
                    return false;
                }
                hasPotion = true;
                continue;
            }
            if (this.ingredient.test((Object)it)) {
                if (hasItem) {
                    return false;
                }
                hasItem = true;
                continue;
            }
            if (it.func_190926_b()) continue;
            return false;
        }
        return hasItem && hasPotion;
    }

    @Override
    @NotNull
    public ItemStack craft(@NotNull InventoryCrafting inventory) {
        Intrinsics.checkParameterIsNotNull(inventory, "inventory");
        ItemStack stack = ItemStack.field_190927_a;
        ItemStack potionStack = ItemStack.field_190927_a;
        IInventory $this$forEach$iv = (IInventory)inventory;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.func_70302_i_();
        boolean bl = false;
        int n2 = 0;
        int n3 = n;
        for (n2 = 0; n2 < n3; ++n2) {
            ItemStack it;
            int it$iv = n2;
            boolean bl2 = false;
            Intrinsics.checkExpressionValueIsNotNull($this$forEach$iv.func_70301_a(it$iv), "getStackInSlot(it)");
            boolean bl3 = false;
            if (this.ingredient.test((Object)it)) {
                stack = it;
                ItemStack itemStack = potionStack;
                Intrinsics.checkExpressionValueIsNotNull(itemStack, "potionStack");
                if (itemStack.func_190926_b()) continue;
                ItemStack itemStack2 = stack;
                Intrinsics.checkExpressionValueIsNotNull(itemStack2, "stack");
                ItemStack itemStack3 = potionStack;
                Intrinsics.checkExpressionValueIsNotNull(itemStack3, "potionStack");
                return this.addPotions(itemStack2, itemStack3);
            }
            if (!this.potion.test((Object)it)) continue;
            potionStack = it;
            ItemStack itemStack = stack;
            Intrinsics.checkExpressionValueIsNotNull(itemStack, "stack");
            if (itemStack.func_190926_b()) continue;
            ItemStack itemStack4 = stack;
            Intrinsics.checkExpressionValueIsNotNull(itemStack4, "stack");
            ItemStack itemStack5 = potionStack;
            Intrinsics.checkExpressionValueIsNotNull(itemStack5, "potionStack");
            return this.addPotions(itemStack4, itemStack5);
        }
        ItemStack itemStack = ItemStack.field_190927_a;
        Intrinsics.checkExpressionValueIsNotNull(itemStack, "ItemStack.EMPTY");
        return itemStack;
    }

    private final ItemStack addPotions(ItemStack stack, ItemStack potionStack) {
        ItemStack itemStack;
        if (this.max == 1) {
            ItemStack itemStack2 = PotionUtils.func_185188_a((ItemStack)stack.func_77946_l(), (PotionType)PotionUtils.func_185191_c((ItemStack)potionStack));
            itemStack = itemStack2;
            Intrinsics.checkExpressionValueIsNotNull(itemStack2, "PotionUtils.addPotionToI\u2026ionFromItem(potionStack))");
        } else {
            ItemStack itemStack3 = stack.func_77946_l();
            List list2 = PotionUtils.func_185189_a((ItemStack)stack);
            Intrinsics.checkExpressionValueIsNotNull(list2, "PotionUtils.getEffectsFromStack(stack)");
            Collection collection = list2;
            PotionType potionType = PotionUtils.func_185191_c((ItemStack)potionStack);
            Intrinsics.checkExpressionValueIsNotNull(potionType, "PotionUtils.getPotionFromItem(potionStack)");
            List list3 = potionType.func_185170_a();
            Intrinsics.checkExpressionValueIsNotNull(list3, "PotionUtils.getPotionFromItem(potionStack).effects");
            ItemStack result2 = PotionUtils.func_185184_a((ItemStack)itemStack3, (Collection)CollectionsKt.plus(collection, (Iterable)list3));
            if (result2.func_77942_o()) {
                ItemStack itemStack4 = result2;
                Intrinsics.checkExpressionValueIsNotNull(itemStack4, "result");
                NBTTagList tagList = WitcheryUtils.getOrCreateTag(itemStack4).func_150295_c("CustomPotionEffects", 10);
                if (tagList.func_74745_c() > this.max) {
                    tagList.func_74744_a(0);
                }
            }
            ItemStack itemStack5 = result2;
            itemStack = itemStack5;
            Intrinsics.checkExpressionValueIsNotNull(itemStack5, "result");
        }
        return itemStack;
    }

    public boolean func_194133_a(int width, int height2) {
        return width * height2 >= 2;
    }

    @NotNull
    public ItemStack func_77571_b() {
        ItemStack itemStack = ItemStack.field_190927_a;
        Intrinsics.checkExpressionValueIsNotNull(itemStack, "ItemStack.EMPTY");
        return itemStack;
    }

    public boolean func_192399_d() {
        return true;
    }

    @NotNull
    public NonNullList<Ingredient> func_192400_c() {
        NonNullList nonNullList = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.ingredient, this.potion});
        Intrinsics.checkExpressionValueIsNotNull(nonNullList, "NonNullList.from(Ingredi\u2026MPTY, ingredient, potion)");
        return nonNullList;
    }

    @NotNull
    public final Ingredient getIngredient() {
        return this.ingredient;
    }

    @NotNull
    public final Ingredient getPotion() {
        return this.potion;
    }

    public final int getMax() {
        return this.max;
    }

    public AddPotionsRecipe(@NotNull ResourceLocation id, @NotNull Ingredient ingredient, @NotNull Ingredient potion, int max) {
        Intrinsics.checkParameterIsNotNull(id, "id");
        Intrinsics.checkParameterIsNotNull(ingredient, "ingredient");
        Intrinsics.checkParameterIsNotNull(potion, "potion");
        super(id, WitcheryRecipeSerializers.getAddPotions());
        this.ingredient = ingredient;
        this.potion = potion;
        this.max = max;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a8\u0006\u000e"}, d2={"Lnet/msrandom/witchery/recipe/crafting/AddPotionsRecipe$Serializer;", "Lnet/msrandom/witchery/recipe/WitcheryRecipeSerializer;", "Lnet/msrandom/witchery/recipe/crafting/AddPotionsRecipe;", "()V", "read", "id", "Lnet/minecraft/util/ResourceLocation;", "json", "Lcom/google/gson/JsonObject;", "buffer", "Lnet/minecraft/network/PacketBuffer;", "write", "", "recipe", "WitcheryResurrected"})
    public static final class Serializer
    implements WitcheryRecipeSerializer<AddPotionsRecipe> {
        @Override
        @NotNull
        public AddPotionsRecipe read(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            Intrinsics.checkParameterIsNotNull(id, "id");
            Intrinsics.checkParameterIsNotNull(json, "json");
            JsonElement jsonElement = json.get("ingredient");
            Intrinsics.checkExpressionValueIsNotNull(jsonElement, "json[\"ingredient\"]");
            Ingredient ingredient = WitcheryUtils.parseIngredient(jsonElement);
            JsonElement jsonElement2 = json.get("potion");
            Intrinsics.checkExpressionValueIsNotNull(jsonElement2, "json[\"potion\"]");
            return new AddPotionsRecipe(id, ingredient, WitcheryUtils.parseIngredient(jsonElement2), JsonUtils.func_151208_a((JsonObject)json, (String)"max", (int)1));
        }

        @Override
        @NotNull
        public AddPotionsRecipe read(@NotNull ResourceLocation id, @NotNull PacketBuffer buffer) {
            Intrinsics.checkParameterIsNotNull(id, "id");
            Intrinsics.checkParameterIsNotNull(buffer, "buffer");
            return new AddPotionsRecipe(id, WitcheryUtils.readIngredient(buffer), WitcheryUtils.readIngredient(buffer), buffer.func_150792_a());
        }

        @Override
        public void write(@NotNull PacketBuffer buffer, @NotNull AddPotionsRecipe recipe) {
            Intrinsics.checkParameterIsNotNull(buffer, "buffer");
            Intrinsics.checkParameterIsNotNull((Object)recipe, "recipe");
            WitcheryUtils.writeIngredient(buffer, recipe.getIngredient());
            WitcheryUtils.writeIngredient(buffer, recipe.getPotion());
            buffer.func_150787_b(recipe.getMax());
        }
    }
}

