/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.recipe.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.msrandom.witchery.init.data.recipes.WitcheryRecipeSerializers;
import net.msrandom.witchery.recipe.WitcheryRecipe;
import net.msrandom.witchery.recipe.WitcheryRecipeSerializer;
import net.msrandom.witchery.registry.RegistryWrappers;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\b\u0010\u0015\u001a\u00020\tH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnet/msrandom/witchery/recipe/crafting/BindAlderDoorRecipe;", "Lnet/msrandom/witchery/recipe/WitcheryRecipe;", "Lnet/minecraft/inventory/InventoryCrafting;", "id", "Lnet/minecraft/util/ResourceLocation;", "doorIngredient", "Lnet/minecraft/item/crafting/Ingredient;", "otherDoor", "result", "Lnet/minecraft/item/ItemStack;", "(Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/item/crafting/Ingredient;Lnet/minecraft/item/crafting/Ingredient;Lnet/minecraft/item/ItemStack;)V", "canCraft", "", "inventory", "world", "Lnet/minecraft/world/World;", "canFit", "width", "", "height", "craft", "getRecipeOutput", "Serializer", "WitcheryResurrected"})
public final class BindAlderDoorRecipe
extends WitcheryRecipe<InventoryCrafting> {
    private final Ingredient doorIngredient;
    private final Ingredient otherDoor;
    private final ItemStack result;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canCraft(@NotNull InventoryCrafting inventory, @Nullable World world) {
        Intrinsics.checkParameterIsNotNull(inventory, "inventory");
        ItemStack alder = ItemStack.field_190927_a;
        ItemStack other = ItemStack.field_190927_a;
        IInventory $this$forEach$iv = (IInventory)inventory;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.func_70302_i_();
        boolean bl = false;
        int n2 = 0;
        int n3 = n;
        for (n2 = 0; n2 < n3; ++n2) {
            ItemStack it;
            int it$iv = n2;
            boolean bl2 = false;
            Intrinsics.checkExpressionValueIsNotNull($this$forEach$iv.func_70301_a(it$iv), "getStackInSlot(it)");
            boolean bl3 = false;
            if (this.doorIngredient.test((Object)it)) {
                ItemStack itemStack = alder;
                Intrinsics.checkExpressionValueIsNotNull(itemStack, "alder");
                if (!itemStack.func_190926_b()) {
                    return false;
                }
                alder = it;
                continue;
            }
            if (this.otherDoor.test((Object)it) && !this.doorIngredient.test((Object)it)) {
                ItemStack itemStack = other;
                Intrinsics.checkExpressionValueIsNotNull(itemStack, "other");
                if (!itemStack.func_190926_b()) {
                    return false;
                }
                Item item = it.func_77973_b();
                Intrinsics.checkExpressionValueIsNotNull(item, "it.item");
                if (RegistryWrappers.BLOCKS.get(item.getRegistryName()) == null) {
                    return false;
                }
                other = it;
                continue;
            }
            if (it.func_190926_b()) continue;
            return false;
        }
        ItemStack itemStack = alder;
        Intrinsics.checkExpressionValueIsNotNull(itemStack, "alder");
        if (itemStack.func_190926_b()) return false;
        ItemStack itemStack2 = other;
        Intrinsics.checkExpressionValueIsNotNull(itemStack2, "other");
        if (itemStack2.func_190926_b()) return false;
        if (alder.func_77969_a(other)) return false;
        if (other.func_77969_a(this.result)) return false;
        return true;
    }

    @Override
    @NotNull
    public ItemStack craft(@NotNull InventoryCrafting inventory) {
        Intrinsics.checkParameterIsNotNull(inventory, "inventory");
        IInventory $this$forEach$iv = (IInventory)inventory;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.func_70302_i_();
        boolean bl = false;
        int n2 = 0;
        int n3 = n;
        for (n2 = 0; n2 < n3; ++n2) {
            ItemStack result2;
            ItemStack it;
            int it$iv = n2;
            boolean bl2 = false;
            Intrinsics.checkExpressionValueIsNotNull($this$forEach$iv.func_70301_a(it$iv), "getStackInSlot(it)");
            boolean bl3 = false;
            if (!this.otherDoor.test((Object)it) || this.doorIngredient.test((Object)it)) continue;
            ItemStack itemStack = result2 = this.result.func_77946_l();
            Intrinsics.checkExpressionValueIsNotNull(itemStack, "result");
            NBTTagCompound nBTTagCompound = WitcheryUtils.getOrCreateTag(itemStack);
            Item item = it.func_77973_b();
            Intrinsics.checkExpressionValueIsNotNull(item, "it.item");
            nBTTagCompound.func_74778_a("CopyOf", String.valueOf(item.getRegistryName()));
            return result2;
        }
        return this.func_77571_b();
    }

    public boolean func_194133_a(int width, int height2) {
        return width * height2 <= 2;
    }

    @NotNull
    public ItemStack func_77571_b() {
        ItemStack itemStack = ItemStack.field_190927_a;
        Intrinsics.checkExpressionValueIsNotNull(itemStack, "ItemStack.EMPTY");
        return itemStack;
    }

    public BindAlderDoorRecipe(@NotNull ResourceLocation id, @NotNull Ingredient doorIngredient, @NotNull Ingredient otherDoor, @NotNull ItemStack result2) {
        Intrinsics.checkParameterIsNotNull(id, "id");
        Intrinsics.checkParameterIsNotNull(doorIngredient, "doorIngredient");
        Intrinsics.checkParameterIsNotNull(otherDoor, "otherDoor");
        Intrinsics.checkParameterIsNotNull(result2, "result");
        super(id, WitcheryRecipeSerializers.getBindDoor());
        this.doorIngredient = doorIngredient;
        this.otherDoor = otherDoor;
        this.result = result2;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a8\u0006\u000e"}, d2={"Lnet/msrandom/witchery/recipe/crafting/BindAlderDoorRecipe$Serializer;", "Lnet/msrandom/witchery/recipe/WitcheryRecipeSerializer;", "Lnet/msrandom/witchery/recipe/crafting/BindAlderDoorRecipe;", "()V", "read", "id", "Lnet/minecraft/util/ResourceLocation;", "json", "Lcom/google/gson/JsonObject;", "buffer", "Lnet/minecraft/network/PacketBuffer;", "write", "", "recipe", "WitcheryResurrected"})
    public static final class Serializer
    implements WitcheryRecipeSerializer<BindAlderDoorRecipe> {
        @Override
        @NotNull
        public BindAlderDoorRecipe read(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            Intrinsics.checkParameterIsNotNull(id, "id");
            Intrinsics.checkParameterIsNotNull(json, "json");
            JsonElement jsonElement = json.get("door");
            Intrinsics.checkExpressionValueIsNotNull(jsonElement, "json[\"door\"]");
            Ingredient ingredient = WitcheryUtils.parseIngredient(jsonElement);
            JsonElement jsonElement2 = json.get("disguise");
            Intrinsics.checkExpressionValueIsNotNull(jsonElement2, "json[\"disguise\"]");
            Ingredient ingredient2 = WitcheryUtils.parseIngredient(jsonElement2);
            JsonObject jsonObject = JsonUtils.func_152754_s((JsonObject)json, (String)"result");
            Intrinsics.checkExpressionValueIsNotNull(jsonObject, "JsonUtils.getJsonObject(json, \"result\")");
            return new BindAlderDoorRecipe(id, ingredient, ingredient2, WitcheryUtils.parseStack(jsonObject));
        }

        @Override
        @NotNull
        public BindAlderDoorRecipe read(@NotNull ResourceLocation id, @NotNull PacketBuffer buffer) {
            Intrinsics.checkParameterIsNotNull(id, "id");
            Intrinsics.checkParameterIsNotNull(buffer, "buffer");
            Ingredient ingredient = WitcheryUtils.readIngredient(buffer);
            Ingredient ingredient2 = WitcheryUtils.readIngredient(buffer);
            ItemStack itemStack = buffer.func_150791_c();
            Intrinsics.checkExpressionValueIsNotNull(itemStack, "buffer.readItemStack()");
            return new BindAlderDoorRecipe(id, ingredient, ingredient2, itemStack);
        }

        @Override
        public void write(@NotNull PacketBuffer buffer, @NotNull BindAlderDoorRecipe recipe) {
            Intrinsics.checkParameterIsNotNull(buffer, "buffer");
            Intrinsics.checkParameterIsNotNull((Object)recipe, "recipe");
            WitcheryUtils.writeIngredient(buffer, recipe.doorIngredient);
            WitcheryUtils.writeIngredient(buffer, recipe.otherDoor);
            buffer.func_150788_a(recipe.result);
        }
    }
}

