/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.recipe.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.msrandom.witchery.init.data.recipes.WitcheryRecipeSerializers;
import net.msrandom.witchery.init.items.WitcheryBookItems;
import net.msrandom.witchery.item.BiomeHolder;
import net.msrandom.witchery.recipe.WitcheryRecipe;
import net.msrandom.witchery.recipe.WitcheryRecipeSerializer;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0015H\u0016J\b\u0010\u0016\u001a\u00020\bH\u0016J\b\u0010\u0017\u001a\u00020\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lnet/msrandom/witchery/recipe/crafting/CopyBiomeRecipe;", "Lnet/msrandom/witchery/recipe/WitcheryRecipe;", "Lnet/minecraft/inventory/InventoryCrafting;", "id", "Lnet/minecraft/util/ResourceLocation;", "ingredient", "Lnet/minecraft/item/crafting/Ingredient;", "result", "Lnet/minecraft/item/ItemStack;", "(Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/item/crafting/Ingredient;Lnet/minecraft/item/ItemStack;)V", "canCraft", "", "inventory", "world", "Lnet/minecraft/world/World;", "canFit", "width", "", "height", "craft", "getIngredients", "Lnet/minecraft/util/NonNullList;", "getRecipeOutput", "isDynamic", "Serializer", "WitcheryResurrected"})
public final class CopyBiomeRecipe
extends WitcheryRecipe<InventoryCrafting> {
    private final Ingredient ingredient;
    private final ItemStack result;

    @Override
    public boolean canCraft(@NotNull InventoryCrafting inventory, @Nullable World world) {
        Intrinsics.checkParameterIsNotNull(inventory, "inventory");
        if (this.result.func_77973_b() instanceof BiomeHolder) {
            boolean hasBook = false;
            boolean hasItem = false;
            IInventory $this$forEach$iv = (IInventory)inventory;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.func_70302_i_();
            boolean bl = false;
            int n2 = 0;
            int n3 = n;
            for (n2 = 0; n2 < n3; ++n2) {
                ItemStack it;
                int it$iv = n2;
                boolean bl2 = false;
                Intrinsics.checkExpressionValueIsNotNull($this$forEach$iv.func_70301_a(it$iv), "getStackInSlot(it)");
                boolean bl3 = false;
                if (Intrinsics.areEqual(it.func_77973_b(), WitcheryBookItems.EXTENDED_BIOMES_BOOK)) {
                    if (hasBook) {
                        return false;
                    }
                    hasBook = true;
                    continue;
                }
                if (this.ingredient.test((Object)it)) {
                    if (hasItem) {
                        return false;
                    }
                    hasItem = true;
                    continue;
                }
                if (it.func_190926_b()) continue;
                return false;
            }
            return hasItem && hasBook;
        }
        return false;
    }

    @Override
    @NotNull
    public ItemStack craft(@NotNull InventoryCrafting inventory) {
        Intrinsics.checkParameterIsNotNull(inventory, "inventory");
        IInventory $this$forEach$iv = (IInventory)inventory;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.func_70302_i_();
        boolean bl = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            ItemStack copiedResult;
            ItemStack it;
            int it$iv = n2++;
            boolean bl2 = false;
            Intrinsics.checkExpressionValueIsNotNull($this$forEach$iv.func_70301_a(it$iv), "getStackInSlot(it)");
            boolean bl3 = false;
            if (!Intrinsics.areEqual(it.func_77973_b(), WitcheryBookItems.EXTENDED_BIOMES_BOOK)) continue;
            ItemStack itemStack = copiedResult = this.result.func_77946_l();
            Intrinsics.checkExpressionValueIsNotNull(itemStack, "copiedResult");
            Item item = itemStack.func_77973_b();
            if (item == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.msrandom.witchery.item.BiomeHolder");
            }
            Item item2 = it.func_77973_b();
            if (item2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.msrandom.witchery.item.BiomeHolder");
            }
            ((BiomeHolder)item).setBiome(copiedResult, ((BiomeHolder)item2).getBiome(it));
            return copiedResult;
        }
        ItemStack itemStack = ItemStack.field_190927_a;
        Intrinsics.checkExpressionValueIsNotNull(itemStack, "ItemStack.EMPTY");
        return itemStack;
    }

    public boolean func_194133_a(int width, int height2) {
        return width * height2 >= 2;
    }

    @NotNull
    public ItemStack func_77571_b() {
        ItemStack itemStack = ItemStack.field_190927_a;
        Intrinsics.checkExpressionValueIsNotNull(itemStack, "ItemStack.EMPTY");
        return itemStack;
    }

    public boolean func_192399_d() {
        return true;
    }

    @NotNull
    public NonNullList<Ingredient> func_192400_c() {
        NonNullList nonNullList = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.ingredient, Ingredient.func_193367_a((Item)WitcheryBookItems.EXTENDED_BIOMES_BOOK)});
        Intrinsics.checkExpressionValueIsNotNull(nonNullList, "NonNullList.from(Ingredi\u2026ms.EXTENDED_BIOMES_BOOK))");
        return nonNullList;
    }

    public CopyBiomeRecipe(@NotNull ResourceLocation id, @NotNull Ingredient ingredient, @NotNull ItemStack result2) {
        Intrinsics.checkParameterIsNotNull(id, "id");
        Intrinsics.checkParameterIsNotNull(ingredient, "ingredient");
        Intrinsics.checkParameterIsNotNull(result2, "result");
        super(id, WitcheryRecipeSerializers.getCopyBiome());
        this.ingredient = ingredient;
        this.result = result2;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a8\u0006\u000e"}, d2={"Lnet/msrandom/witchery/recipe/crafting/CopyBiomeRecipe$Serializer;", "Lnet/msrandom/witchery/recipe/WitcheryRecipeSerializer;", "Lnet/msrandom/witchery/recipe/crafting/CopyBiomeRecipe;", "()V", "read", "id", "Lnet/minecraft/util/ResourceLocation;", "json", "Lcom/google/gson/JsonObject;", "buffer", "Lnet/minecraft/network/PacketBuffer;", "write", "", "recipe", "WitcheryResurrected"})
    public static final class Serializer
    implements WitcheryRecipeSerializer<CopyBiomeRecipe> {
        @Override
        @NotNull
        public CopyBiomeRecipe read(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            Intrinsics.checkParameterIsNotNull(id, "id");
            Intrinsics.checkParameterIsNotNull(json, "json");
            JsonElement jsonElement = json.get("ingredient");
            Intrinsics.checkExpressionValueIsNotNull(jsonElement, "json[\"ingredient\"]");
            Ingredient ingredient = WitcheryUtils.parseIngredient(jsonElement);
            JsonObject jsonObject = json.getAsJsonObject("result");
            Intrinsics.checkExpressionValueIsNotNull(jsonObject, "json.getAsJsonObject(\"result\")");
            return new CopyBiomeRecipe(id, ingredient, WitcheryUtils.parseStack(jsonObject));
        }

        @Override
        @NotNull
        public CopyBiomeRecipe read(@NotNull ResourceLocation id, @NotNull PacketBuffer buffer) {
            Intrinsics.checkParameterIsNotNull(id, "id");
            Intrinsics.checkParameterIsNotNull(buffer, "buffer");
            Ingredient ingredient = WitcheryUtils.readIngredient(buffer);
            ItemStack itemStack = buffer.func_150791_c();
            Intrinsics.checkExpressionValueIsNotNull(itemStack, "buffer.readItemStack()");
            return new CopyBiomeRecipe(id, ingredient, itemStack);
        }

        @Override
        public void write(@NotNull PacketBuffer buffer, @NotNull CopyBiomeRecipe recipe) {
            Intrinsics.checkParameterIsNotNull(buffer, "buffer");
            Intrinsics.checkParameterIsNotNull((Object)recipe, "recipe");
            WitcheryUtils.writeIngredient(buffer, recipe.ingredient);
            buffer.func_150788_a(recipe.result);
        }
    }
}

