/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import net.minecraft.resources.JsonReloadListener;
import net.minecraft.resources.ResourceManager;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.msrandom.witchery.WitcheryResurrected;
import net.msrandom.witchery.brewing.ItemKey;
import net.msrandom.witchery.brewing.action.BrewAction;
import net.msrandom.witchery.brewing.action.BrewActionSerializer;
import net.msrandom.witchery.brewing.action.effect.BrewEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.network.resources.PacketUpdateBrewActions;
import net.msrandom.witchery.resources.BrewActionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0010 \n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J \u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0014\u0010\u001c\u001a\u00020\u000f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001eJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010!\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\bJ\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0#J$\u0010\"\u001a\b\u0012\u0004\u0012\u0002H%0$\"\b\b\u0000\u0010%*\u00020\t2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H%0\fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u000b\u001a2\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\r0\u0007j\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\r`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lnet/msrandom/witchery/resources/BrewActionManager;", "Lnet/minecraft/resources/JsonReloadListener;", "()V", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "actions", "Ljava/util/HashMap;", "Lnet/msrandom/witchery/brewing/ItemKey;", "Lnet/msrandom/witchery/brewing/action/BrewAction;", "Lkotlin/collections/HashMap;", "types", "Lnet/msrandom/witchery/brewing/action/BrewActionSerializer;", "", "apply", "", "value", "", "Lnet/minecraft/util/ResourceLocation;", "Lcom/google/gson/JsonElement;", "resourceManager", "Lnet/minecraft/resources/ResourceManager;", "deserializeAction", "key", "power", "", "json", "Lcom/google/gson/JsonObject;", "deserializeBrewActions", "newActions", "", "deserializeEffect", "Lnet/msrandom/witchery/brewing/action/effect/BrewEffect;", "getAction", "getActions", "", "", "T", "type", "WitcheryResurrected"})
public final class BrewActionManager
extends JsonReloadListener {
    private static final Logger LOGGER;
    private static final HashMap<BrewActionSerializer<?>, List<BrewAction>> types;
    private static final HashMap<ItemKey, BrewAction> actions;
    public static final BrewActionManager INSTANCE;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void apply(@NotNull Map<ResourceLocation, ? extends JsonElement> value, @NotNull ResourceManager resourceManager) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        Intrinsics.checkParameterIsNotNull(resourceManager, "resourceManager");
        types.clear();
        actions.clear();
        ResourceLocation resourceLocation = value;
        boolean bl = false;
        Iterator iterator2 = resourceLocation.entrySet().iterator();
        while (true) {
            BrewAction action;
            JsonObject json;
            block9: {
                Iterator iterator3;
                block10: {
                    void id;
                    Map.Entry entry2;
                    if (!iterator2.hasNext()) {
                        LOGGER.info("Loaded " + actions.size() + " brew actions");
                        WitcheryNetworkChannel.sendToAll(new PacketUpdateBrewActions(this.getActions()));
                        return;
                    }
                    Map.Entry entry3 = entry2 = iterator2.next();
                    boolean bl2 = false;
                    resourceLocation = (ResourceLocation)entry3.getKey();
                    entry3 = entry2;
                    bl2 = false;
                    JsonElement element = (JsonElement)entry3.getValue();
                    try {
                        json = JsonUtils.func_151210_l((JsonElement)element, (String)"top element");
                        if (json.size() == 0) continue;
                        JsonElement jsonElement = json.get("item");
                        Intrinsics.checkExpressionValueIsNotNull(jsonElement, "json[\"item\"]");
                        String string = jsonElement.getAsString();
                        Intrinsics.checkExpressionValueIsNotNull(string, "json[\"item\"].asString");
                        Pair<ResourceLocation, ItemKey> item = ItemKey.Companion.deserialize(string);
                        if (item.getSecond() != null) {
                            JsonArray jsonArray;
                            boolean bl3;
                            boolean bl4;
                            ItemKey itemKey;
                            boolean bl5 = false;
                            boolean bl6 = false;
                            ItemKey key = itemKey;
                            boolean bl7 = false;
                            JsonElement jsonElement2 = json.get("power_cost");
                            int n = jsonElement2 != null ? jsonElement2.getAsInt() : 0;
                            JsonObject jsonObject = json;
                            Intrinsics.checkExpressionValueIsNotNull(jsonObject, "json");
                            action = INSTANCE.deserializeAction(key, n, jsonObject);
                            JsonElement jsonElement3 = json.get("yelid_modifier");
                            if (jsonElement3 != null) {
                                int n2 = jsonElement3.getAsInt();
                                bl4 = false;
                                bl3 = false;
                                int it = n2;
                                boolean bl8 = false;
                                action.setYieldModifier(it);
                            }
                            if (json.getAsJsonArray("nullifiers") == null) break block9;
                            bl4 = false;
                            bl3 = false;
                            JsonArray array = jsonArray;
                            boolean bl9 = false;
                            iterator3 = array.iterator();
                            break block10;
                        }
                        LOGGER.info("Brew action " + id + " will be ignored as " + item.getFirst() + " is not a valid item.");
                    }
                    catch (RuntimeException exception) {
                        LOGGER.error("Parsing error loading brew action " + id, (Throwable)exception);
                    }
                    continue;
                }
                while (iterator3.hasNext()) {
                    ItemKey itemKey;
                    JsonElement nullifier;
                    JsonElement jsonElement = nullifier = (JsonElement)iterator3.next();
                    Intrinsics.checkExpressionValueIsNotNull(jsonElement, "nullifier");
                    String string = jsonElement.getAsString();
                    Intrinsics.checkExpressionValueIsNotNull(string, "nullifier.asString");
                    if (ItemKey.Companion.deserialize(string).getSecond() == null) continue;
                    HashSet<ItemKey> hashSet = action.getNullifiers();
                    boolean bl10 = false;
                    boolean bl11 = false;
                    ItemKey p1 = itemKey;
                    boolean bl12 = false;
                    hashSet.add(p1);
                }
            }
            JsonElement jsonElement = json.get("secret");
            if (jsonElement != null && jsonElement.getAsBoolean()) {
                action.setHidden(true);
            } else {
                types.computeIfAbsent(action.getSerializer(), apply.1.3.INSTANCE).add(action);
            }
            ((Map)actions).put(action.getKey(), action);
        }
    }

    @NotNull
    public final Collection<BrewAction> getActions() {
        Collection<BrewAction> collection = actions.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, "actions.values");
        return collection;
    }

    @NotNull
    public final <T extends BrewAction> List<T> getActions(@NotNull BrewActionSerializer<T> type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        List<BrewAction> list2 = types.computeIfAbsent(type2, getActions.1.INSTANCE);
        if (list2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<T>");
        }
        return list2;
    }

    @Nullable
    public final BrewAction getAction(@NotNull ItemKey key) {
        Intrinsics.checkParameterIsNotNull(key, "key");
        return actions.get(key);
    }

    public final void deserializeBrewActions(@NotNull Iterable<? extends BrewAction> newActions) {
        Intrinsics.checkParameterIsNotNull(newActions, "newActions");
        if (WitcheryResurrected.Companion.isClient()) {
            types.clear();
            actions.clear();
            for (BrewAction brewAction : newActions) {
                if (actions.put(brewAction.getKey(), brewAction) == null) {
                    if (brewAction.getHidden()) continue;
                    types.computeIfAbsent(brewAction.getSerializer(), deserializeBrewActions.1.INSTANCE).add(brewAction);
                    continue;
                }
                throw (Throwable)new IllegalStateException("Duplicate brew action ignored with key " + brewAction.getKey());
            }
        }
    }

    private final BrewAction deserializeAction(ItemKey key, int power, JsonObject json) {
        String s = JsonUtils.func_151200_h((JsonObject)json, (String)"type");
        BrewActionSerializer brewActionSerializer = (BrewActionSerializer)BrewActionSerializer.REGISTRY.get(new ResourceLocation(s));
        if (brewActionSerializer == null) {
            throw (Throwable)new JsonSyntaxException("Invalid or unsupported brew action type '" + s + '\'');
        }
        BrewActionSerializer serializer = brewActionSerializer;
        return serializer.read(key, power, json);
    }

    @NotNull
    public final BrewEffect deserializeEffect(@NotNull JsonObject json) {
        Intrinsics.checkParameterIsNotNull(json, "json");
        String s = JsonUtils.func_151200_h((JsonObject)json, (String)"effect");
        BrewEffectSerializer brewEffectSerializer = (BrewEffectSerializer)BrewEffectSerializer.REGISTRY.get(new ResourceLocation(s));
        if (brewEffectSerializer == null) {
            throw (Throwable)new JsonSyntaxException("Invalid or unsupported brew effect type '" + s + '\'');
        }
        BrewEffectSerializer serializer = brewEffectSerializer;
        Object effect = serializer.read(json);
        JsonElement jsonElement = json.get("name_key");
        ((BrewEffect)effect).setNameKey$WitcheryResurrected(jsonElement != null ? jsonElement.getAsString() : null);
        JsonElement jsonElement2 = json.get("description_key");
        ((BrewEffect)effect).setDescriptionKey$WitcheryResurrected(jsonElement2 != null ? jsonElement2.getAsString() : null);
        JsonElement jsonElement3 = json.get("inverted_name_key");
        ((BrewEffect)effect).setInvertedNameKey$WitcheryResurrected(jsonElement3 != null ? jsonElement3.getAsString() : null);
        JsonElement jsonElement4 = json.get("inverted_description_key");
        ((BrewEffect)effect).setInvertedDescriptionKey$WitcheryResurrected(jsonElement4 != null ? jsonElement4.getAsString() : null);
        return effect;
    }

    private BrewActionManager() {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        Intrinsics.checkExpressionValueIsNotNull(gson, "GsonBuilder().setPrettyP\u2026leHtmlEscaping().create()");
        super(gson, "brewing");
    }

    static {
        BrewActionManager brewActionManager;
        INSTANCE = brewActionManager = new BrewActionManager();
        LOGGER = LogManager.getLogger((String)("witchery/" + Reflection.getOrCreateKotlinClass(BrewActionManager.class).getSimpleName()));
        boolean bl = false;
        types = new HashMap();
        bl = false;
        actions = new HashMap();
    }
}

