/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import net.minecraft.resources.JsonReloadListener;
import net.minecraft.resources.ResourceManager;
import net.minecraft.util.ResourceLocation;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.network.resources.PacketUpdateAlternateFormStats;
import net.msrandom.witchery.registry.WitcheryIdentityRegistry;
import net.msrandom.witchery.registry.WitcheryRegistry;
import net.msrandom.witchery.resources.CreatureFormStatManager;
import net.msrandom.witchery.transformation.CreatureForm;
import net.msrandom.witchery.transformation.CreatureFormStatType;
import net.msrandom.witchery.transformation.CreatureTraitType;
import net.msrandom.witchery.util.WitcheryUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J2\u0010\u001b\u001a\u00020\u00142\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0016\u0010\u001d\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\t0\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR>\u0010\u000e\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\t0\u00072\u0016\u0010\u0006\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\t0\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0015\u0010\u0010\u001a\u00020\t*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lnet/msrandom/witchery/resources/CreatureFormStatManager;", "Lnet/minecraft/resources/JsonReloadListener;", "()V", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "<set-?>", "", "Lnet/msrandom/witchery/transformation/CreatureForm;", "Lnet/msrandom/witchery/transformation/CreatureForm$Stats;", "byForm", "getByForm", "()Ljava/util/Map;", "Lnet/msrandom/witchery/transformation/CreatureTraitType;", "byTrait", "getByTrait", "stats", "getStats", "(Lnet/msrandom/witchery/transformation/CreatureForm;)Lnet/msrandom/witchery/transformation/CreatureForm$Stats;", "apply", "", "value", "", "Lnet/minecraft/util/ResourceLocation;", "Lcom/google/gson/JsonElement;", "resourceManager", "Lnet/minecraft/resources/ResourceManager;", "deserializeStats", "formMap", "traitMap", "WitcheryResurrected"})
public final class CreatureFormStatManager
extends JsonReloadListener {
    private static final Logger LOGGER;
    @NotNull
    private static Map<CreatureTraitType<?>, CreatureForm.Stats> byTrait;
    @NotNull
    private static Map<CreatureForm, CreatureForm.Stats> byForm;
    public static final CreatureFormStatManager INSTANCE;

    @NotNull
    public final Map<CreatureTraitType<?>, CreatureForm.Stats> getByTrait() {
        return byTrait;
    }

    @NotNull
    public final Map<CreatureForm, CreatureForm.Stats> getByForm() {
        return byForm;
    }

    @NotNull
    public final CreatureForm.Stats getStats(@NotNull CreatureForm $this$stats) {
        Intrinsics.checkParameterIsNotNull($this$stats, "$this$stats");
        CreatureForm.Stats stats2 = byForm.computeIfAbsent($this$stats, stats.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(stats2, "byForm.computeIfAbsent(this) { Stats() }");
        return stats2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void apply(@NotNull Map<ResourceLocation, ? extends JsonElement> value, @NotNull ResourceManager resourceManager) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        Intrinsics.checkParameterIsNotNull(resourceManager, "resourceManager");
        ResourceLocation resourceLocation = value;
        boolean bl = false;
        Iterator<Map.Entry<ResourceLocation, ? extends JsonElement>> iterator2 = resourceLocation.entrySet().iterator();
        while (iterator2.hasNext()) {
            void key;
            Map.Entry<ResourceLocation, ? extends JsonElement> entry2;
            Map.Entry<ResourceLocation, ? extends JsonElement> entry3 = entry2 = iterator2.next();
            boolean bl2 = false;
            resourceLocation = entry3.getKey();
            entry3 = entry2;
            bl2 = false;
            JsonElement element = entry3.getValue();
            try {
                CreatureTraitType trait;
                CreatureTraitType creatureTraitType;
                Object object;
                CreatureForm form;
                CreatureForm creatureForm;
                Object object2;
                boolean bl3;
                JsonObject json = element.getAsJsonObject();
                if (json.size() == 0) continue;
                CreatureForm.Stats formStats = new CreatureForm.Stats();
                Object object3 = json.get("form");
                if (object3 != null && (object3 = object3.getAsString()) != null) {
                    Object object4 = object3;
                    boolean bl4 = false;
                    bl3 = false;
                    Object p1 = object4;
                    boolean bl5 = false;
                    object4 = new ResourceLocation((String)p1);
                    object2 = CreatureForm.REGISTRY;
                    bl3 = false;
                    boolean bl6 = false;
                    Object p12 = object4;
                    boolean bl7 = false;
                    creatureForm = (CreatureForm)((WitcheryRegistry)object2).get(p12);
                } else {
                    creatureForm = form = null;
                }
                if ((object = json.get("trait")) != null && (object = object.getAsString()) != null) {
                    object2 = object;
                    bl3 = false;
                    boolean bl8 = false;
                    Object p22 = object2;
                    boolean bl9 = false;
                    object2 = new ResourceLocation((String)p22);
                    WitcheryIdentityRegistry<ResourceLocation, CreatureTraitType<?>> witcheryIdentityRegistry = CreatureTraitType.REGISTRY;
                    bl8 = false;
                    boolean p22 = false;
                    Object p1 = object2;
                    boolean bl10 = false;
                    creatureTraitType = (CreatureTraitType)witcheryIdentityRegistry.get((ResourceLocation)p1);
                } else {
                    creatureTraitType = trait = null;
                }
                if (form == null && trait == null) {
                    throw (Throwable)new JsonSyntaxException("Form stats for " + key + " are invalid. If 'form' is not specified then 'trait' is required.");
                }
                formStats.setCreatureTraitType(trait);
                if (json.get("width") != null) {
                    boolean bl11 = false;
                    boolean bl12 = false;
                    Object it = object2;
                    boolean bl13 = false;
                    formStats.setWidth(it.getAsFloat());
                }
                if (json.get("height") != null) {
                    boolean bl14 = false;
                    boolean bl15 = false;
                    Object it = object2;
                    boolean bl16 = false;
                    formStats.setHeight(it.getAsFloat());
                }
                if (json.get("step_height") != null) {
                    boolean bl17 = false;
                    boolean bl18 = false;
                    Object it = object2;
                    boolean bl19 = false;
                    formStats.setStepHeight(it.getAsFloat());
                }
                if (json.get("eye_height") != null) {
                    boolean bl20 = false;
                    boolean bl21 = false;
                    Object it = object2;
                    boolean bl22 = false;
                    formStats.setEyeHeight(it.getAsFloat());
                }
                if (json.get("reflection_damage") != null) {
                    boolean bl23 = false;
                    boolean bl24 = false;
                    Object it = object2;
                    boolean bl25 = false;
                    formStats.setReflectionDamage(it.getAsDouble());
                }
                if (json.get("flying") != null) {
                    boolean bl26 = false;
                    boolean bl27 = false;
                    Object it = object2;
                    boolean bl28 = false;
                    formStats.setCanFly(it.getAsBoolean());
                }
                if (json.get("howling") != null) {
                    boolean bl29 = false;
                    boolean bl30 = false;
                    Object it = object2;
                    boolean bl31 = false;
                    formStats.setCanHowl(it.getAsBoolean());
                }
                if (json.get("holdable_item") != null) {
                    boolean bl32 = false;
                    boolean bl33 = false;
                    Object it = object2;
                    boolean bl34 = false;
                    formStats.setHoldableItem(WitcheryUtils.parseIngredient((JsonElement)it));
                }
                if (json.get("wears_armor") != null) {
                    boolean bl35 = false;
                    boolean bl36 = false;
                    Object it = object2;
                    boolean bl37 = false;
                    formStats.setWearsArmor(it.getAsBoolean());
                }
                JsonArray jsonArray = json.getAsJsonArray("stats");
                if (jsonArray != null) {
                    Iterable $this$forEach$iv = (Iterable)jsonArray;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        JsonElement it = (JsonElement)element$iv;
                        boolean bl38 = false;
                        JsonElement jsonElement = it;
                        Intrinsics.checkExpressionValueIsNotNull(jsonElement, "it");
                        JsonObject obj = jsonElement.getAsJsonObject();
                        Object2FloatOpenHashMap map2 = new Object2FloatOpenHashMap();
                        Iterator iterator3 = obj.entrySet().iterator();
                        while (iterator3.hasNext()) {
                            void k;
                            Map.Entry entry4;
                            Map.Entry entry5 = entry4 = (Map.Entry)iterator3.next();
                            boolean bl39 = false;
                            String string = (String)entry5.getKey();
                            entry5 = entry4;
                            bl39 = false;
                            JsonElement v = (JsonElement)entry5.getValue();
                            if (!(Intrinsics.areEqual(k, "level") ^ true)) continue;
                            Map map3 = (Map)map2;
                            Object v2 = CreatureFormStatType.REGISTRY.get((String)k);
                            JsonElement jsonElement2 = v;
                            Intrinsics.checkExpressionValueIsNotNull(jsonElement2, "v");
                            map3.put(v2, Float.valueOf(jsonElement2.getAsFloat()));
                        }
                        JsonElement jsonElement3 = obj.get("level");
                        ((Map)formStats.getStatModifiers()).put(jsonElement3 != null ? Integer.valueOf(jsonElement3.getAsInt()) : Integer.valueOf(0), map2);
                    }
                }
                if (form != null) {
                    byForm.put(form, formStats);
                    continue;
                }
                CreatureTraitType creatureTraitType2 = trait;
                if (creatureTraitType2 == null) {
                    Intrinsics.throwNpe();
                }
                formStats.setCreatureTraitType(creatureTraitType2);
                byTrait.put(trait, formStats);
            }
            catch (RuntimeException exception) {
                LOGGER.error("Couldn't parse creature form stats " + key, (Throwable)exception);
            }
        }
        LOGGER.info("Loaded " + (byForm.size() + byTrait.size()) + " creature form stats");
        WitcheryNetworkChannel.sendToAll(new PacketUpdateAlternateFormStats(byForm, byTrait));
    }

    public final void deserializeStats(@NotNull Map<CreatureForm, CreatureForm.Stats> formMap, @NotNull Map<CreatureTraitType<?>, CreatureForm.Stats> traitMap) {
        Intrinsics.checkParameterIsNotNull(formMap, "formMap");
        Intrinsics.checkParameterIsNotNull(traitMap, "traitMap");
        byForm = formMap;
        byTrait = traitMap;
    }

    private CreatureFormStatManager() {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        Intrinsics.checkExpressionValueIsNotNull(gson, "GsonBuilder().setPrettyP\u2026leHtmlEscaping().create()");
        super(gson, "creature_form_stats");
    }

    static {
        CreatureFormStatManager creatureFormStatManager;
        INSTANCE = creatureFormStatManager = new CreatureFormStatManager();
        LOGGER = LogManager.getLogger((String)("witchery/" + Reflection.getOrCreateKotlinClass(CreatureFormStatManager.class).getSimpleName()));
        boolean bl = false;
        byTrait = new LinkedHashMap();
        bl = false;
        byForm = new LinkedHashMap();
    }
}

