/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import net.minecraft.resources.JsonReloadListener;
import net.minecraft.resources.ResourceManager;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.msrandom.witchery.prediction.Prediction;
import net.msrandom.witchery.prediction.PredictionSerializer;
import net.msrandom.witchery.registry.WitcheryRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J \u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lnet/msrandom/witchery/resources/PredictionManager;", "Lnet/minecraft/resources/JsonReloadListener;", "()V", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "predictionRegistry", "Lnet/msrandom/witchery/registry/WitcheryRegistry;", "Lnet/minecraft/util/ResourceLocation;", "Lnet/msrandom/witchery/prediction/Prediction;", "registry", "getRegistry", "()Lnet/msrandom/witchery/registry/WitcheryRegistry;", "apply", "", "value", "", "Lcom/google/gson/JsonElement;", "resourceManager", "Lnet/minecraft/resources/ResourceManager;", "deserializePrediction", "weight", "", "translationKey", "", "json", "Lcom/google/gson/JsonObject;", "WitcheryResurrected"})
public final class PredictionManager
extends JsonReloadListener {
    private static final Logger LOGGER;
    private static WitcheryRegistry<ResourceLocation, Prediction> predictionRegistry;
    public static final PredictionManager INSTANCE;

    @NotNull
    public final WitcheryRegistry<ResourceLocation, Prediction> getRegistry() {
        return predictionRegistry;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void apply(@NotNull Map<ResourceLocation, ? extends JsonElement> value, @NotNull ResourceManager resourceManager) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        Intrinsics.checkParameterIsNotNull(resourceManager, "resourceManager");
        predictionRegistry = new WitcheryRegistry(0, 1, null);
        ResourceLocation resourceLocation = value;
        boolean bl = false;
        Iterator<Map.Entry<ResourceLocation, ? extends JsonElement>> iterator2 = resourceLocation.entrySet().iterator();
        while (iterator2.hasNext()) {
            void id;
            Map.Entry<ResourceLocation, ? extends JsonElement> entry2;
            Map.Entry<ResourceLocation, ? extends JsonElement> entry3 = entry2 = iterator2.next();
            boolean bl2 = false;
            resourceLocation = entry3.getKey();
            entry3 = entry2;
            bl2 = false;
            JsonElement element = entry3.getValue();
            try {
                JsonObject json = JsonUtils.func_151210_l((JsonElement)element, (String)"top element");
                if (json.size() == 0) continue;
                JsonElement jsonElement = json.get("weight");
                Intrinsics.checkExpressionValueIsNotNull(jsonElement, "json[\"weight\"]");
                int n = jsonElement.getAsInt();
                Object object = json.get("translation_key");
                if (object == null || (object = object.getAsString()) == null) {
                    object = "prediction." + id.func_110624_b() + '.' + id.func_110623_a();
                }
                JsonObject jsonObject = json;
                Intrinsics.checkExpressionValueIsNotNull(jsonObject, "json");
                predictionRegistry.set((ResourceLocation)id, this.deserializePrediction(n, (String)object, jsonObject));
            }
            catch (RuntimeException exception) {
                LOGGER.error("Parsing error loading prediction " + id, (Throwable)exception);
            }
        }
        LOGGER.info("Loaded " + predictionRegistry.getSize() + " crystal ball predictions");
    }

    private final Prediction deserializePrediction(int weight, String translationKey, JsonObject json) {
        String s = JsonUtils.func_151200_h((JsonObject)json, (String)"type");
        PredictionSerializer<?> predictionSerializer = PredictionSerializer.REGISTRY.get(new ResourceLocation(s));
        if (predictionSerializer == null) {
            throw (Throwable)new JsonSyntaxException("Invalid or unsupported prediction type '" + s + '\'');
        }
        PredictionSerializer<?> serializer = predictionSerializer;
        return serializer.read(weight, translationKey, json);
    }

    private PredictionManager() {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        Intrinsics.checkExpressionValueIsNotNull(gson, "GsonBuilder().setPrettyP\u2026leHtmlEscaping().create()");
        super(gson, "predictions");
    }

    static {
        PredictionManager predictionManager;
        INSTANCE = predictionManager = new PredictionManager();
        LOGGER = LogManager.getLogger((String)("witchery/" + Reflection.getOrCreateKotlinClass(PredictionManager.class).getSimpleName()));
        predictionRegistry = new WitcheryRegistry(0, 1, null);
    }
}

