/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.resources.JsonReloadListener;
import net.minecraft.resources.ResourceManager;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.msrandom.witchery.infusion.spirit.InfusedSpiritEffect;
import net.msrandom.witchery.infusion.spirit.SpiritEffectRecipe;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.network.resources.PacketUpdateSpiritEffects;
import net.msrandom.witchery.resources.SpiritEffectManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bH\u0002J$\u0010\u0014\u001a\u00020\u00122\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0014\u0010\u001b\u001a\u00020\u00122\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR#\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lnet/msrandom/witchery/resources/SpiritEffectManager;", "Lnet/minecraft/resources/JsonReloadListener;", "()V", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "<set-?>", "Ljava/util/SortedSet;", "Lnet/msrandom/witchery/infusion/spirit/SpiritEffectRecipe;", "effects", "getEffects", "()Ljava/util/SortedSet;", "grouped", "Ljava/util/SortedMap;", "Lnet/msrandom/witchery/infusion/spirit/InfusedSpiritEffect;", "getGrouped", "()Ljava/util/SortedMap;", "addGrouped", "", "recipe", "apply", "value", "", "Lnet/minecraft/util/ResourceLocation;", "Lcom/google/gson/JsonElement;", "resourceManager", "Lnet/minecraft/resources/ResourceManager;", "deserializeEffects", "WitcheryResurrected"})
public final class SpiritEffectManager
extends JsonReloadListener {
    private static final Logger LOGGER;
    @NotNull
    private static SortedSet<SpiritEffectRecipe> effects;
    @NotNull
    private static final SortedMap<InfusedSpiritEffect, SortedSet<SpiritEffectRecipe>> grouped;
    public static final SpiritEffectManager INSTANCE;

    @NotNull
    public final SortedSet<SpiritEffectRecipe> getEffects() {
        return effects;
    }

    @NotNull
    public final SortedMap<InfusedSpiritEffect, SortedSet<SpiritEffectRecipe>> getGrouped() {
        return grouped;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void apply(@NotNull Map<ResourceLocation, ? extends JsonElement> value, @NotNull ResourceManager resourceManager) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        Intrinsics.checkParameterIsNotNull(resourceManager, "resourceManager");
        effects.clear();
        grouped.clear();
        ResourceLocation resourceLocation = value;
        boolean bl = false;
        Iterator<Map.Entry<ResourceLocation, ? extends JsonElement>> iterator2 = resourceLocation.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ResourceLocation, ? extends JsonElement> entry2;
            Map.Entry<ResourceLocation, ? extends JsonElement> entry3 = entry2 = iterator2.next();
            boolean bl2 = false;
            resourceLocation = entry3.getKey();
            entry3 = entry2;
            bl2 = false;
            JsonElement element = entry3.getValue();
            try {
                JsonObject json = JsonUtils.func_151210_l((JsonElement)element, (String)"top element");
                if (json.size() == 0) continue;
                Object2IntOpenHashMap ghosts = new Object2IntOpenHashMap();
                Iterator iterator3 = json.getAsJsonObject("ghosts").entrySet().iterator();
                while (iterator3.hasNext()) {
                    void key;
                    Map.Entry entry4;
                    Map.Entry entry5 = entry4 = (Map.Entry)iterator3.next();
                    boolean bl3 = false;
                    String string = (String)entry5.getKey();
                    entry5 = entry4;
                    bl3 = false;
                    JsonElement count = (JsonElement)entry5.getValue();
                    Map map2 = (Map)ghosts;
                    Class clazz = EntityList.getClass((ResourceLocation)new ResourceLocation((String)key));
                    if (clazz == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<out net.minecraft.entity.EntityCreature>");
                    }
                    JsonElement jsonElement = count;
                    Intrinsics.checkExpressionValueIsNotNull(jsonElement, "count");
                    map2.put(clazz, jsonElement.getAsInt());
                }
                JsonElement jsonElement = json.get("result");
                Intrinsics.checkExpressionValueIsNotNull(jsonElement, "json[\"result\"]");
                Object v = InfusedSpiritEffect.REGISTRY.get(new ResourceLocation(jsonElement.getAsString()));
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                InfusedSpiritEffect result2 = (InfusedSpiritEffect)v;
                SpiritEffectRecipe recipe = new SpiritEffectRecipe((Object2IntMap<Class<? extends EntityCreature>>)((Object2IntMap)ghosts), JsonUtils.func_151209_a((JsonObject)json, (String)"hidden", (boolean)false), result2);
                effects.add(recipe);
                this.addGrouped(recipe);
            }
            catch (RuntimeException exception) {
                void id;
                LOGGER.error("Parsing error loading fetish spirit effect " + id, (Throwable)exception);
            }
        }
        LOGGER.info("Loaded " + effects.size() + " fetish spirit effects");
        WitcheryNetworkChannel.sendToAll(new PacketUpdateSpiritEffects(effects));
    }

    private final void addGrouped(SpiritEffectRecipe recipe) {
        grouped.computeIfAbsent(recipe.getResult(), addGrouped.1.INSTANCE).add(recipe);
    }

    public final void deserializeEffects(@NotNull SortedSet<SpiritEffectRecipe> effects2) {
        Intrinsics.checkParameterIsNotNull(effects2, "effects");
        effects = effects2;
        grouped.clear();
        Iterator iterator2 = effects2.iterator();
        while (iterator2.hasNext()) {
            SpiritEffectRecipe effect;
            SpiritEffectRecipe spiritEffectRecipe = effect = (SpiritEffectRecipe)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(spiritEffectRecipe, "effect");
            this.addGrouped(spiritEffectRecipe);
        }
    }

    private SpiritEffectManager() {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        Intrinsics.checkExpressionValueIsNotNull(gson, "GsonBuilder().setPrettyP\u2026leHtmlEscaping().create()");
        super(gson, "spirit_effects");
    }

    static {
        SpiritEffectManager spiritEffectManager;
        INSTANCE = spiritEffectManager = new SpiritEffectManager();
        LOGGER = LogManager.getLogger((String)("witchery/" + Reflection.getOrCreateKotlinClass(SpiritEffectManager.class).getSimpleName()));
        effects = SetsKt.sortedSetOf(new SpiritEffectRecipe[0]);
        grouped = MapsKt.sortedMapOf(new Pair[0]);
    }
}

