/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import net.minecraft.resources.JsonReloadListener;
import net.minecraft.resources.ResourceManager;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.msrandom.witchery.infusion.symbol.BranchStroke;
import net.msrandom.witchery.infusion.symbol.StrokeArray;
import net.msrandom.witchery.infusion.symbol.StrokeSet;
import net.msrandom.witchery.infusion.symbol.SymbolEffect;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.network.resources.PacketUpdateSymbolEffects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0019\u001a\u00020\fJ\u0010\u0010\u001a\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001b\u001a\u00020\bJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u001a\u0010\u001d\u001a\u00020\u00112\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0013R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0006\u001a\"\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007j\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lnet/msrandom/witchery/resources/SymbolEffectManager;", "Lnet/minecraft/resources/JsonReloadListener;", "()V", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "cache", "Ljava/util/HashMap;", "Lnet/msrandom/witchery/infusion/symbol/StrokeArray;", "Lnet/msrandom/witchery/infusion/symbol/StrokeSet;", "Lkotlin/collections/HashMap;", "defaults", "Lnet/msrandom/witchery/infusion/symbol/SymbolEffect;", "effects", "getEffects", "()Ljava/util/HashMap;", "apply", "", "value", "", "Lnet/minecraft/util/ResourceLocation;", "Lcom/google/gson/JsonElement;", "resourceManager", "Lnet/minecraft/resources/ResourceManager;", "getDefaultStrokes", "effect", "getEffect", "strokes", "getUncached", "updateEffects", "WitcheryResurrected"})
public final class SymbolEffectManager
extends JsonReloadListener {
    private static final Logger LOGGER;
    @NotNull
    private static final HashMap<StrokeArray, StrokeSet> effects;
    private static final HashMap<StrokeArray, StrokeSet> cache;
    private static final HashMap<SymbolEffect, StrokeSet> defaults;
    public static final SymbolEffectManager INSTANCE;

    @NotNull
    public final HashMap<StrokeArray, StrokeSet> getEffects() {
        return effects;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void apply(@NotNull Map<ResourceLocation, ? extends JsonElement> value, @NotNull ResourceManager resourceManager) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        Intrinsics.checkParameterIsNotNull(resourceManager, "resourceManager");
        effects.clear();
        cache.clear();
        defaults.clear();
        ResourceLocation resourceLocation = value;
        boolean bl = false;
        Iterator<Map.Entry<ResourceLocation, ? extends JsonElement>> iterator2 = resourceLocation.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ResourceLocation, ? extends JsonElement> entry2;
            Map.Entry<ResourceLocation, ? extends JsonElement> entry3 = entry2 = iterator2.next();
            boolean bl2 = false;
            resourceLocation = entry3.getKey();
            entry3 = entry2;
            bl2 = false;
            JsonElement element = entry3.getValue();
            try {
                JsonObject json = JsonUtils.func_151210_l((JsonElement)element, (String)"top element");
                if (json.size() == 0) continue;
                JsonElement jsonElement = json.get("level");
                int level = jsonElement != null ? jsonElement.getAsInt() : 1;
                JsonArray strokeArray = JsonUtils.func_151214_t((JsonObject)json, (String)"strokes");
                byte[] strokes = new byte[strokeArray.size()];
                int n = strokeArray.size();
                boolean bl3 = false;
                int n2 = 0;
                n2 = 0;
                int n3 = n;
                while (n2 < n3) {
                    String string;
                    Locale locale;
                    String string2;
                    int it = n2++;
                    boolean bl4 = false;
                    JsonElement jsonElement2 = strokeArray.get(it);
                    Intrinsics.checkExpressionValueIsNotNull(jsonElement2, "strokeArray[it]");
                    Intrinsics.checkExpressionValueIsNotNull(jsonElement2.getAsString(), "strokeArray[it].asString");
                    Intrinsics.checkExpressionValueIsNotNull(Locale.ROOT, "Locale.ROOT");
                    int n4 = it;
                    byte[] byArray = strokes;
                    boolean bl5 = false;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull(string3.toUpperCase(locale), "(this as java.lang.String).toUpperCase(locale)");
                    byArray[n4] = (byte)BranchStroke.valueOf(string).ordinal();
                }
                Object v = SymbolEffect.REGISTRY.get(new ResourceLocation(JsonUtils.func_151200_h((JsonObject)json, (String)"result")));
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                SymbolEffect result2 = (SymbolEffect)v;
                JsonElement jsonElement3 = json.get("default");
                StrokeSet set2 = new StrokeSet(result2, level, new StrokeArray(strokes), jsonElement3 != null && jsonElement3.getAsBoolean());
                if (set2.isDefault()) {
                    Map map2 = defaults;
                    n3 = 0;
                    Map map3 = map2;
                    boolean bl6 = false;
                    if (!map3.containsKey(result2)) {
                        ((Map)defaults).put(result2, set2);
                    }
                }
                ((Map)effects).put(set2.getStrokes(), set2);
            }
            catch (RuntimeException exception) {
                void key;
                LOGGER.error("Parsing error loading symbol effect " + key, (Throwable)exception);
            }
        }
        LOGGER.info("Loaded " + effects.size() + " symbol effects");
        WitcheryNetworkChannel.sendToAll(new PacketUpdateSymbolEffects((Map<StrokeArray, StrokeSet>)effects));
    }

    @Nullable
    public final StrokeSet getDefaultStrokes(@NotNull SymbolEffect effect) {
        Intrinsics.checkParameterIsNotNull(effect, "effect");
        return defaults.get(effect);
    }

    @Nullable
    public final StrokeSet getEffect(@NotNull StrokeArray strokes) {
        Intrinsics.checkParameterIsNotNull(strokes, "strokes");
        StrokeSet strokeSet = cache.get(strokes);
        if (strokeSet != null) {
            StrokeSet strokeSet2 = strokeSet;
            boolean bl = false;
            boolean bl2 = false;
            StrokeSet it = strokeSet2;
            boolean bl3 = false;
            return it;
        }
        StrokeSet result2 = this.getUncached(strokes);
        ((Map)cache).put(strokes, result2);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final StrokeSet getUncached(StrokeArray strokes) {
        Object object = effects;
        boolean bl = false;
        Iterator iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            void effectStrokes;
            Map.Entry entry2;
            Map.Entry entry3 = entry2 = iterator2.next();
            boolean bl2 = false;
            object = (StrokeArray)entry3.getKey();
            entry3 = entry2;
            bl2 = false;
            StrokeSet effect = (StrokeSet)entry3.getValue();
            if (!effectStrokes.matches(strokes)) continue;
            return effect;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateEffects(@NotNull Map<StrokeArray, StrokeSet> effects2) {
        Intrinsics.checkParameterIsNotNull(effects2, "effects");
        Object object = effects2;
        boolean bl = false;
        for (Map.Entry<StrokeArray, StrokeSet> entry2 : object.entrySet()) {
            void strokes;
            Object object2 = entry2;
            boolean bl2 = false;
            object = object2.getKey();
            object2 = entry2;
            bl2 = false;
            StrokeSet set2 = object2.getValue();
            ((Map)effects).put(strokes, set2);
            if (!set2.isDefault()) continue;
            object2 = defaults;
            SymbolEffect symbolEffect = set2.getResult();
            boolean bl3 = false;
            Object object3 = object2;
            boolean bl4 = false;
            if (object3.containsKey(symbolEffect)) continue;
            ((Map)defaults).put(set2.getResult(), set2);
        }
    }

    private SymbolEffectManager() {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        Intrinsics.checkExpressionValueIsNotNull(gson, "GsonBuilder().setPrettyP\u2026leHtmlEscaping().create()");
        super(gson, "symbol_effects");
    }

    static {
        SymbolEffectManager symbolEffectManager;
        INSTANCE = symbolEffectManager = new SymbolEffectManager();
        LOGGER = LogManager.getLogger((String)("witchery/" + Reflection.getOrCreateKotlinClass(SymbolEffectManager.class).getSimpleName()));
        boolean bl = false;
        effects = new HashMap();
        bl = false;
        cache = new HashMap();
        bl = false;
        defaults = new HashMap();
    }
}

