/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import kotlin.jvm.functions.Function1;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.item.WitcheryPoppetItems;
import net.msrandom.witchery.rite.effect.RiteEffectExpandingEffect;

public class RiteEffectBlight
extends RiteEffectExpandingEffect {
    public static final Function1<JsonObject, RiteEffectBlight> DESERIALIZER = json -> new RiteEffectBlight(JsonUtils.func_151208_a((JsonObject)json, (String)"radius", (int)80), JsonUtils.func_151208_a((JsonObject)json, (String)"height", (int)15));

    public RiteEffectBlight(int radius, int height2) {
        super(radius, height2, true);
    }

    @Override
    public boolean doRadiusAction(World world, BlockPos pos, int radius, EntityPlayer player, boolean enhanced) {
        double radiusSq = radius * radius;
        double minSq = Math.max(0, (radius - 1) * (radius - 1));
        for (EntityPlayer victim : world.field_73010_i) {
            double distanceSq = victim.func_174818_b(pos);
            if (!(distanceSq > minSq) || !(distanceSq <= radiusSq)) continue;
            if (WitcheryPoppetItems.voodooProtectionActivated(player, ItemStack.field_190927_a, (EntityLivingBase)victim, 6)) {
                return false;
            }
            if (victim.func_70644_a(MobEffects.field_76431_k)) continue;
            victim.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 2400, 1));
        }
        ArrayList<EntityVillager> villagersToZombify = new ArrayList<EntityVillager>();
        ArrayList<EntityCow> cowsToSchroom = new ArrayList<EntityCow>();
        ArrayList<Object> animalsToSlay = new ArrayList<Object>();
        for (Entity entity : world.field_72996_f) {
            EntityAnimal victim4;
            double distanceSq2;
            if (entity instanceof EntityVillager) {
                EntityVillager victim2 = (EntityVillager)entity;
                distanceSq2 = victim2.func_174818_b(pos);
                if (distanceSq2 <= minSq || distanceSq2 > radiusSq || world.field_73012_v.nextInt(10) != 0) continue;
                villagersToZombify.add(victim2);
                continue;
            }
            if (entity instanceof EntityCow) {
                EntityCow victim3 = (EntityCow)entity;
                distanceSq2 = victim3.func_174818_b(pos);
                if (distanceSq2 <= minSq || distanceSq2 > radiusSq) continue;
                if (world.field_73012_v.nextInt(20) == 0) {
                    cowsToSchroom.add(victim3);
                    continue;
                }
                if (world.field_73012_v.nextInt(3) != 0) continue;
                animalsToSlay.add(victim3);
                continue;
            }
            if (!(entity instanceof EntityAnimal) || (distanceSq2 = (victim4 = (EntityAnimal)entity).func_174818_b(pos)) <= minSq || distanceSq2 > radiusSq || world.field_73012_v.nextInt(3) != 0) continue;
            animalsToSlay.add(victim4);
        }
        for (EntityVillager entityVillager : villagersToZombify) {
            EntityZombieVillager entityzombie = new EntityZombieVillager(world);
            entityzombie.func_82149_j((Entity)entityVillager);
            world.func_72900_e((Entity)entityVillager);
            entityzombie.func_180482_a(world.func_175649_E(entityzombie.func_180425_c()), null);
            entityzombie.setForgeProfession(entityVillager.getProfessionForge());
            if (entityVillager.func_70631_g_()) {
                entityzombie.func_82227_f(true);
            }
            world.func_72838_d((Entity)entityzombie);
            world.func_175718_b(1016, entityzombie.func_180425_c(), 0);
        }
        for (EntityCow entityCow : cowsToSchroom) {
            EntityMooshroom entityzombie2 = new EntityMooshroom(world);
            entityzombie2.func_82149_j((Entity)entityCow);
            world.func_72900_e((Entity)entityCow);
            entityzombie2.func_180482_a(world.func_175649_E(entityzombie2.func_180425_c()), null);
            world.func_72838_d((Entity)entityzombie2);
            world.func_175718_b(1016, entityzombie2.func_180425_c(), 0);
        }
        for (EntityAnimal entityAnimal : animalsToSlay) {
            entityAnimal.func_70097_a(DamageSource.field_76376_m, 20.0f);
        }
        return true;
    }

    @Override
    public void doBlockAction(World world, BlockPos pos, int currentRadius, EntityPlayer player, boolean enhanced) {
        if (!world.field_72995_K) {
            BlockPos down = pos.func_177977_b();
            IBlockState state = world.func_180495_p(pos);
            IBlockState stateBelow = world.func_180495_p(down);
            Block blockID = state.func_177230_c();
            Block blockBelowID = stateBelow.func_177230_c();
            if (blockID == Blocks.field_150329_H) {
                world.func_175698_g(pos);
                this.blightGround(world, down, blockBelowID, enhanced);
            } else if (blockID == Blocks.field_150328_O || blockID == Blocks.field_150327_N || blockID == Blocks.field_150459_bM || blockID == Blocks.field_150464_aj || blockID == Blocks.field_150469_bN || blockID == Blocks.field_150393_bb || blockID == Blocks.field_150394_bc || blockID == Blocks.field_150440_ba || blockID == Blocks.field_150423_aK) {
                world.func_175656_a(pos, Blocks.field_150330_I.func_176223_P());
                this.blightGround(world, down, blockBelowID, enhanced);
            } else if (blockID == Blocks.field_150458_ak) {
                world.func_175656_a(pos, Blocks.field_150354_m.func_176223_P());
            } else if (state.func_185904_a().func_76220_a()) {
                this.blightGround(world, pos, blockID, enhanced);
            } else if (stateBelow.func_185904_a().func_76220_a()) {
                this.blightGround(world, down, blockBelowID, enhanced);
            }
        }
    }

    public void blightGround(World world, BlockPos pos, Block blockBelowID, boolean enhanced) {
        if (blockBelowID == Blocks.field_150346_d || blockBelowID == Blocks.field_150349_c || blockBelowID == Blocks.field_150391_bh || blockBelowID == Blocks.field_150458_ak) {
            int rand = world.field_73012_v.nextInt(enhanced ? 4 : 5);
            if (rand == 0) {
                world.func_175656_a(pos, Blocks.field_150354_m.func_176223_P());
            } else if (rand == 1) {
                world.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
            }
        }
    }
}

