/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;

public class RiteEffectBroiling
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectBroiling> DESERIALIZER = json -> {
        JsonElement radius = json.get("radius");
        return new RiteEffectBroiling(radius == null ? 5.0f : radius.getAsFloat(), json.get("burn_chance").getAsDouble());
    };
    private final float radius;
    private final double burnChance;

    public RiteEffectBroiling(float radius, double burnChance) {
        this.radius = radius;
        this.burnChance = burnChance;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (!world.field_72995_K) {
            List<EntityItem> items = this.getItemsInRadius(world, pos, this.radius);
            int count = 0;
            for (EntityItem item : items) {
                ItemStack cookedStack = FurnaceRecipes.func_77602_a().func_151395_a(item.func_92059_d());
                if (!(cookedStack.func_77973_b() instanceof ItemFood) || item.func_92059_d().func_190916_E() <= 0) continue;
                int size = item.func_92059_d().func_190916_E();
                int burnCount = 0;
                for (int i = 0; i < size; ++i) {
                    if (!(world.field_73012_v.nextDouble() < this.burnChance)) continue;
                    ++burnCount;
                }
                item.func_70106_y();
                if (size - burnCount > 0) {
                    cookedStack.func_190920_e(size - burnCount);
                    EntityItem cookedEntity = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.05, (double)pos.func_177952_p(), cookedStack);
                    cookedEntity.field_70159_w = 0.0;
                    cookedEntity.field_70179_y = 0.0;
                    world.func_72838_d((Entity)cookedEntity);
                }
                if (burnCount > 0) {
                    EntityItem burntEntity = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.05, (double)pos.func_177952_p(), new ItemStack(Items.field_151044_h, burnCount, 1));
                    burntEntity.field_70159_w = 0.0;
                    burntEntity.field_70179_y = 0.0;
                    world.func_72838_d((Entity)burntEntity);
                }
                ++count;
            }
            if (count == 0) {
                return RiteHandler.Result.ABORTED_REFUND;
            }
            world.func_184133_a(null, pos, SoundEvents.field_187557_bK, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 3.0f, 2.0f, EnumParticleTypes.FLAME), world, pos);
        }
        return RiteHandler.Result.COMPLETED;
    }
}

