/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonObject;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChunkData;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.BiomeDictionary;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.brewing.ItemKey;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;

public class RiteEffectClimateChange
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectClimateChange> DESERIALIZER = json -> new RiteEffectClimateChange(JsonUtils.func_151208_a((JsonObject)json, (String)"radius", (int)16));
    public static final BiMap<ItemKey, BiomeDictionary.Type> FOCIS = HashBiMap.create();
    protected final int radius;

    public RiteEffectClimateChange(int radius) {
        this.radius = radius;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (ticks < 20) {
            return RiteHandler.Result.STARTING;
        }
        if (ticks == 20) {
            world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
        }
        if (world.field_72995_K) {
            return RiteHandler.Result.COMPLETED;
        }
        EntityPlayer player = ritual.getInitiatingPlayer(world);
        Biome biome = world.getBiomeForCoordsBody(pos);
        if (world.field_73011_w.getDimension() == 1 || world.field_73011_w.getDimension() == -1 || biome == Biomes.field_76779_k || biome == Biomes.field_76778_j) {
            world.func_184133_a(null, pos, SoundEvents.field_187688_dI, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            if (player != null) {
                player.func_145747_a(new TextComponentTranslation("rite.witchery.invalid_dimension", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
            return RiteHandler.Result.ABORTED_REFUND;
        }
        if (ritual.covenSize < 4) {
            world.func_184133_a(null, pos, SoundEvents.field_187688_dI, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            if (player != null) {
                player.func_145747_a(new TextComponentTranslation("rite.witchery.weak_coven", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
            return RiteHandler.Result.ABORTED_REFUND;
        }
        if ((long)ticks % 20L == 0L) {
            if (stage.incrementAndGet() < 5) {
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 1.0f), (double)pos.func_177952_p() + 0.5, (float)stage.get() * 2.0f, (float)stage.get() * 1.1f, EnumParticleTypes.SPELL_INSTANT), world, pos.func_177984_a(), 16.0);
            } else if (stage.get() == 5) {
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 1.0f), (double)pos.func_177952_p() + 0.5, (float)stage.get() * 2.0f, (float)stage.get() * 1.5f, EnumParticleTypes.EXPLOSION_HUGE), world, pos.func_177984_a(), 16.0);
                double RADIUS = 8.0;
                List items = world.func_72872_a(EntityItem.class, new AxisAlignedBB(pos.func_177963_a(-RADIUS, -2.0, -RADIUS), pos.func_177963_a(RADIUS, 2.0, RADIUS)));
                BiomeDictionary.Type biomeType = BiomeDictionary.Type.END;
                WeatherChange weather = WeatherChange.NONE;
                int glowstone = 0;
                for (EntityItem item : items) {
                    ItemStack stack = item.func_92059_d();
                    BiomeDictionary.Type type2 = (BiomeDictionary.Type)FOCIS.get((Object)ItemKey.fromStack(stack));
                    if (type2 == null) {
                        if (stack.func_77973_b() != Items.field_151114_aO) continue;
                        glowstone += stack.func_190916_E();
                    } else {
                        if (type2 == BiomeDictionary.Type.SNOWY) {
                            weather = WeatherChange.RAIN;
                        } else if (type2 == BiomeDictionary.Type.SANDY) {
                            weather = WeatherChange.SUN;
                        } else if (type2 == BiomeDictionary.Type.OCEAN) {
                            weather = WeatherChange.THUNDER;
                        }
                        biomeType = type2;
                    }
                    world.func_72900_e((Entity)item);
                    item.field_70170_p.func_184133_a(null, item.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.5f, 0.4f / (item.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(item.field_70165_t, item.field_70163_u, item.field_70161_v, 0.5f, 1.0f, EnumParticleTypes.SPELL_INSTANT), (Entity)item);
                }
                if (biomeType == BiomeDictionary.Type.END) {
                    world.func_184133_a(null, pos, SoundEvents.field_187688_dI, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    if (player != null) {
                        player.func_145747_a(new TextComponentTranslation("rite.witchery.no_biome_foci", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                    }
                    return RiteHandler.Result.ABORTED_REFUND;
                }
                List<Biome> biomes = CollectionsKt.sortedWith(BiomeDictionary.getBiomes((BiomeDictionary.Type)biomeType), Comparator.comparingInt(Biome::func_185362_a));
                if (biomes.isEmpty()) {
                    world.func_184133_a(null, pos, SoundEvents.field_187688_dI, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    if (player != null) {
                        player.func_145747_a(new TextComponentTranslation("rite.witchery.no_biome_foci", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED)));
                    }
                    return RiteHandler.Result.ABORTED_REFUND;
                }
                int biomeID = Biome.func_185362_a((Biome)biomes.get(glowstone > 0 ? Math.min(glowstone, biomes.size()) - 1 : (biomes.size() >= 3 ? world.field_73012_v.nextInt(3) : 0)));
                int maxRadius = this.radius * (ritual.covenSize - 3);
                HashMap<ChunkPos, byte[]> chunkMap = new HashMap<ChunkPos, byte[]>();
                this.drawFilledCircle(world, pos, maxRadius, chunkMap, weather, biomeID);
                for (Map.Entry<ChunkPos, byte[]> entry2 : chunkMap.entrySet()) {
                    Chunk chunk = world.func_72964_e(entry2.getKey().field_77276_a, entry2.getKey().field_77275_b);
                    chunk.func_76616_a(entry2.getValue());
                    chunk.func_76630_e();
                    SPacketChunkData packet2 = new SPacketChunkData(chunk, 65535);
                    for (EntityPlayer playerEntity : world.field_73010_i) {
                        ((EntityPlayerMP)playerEntity).field_71135_a.func_147359_a((Packet)packet2);
                    }
                }
                if (world instanceof WorldServer) {
                    WorldInfo worldinfo = world.func_72912_H();
                    int i = (300 + world.field_73012_v.nextInt(600)) * 20;
                    switch (weather) {
                        case SUN: {
                            if (!world.func_72896_J() && !world.func_72911_I()) break;
                            worldinfo.func_76080_g(0);
                            worldinfo.func_76090_f(0);
                            worldinfo.func_76084_b(false);
                            worldinfo.func_76069_a(false);
                            break;
                        }
                        case RAIN: {
                            if (world.func_72896_J() || world.func_72911_I()) break;
                            worldinfo.func_76080_g(i);
                            worldinfo.func_76090_f(i);
                            worldinfo.func_76084_b(true);
                            worldinfo.func_76069_a(false);
                            break;
                        }
                        case THUNDER: {
                            if (world.func_72911_I()) break;
                            worldinfo.func_76080_g(i);
                            worldinfo.func_76090_f(i);
                            worldinfo.func_76084_b(true);
                            worldinfo.func_76069_a(true);
                        }
                    }
                }
                return RiteHandler.Result.COMPLETED;
            }
            return RiteHandler.Result.UPKEEP;
        }
        return RiteHandler.Result.UPKEEP;
    }

    protected void drawFilledCircle(World world, BlockPos pos, int radius, HashMap<ChunkPos, byte[]> chunkMap, WeatherChange weather, int biomeID) {
        int x = radius;
        int radiusError = 1 - x;
        for (int z = 0; x >= z; ++z) {
            this.drawLine(world, pos.func_177982_a(-x, 0, z), pos.func_177982_a(x, 0, z), chunkMap, weather, biomeID);
            this.drawLine(world, pos.func_177982_a(-z, 0, x), pos.func_177982_a(z, 0, x), chunkMap, weather, biomeID);
            this.drawLine(world, pos.func_177982_a(-x, 0, -z), pos.func_177982_a(x, 0, z), chunkMap, weather, biomeID);
            this.drawLine(world, pos.func_177982_a(-z, 0, -x), pos.func_177982_a(z, 0, -x), chunkMap, weather, biomeID);
            if (radiusError < 0) {
                radiusError += 2 * z + 1;
                continue;
            }
            radiusError += 2 * (z - --x + 1);
        }
    }

    protected void drawLine(World world, BlockPos x1, BlockPos x2, HashMap<ChunkPos, byte[]> chunkMap, WeatherChange weather, int biomeID) {
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)x1, (BlockPos)x2)) {
            ChunkPos coord = new ChunkPos(pos);
            byte[] map2 = chunkMap.get(coord);
            if (map2 == null) {
                Chunk chunk = world.func_175726_f(pos);
                map2 = (byte[])chunk.func_76605_m().clone();
                chunkMap.put(coord, map2);
            }
            map2[(pos.func_177952_p() & 0xF) << 4 | pos.func_177958_n() & 0xF] = (byte)biomeID;
            if (weather != WeatherChange.SUN || world.func_180495_p(pos = world.func_175672_r(pos)).func_177230_c() != Blocks.field_150433_aE) continue;
            world.func_175698_g(pos);
        }
    }

    static {
        FOCIS.put((Object)ItemKey.get(Blocks.field_150345_g), (Object)BiomeDictionary.Type.FOREST);
        FOCIS.put((Object)ItemKey.get((Block)Blocks.field_150329_H, 1), (Object)BiomeDictionary.Type.PLAINS);
        FOCIS.put((Object)ItemKey.get(Blocks.field_150348_b), (Object)BiomeDictionary.Type.SAVANNA);
        FOCIS.put((Object)ItemKey.get(Blocks.field_150343_Z), (Object)BiomeDictionary.Type.MOUNTAIN);
        FOCIS.put((Object)ItemKey.get(Items.field_151123_aH), (Object)BiomeDictionary.Type.SWAMP);
        FOCIS.put((Object)ItemKey.get(Items.field_151131_as), (Object)BiomeDictionary.Type.OCEAN);
        FOCIS.put((Object)ItemKey.get((Block)WitcheryBlocks.ARTICHOKE_SEEDS), (Object)BiomeDictionary.Type.RIVER);
        FOCIS.put((Object)ItemKey.get((Block)Blocks.field_150434_aF), (Object)BiomeDictionary.Type.SANDY);
        FOCIS.put((Object)ItemKey.get(WitcheryIngredientItems.ICY_NEEDLE), (Object)BiomeDictionary.Type.SNOWY);
        FOCIS.put((Object)ItemKey.get(Blocks.field_150345_g, 3), (Object)BiomeDictionary.Type.JUNGLE);
        FOCIS.put((Object)ItemKey.get((Block)Blocks.field_150354_m), (Object)BiomeDictionary.Type.BEACH);
        FOCIS.put((Object)ItemKey.get((Block)Blocks.field_150337_Q), (Object)BiomeDictionary.Type.MUSHROOM);
    }

    public static enum WeatherChange {
        NONE,
        SUN,
        RAIN,
        THUNDER;

    }
}

