/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.msrandom.witchery.block.BlockAreaMarker;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.entity.EntityWereVillager;
import net.msrandom.witchery.entity.EntityWerewolf;
import net.msrandom.witchery.entity.EntityWitchHunter;
import net.msrandom.witchery.entity.familiar.Familiars;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.init.WitcheryCreatureTraits;
import net.msrandom.witchery.init.data.WitcheryFamiliars;
import net.msrandom.witchery.item.ItemHunterClothes;
import net.msrandom.witchery.item.ItemTaglockKit;
import net.msrandom.witchery.item.WitcheryPoppetItems;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;
import net.msrandom.witchery.rite.sacrifice.ItemRiteSacrifice;
import net.msrandom.witchery.transformation.WerewolfCreatureTrait;
import net.msrandom.witchery.util.WitcheryUtils;

public class RiteEffectCurseOfTheWolf
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectCurseOfTheWolf> DESERIALIZER = json -> new RiteEffectCurseOfTheWolf(ItemRiteSacrifice.parseIdentifier(json.get("target").getAsString()), !json.get("remove").getAsBoolean());
    private final long target;
    private final boolean curse;

    public RiteEffectCurseOfTheWolf(long target, boolean curse) {
        this.target = target;
        this.curse = curse;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (!world.field_72995_K) {
            EntityLivingBase entity;
            boolean complete = false;
            boolean cursed = false;
            EntityPlayer curseMasterPlayer = ritual.getInitiatingPlayer(world);
            if (!WitcheryUtils.isFullMoon(world)) {
                curseMasterPlayer.func_145747_a(new TextComponentTranslation("rite.witchery.wolf_curse.not_full_moon", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                return RiteHandler.Result.ABORTED_REFUND;
            }
            if (!Familiars.hasFamiliarPower(curseMasterPlayer, WitcheryFamiliars.CURSE_MASTERY)) {
                curseMasterPlayer.func_145747_a(new TextComponentTranslation("rite.witchery.wolf_curse.no_curse_mastery", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                return RiteHandler.Result.ABORTED_REFUND;
            }
            if (ritual.covenSize < 6) {
                curseMasterPlayer.func_145747_a(new TextComponentTranslation("rite.witchery.wolf_curse.coven_not_full", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                return RiteHandler.Result.ABORTED_REFUND;
            }
            RiteEffect.SacrificedItem sacrificedItem = (RiteEffect.SacrificedItem)ritual.sacrificedItems.get(this.target);
            if (sacrificedItem != null && (entity = ItemTaglockKit.getBoundEntity(world, sacrificedItem.getStack(), 0)) != null) {
                if (this.curse) {
                    EntityWitchHunter.blackMagicPerformed(curseMasterPlayer);
                    boolean isImmune = ItemHunterClothes.isCurseProtectionActive(entity);
                    if (!isImmune) {
                        isImmune = BlockAreaMarker.AreaMarkerRegistry.instance().isProtectionActive(entity, this);
                    }
                    if (!isImmune && !WitcheryPoppetItems.voodooProtectionActivated(curseMasterPlayer, ItemStack.field_190927_a, entity, 3)) {
                        if (entity instanceof EntityPlayer) {
                            EntityPlayer player = (EntityPlayer)entity;
                            PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
                            if (!WitcheryConfigOptions.allowVampireWolfHybrids && playerEx.isTransformation(WitcheryCreatureTraits.VAMPIRE)) {
                                curseMasterPlayer.func_145747_a(new TextComponentTranslation("rite.witchery.wolf_curse.hybridsnotallow", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                            } else {
                                WerewolfCreatureTrait transformation = playerEx.getTransformation(WitcheryCreatureTraits.WEREWOLF);
                                if (transformation.getLevel() == 0) {
                                    transformation.setLevel(1);
                                    playerEx.markChanged();
                                    player.func_145747_a(new TextComponentTranslation("witchery.werewolf.infection", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)));
                                    complete = true;
                                    cursed = true;
                                } else {
                                    curseMasterPlayer.func_145747_a(new TextComponentTranslation("rite.witchery.wolf_curse.already_cursed", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                                }
                            }
                        } else if (entity instanceof EntityVillager && !(entity instanceof EntityWereVillager)) {
                            EntityVillager villager = (EntityVillager)entity;
                            NBTTagCompound data2 = new NBTTagCompound();
                            villager.func_70014_b(data2);
                            EntityWerewolf.convertToVillager((EntityLiving)villager, data2, true);
                            complete = true;
                            cursed = true;
                        } else {
                            curseMasterPlayer.func_145747_a(new TextComponentTranslation("rite.witchery.wolf_curse.different_creature", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                        }
                    }
                    if (isImmune && curseMasterPlayer != null) {
                        curseMasterPlayer.func_145747_a(new TextComponentTranslation("rite.witchery.magic_dissipating", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                    }
                } else if (entity instanceof EntityPlayer) {
                    EntityPlayer player2 = (EntityPlayer)entity;
                    PlayerExtendedData playerEx2 = WitcheryUtils.getExtension(player2);
                    WerewolfCreatureTrait transformation = playerEx2.getTransformation(WitcheryCreatureTraits.WEREWOLF);
                    if (transformation.getLevel() > 0) {
                        double MAX_RANGE_SQ = 64.0;
                        if (transformation.getLevel() == 1 || player2.func_174818_b(pos) <= MAX_RANGE_SQ) {
                            if (world.field_73012_v.nextInt(4) != 0) {
                                transformation.setLevel(0);
                                playerEx2.markChanged();
                            } else {
                                cursed = true;
                            }
                            complete = true;
                        } else {
                            curseMasterPlayer.func_145747_a(new TextComponentTranslation("rite.witchery.wolf_curse.too_far", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                        }
                    } else {
                        curseMasterPlayer.func_145747_a(new TextComponentTranslation("rite.witchery.wolf_curse.not_cursed", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                    }
                } else if (entity instanceof EntityWereVillager) {
                    EntityWereVillager villagerWere = (EntityWereVillager)entity;
                    EntityWerewolf.convertToCuredVillager((EntityLiving)villagerWere, villagerWere.getVillagerData());
                    complete = true;
                } else if (entity instanceof EntityWerewolf) {
                    EntityWerewolf werewolf = (EntityWerewolf)entity;
                    EntityWerewolf.convertToCuredVillager((EntityLiving)werewolf, werewolf.getVillagerData());
                    complete = true;
                } else {
                    curseMasterPlayer.func_145747_a(new TextComponentTranslation("rite.witchery.wolf_curse.not_cursed", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                }
            }
            if (!complete) {
                return RiteHandler.Result.ABORTED_REFUND;
            }
            if (cursed) {
                world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187525_aO, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5, 1.0f, 2.0f, EnumParticleTypes.FLAME), world, pos);
            } else {
                world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5, 1.0f, 2.0f, EnumParticleTypes.SPELL_INSTANT), world, pos);
            }
        }
        return RiteHandler.Result.COMPLETED;
    }
}

