/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;

public class RiteEffectEclipse
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectEclipse> DESERIALIZER = json -> new RiteEffectEclipse(JsonUtils.func_151208_a((JsonObject)json, (String)"cooldown", (int)0));
    private static final Object2LongMap<DimensionType> lastEclipseTimes = new Object2LongOpenHashMap();
    private final int cooldown;

    public RiteEffectEclipse(int cooldown) {
        this.cooldown = cooldown;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (!world.field_72995_K) {
            EntityPlayer player = ritual.getInitiatingPlayer(world);
            DimensionType dimensionType = world.field_73011_w.func_186058_p();
            if ((long)this.cooldown > 0L && world.field_73010_i.size() > 1 && lastEclipseTimes.containsKey((Object)dimensionType)) {
                long lastActivation = lastEclipseTimes.getLong((Object)dimensionType);
                if (world.func_82737_E() < lastActivation + (long)this.cooldown) {
                    if (player != null) {
                        player.func_145747_a(new TextComponentTranslation("rite.witchery.eclipse.cooldown", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                    }
                    return RiteHandler.Result.ABORTED_REFUND;
                }
            }
            long i = world.func_72912_H().func_76073_f();
            world.func_72912_H().func_76068_b(i - i % 24000L + 18000L);
            lastEclipseTimes.put((Object)dimensionType, world.func_82737_E());
        }
        return RiteHandler.Result.COMPLETED;
    }

    @Override
    public int getRunTime() {
        return 30;
    }
}

