/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.WitcheryBlockSapling;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;
import net.msrandom.witchery.util.MutableBlock;
import net.msrandom.witchery.util.WitcheryUtils;

public class RiteEffectForestation
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectForestation> DESERIALIZER = json -> new RiteEffectForestation(JsonUtils.func_151208_a((JsonObject)json, (String)"radius", (int)20), JsonUtils.func_151208_a((JsonObject)json, (String)"height", (int)8), JsonUtils.func_151208_a((JsonObject)json, (String)"duration", (int)60), WitcheryUtils.parseBlockState(json.get("state").getAsString()));
    private final int radius;
    private final int height;
    private final int duration;
    private final IBlockState state;

    public RiteEffectForestation(int radius, int height2, int duration, IBlockState state) {
        this.radius = radius;
        this.height = height2;
        this.duration = duration;
        this.state = state;
    }

    public boolean isAirOrReplaceableBlock(World world, BlockPos pos) {
        IBlockState blockID = world.func_180495_p(pos);
        if (blockID.func_177230_c() == Blocks.field_150350_a) {
            return true;
        }
        Material block = blockID.func_185904_a();
        return !block.func_76224_d() && block.func_76222_j();
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (world.field_72995_K) {
            return RiteHandler.Result.COMPLETED;
        }
        if (stage.incrementAndGet() < this.duration + ritual.covenSize * 5) {
            int modradius = this.radius + ritual.covenSize * 2;
            int modradiussq = (modradius + 1) * (modradius + 1);
            pos = pos.func_177977_b();
            BlockPos p = pos.func_177982_a(world.field_73012_v.nextInt(modradius * 2) - modradius, 0, world.field_73012_v.nextInt(modradius * 2) - modradius);
            int height2 = -1;
            if (p.func_177954_c((double)pos.func_177958_n(), (double)p.func_177956_o(), (double)pos.func_177952_p()) > (double)modradiussq && (p = pos.func_177982_a(world.field_73012_v.nextInt(modradius * 2) - modradius, 0, world.field_73012_v.nextInt(modradius * 2) - modradius)).func_177954_c((double)pos.func_177958_n(), (double)p.func_177956_o(), (double)pos.func_177952_p()) > (double)modradiussq) {
                return RiteHandler.Result.UPKEEP;
            }
            world.func_175718_b(2005, p.func_177981_b(2), 0);
            Material material = world.func_180495_p(p).func_185904_a();
            if (!material.func_76220_a() || !world.func_175623_d(p.func_177984_a())) {
                for (int h = 1; h < this.height; ++h) {
                    material = world.func_180495_p(p.func_177981_b(h)).func_185904_a();
                    if (material.func_76220_a() && this.isAirOrReplaceableBlock(world, p.func_177981_b(h + 1))) {
                        height2 = h;
                    } else {
                        material = world.func_180495_p(p.func_177979_c(h)).func_185904_a();
                        if (!material.func_76220_a() || !this.isAirOrReplaceableBlock(world, pos.func_177979_c(h - 1))) continue;
                        height2 = -h;
                    }
                    break;
                }
            } else {
                height2 = 0;
            }
            if (height2 != -1) {
                world.func_175718_b(2005, p.func_177981_b(height2 + 1), 0);
                this.drawPixel(world, p.func_177981_b(height2 + 1), this.state);
            }
            return RiteHandler.Result.UPKEEP;
        }
        return RiteHandler.Result.COMPLETED;
    }

    protected void drawPixel(World world, BlockPos pos, IBlockState state) {
        Material materialAbove = world.func_180495_p(pos).func_185904_a();
        if (!materialAbove.func_76220_a()) {
            new MutableBlock(state).mutate(world, pos, false);
            int count = 0;
            ItemDye.func_179234_a((ItemStack)new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.WHITE.func_176767_b()), (World)world, (BlockPos)pos);
            Block sapling2 = world.func_180495_p(pos).func_177230_c();
            while ((sapling2 == Blocks.field_150345_g || sapling2 instanceof WitcheryBlockSapling) && count++ < 10) {
                ItemDye.func_179234_a((ItemStack)new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.WHITE.func_176767_b()), (World)world, (BlockPos)pos);
                sapling2 = world.func_180495_p(pos).func_177230_c();
            }
        }
    }
}

