/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.List;
import kotlin.jvm.functions.Function1;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.common.IPowerSource;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.entity.EntityDemon;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.rite.effect.RiteEffectExpandingEffect;

public class RiteEffectHellOnEarth
extends RiteEffectExpandingEffect {
    public static final Function1<JsonObject, RiteEffectHellOnEarth> DESERIALIZER = json -> new RiteEffectHellOnEarth(JsonUtils.func_151208_a((JsonObject)json, (String)"radius", (int)20), JsonUtils.func_151208_a((JsonObject)json, (String)"height", (int)15), JsonUtils.func_151221_a((JsonObject)json, (String)"power", (float)200.0f));
    private final float upkeepCost;

    public RiteEffectHellOnEarth(int radius, int height2, float upkeepCost) {
        super(radius, height2, true);
        this.upkeepCost = upkeepCost;
    }

    @Override
    public boolean isComplete(World world, BlockPos pos, int ticks, boolean fullyExpanded) {
        if (fullyExpanded && (long)ticks % 40L == 0L) {
            IPowerSource powerSource = this.findNewPowerSource(world, pos);
            if (powerSource == null) {
                return true;
            }
            if (!powerSource.consumePower(this.upkeepCost)) {
                return true;
            }
            double roll = world.field_73012_v.nextDouble();
            Object entity = roll < 0.02 ? new EntityDemon(world) : (roll < 0.1 ? new EntityGhast(world) : (roll < 0.4 ? new EntityBlaze(world) : (roll < 0.6 ? new EntityMagmaCube(world) : new EntityPigZombie(world))));
            entity.func_180482_a(world.func_175649_E(entity.func_180425_c()), null);
            entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 2.0, (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
            world.func_72838_d((Entity)entity);
            world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 2.0, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187600_C, entity.func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 2.0, (double)pos.func_177952_p() + 0.5, 1.0f, 2.0f, EnumParticleTypes.EXPLOSION_LARGE), world, pos.func_177981_b(2));
        }
        return false;
    }

    @Override
    public boolean doRadiusAction(World world, BlockPos pos, int radius, EntityPlayer player, boolean enhanced) {
        return true;
    }

    @Override
    public void doBlockAction(World world, BlockPos pos, int currentRadius, EntityPlayer player, boolean enhanced) {
        if (!world.field_72995_K) {
            IBlockState blockID = world.func_180495_p(pos);
            IBlockState blockBelowID = world.func_180495_p(pos.func_177977_b());
            if (blockID.func_177230_c() == Blocks.field_150329_H) {
                if (WitcheryConfigOptions.allowHellOnEarthFires && enhanced) {
                    world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
                }
                this.blightGround(world, pos.func_177977_b(), blockBelowID.func_177230_c(), currentRadius);
            } else if (blockID.func_177230_c() == Blocks.field_150328_O || blockID.func_177230_c() == Blocks.field_150327_N || blockID.func_177230_c() == Blocks.field_150459_bM || blockID.func_177230_c() == Blocks.field_150464_aj || blockID.func_177230_c() == Blocks.field_150469_bN || blockID.func_177230_c() == Blocks.field_150393_bb || blockID.func_177230_c() == Blocks.field_150394_bc || blockID.func_177230_c() == Blocks.field_150440_ba || blockID.func_177230_c() == Blocks.field_150423_aK) {
                if (WitcheryConfigOptions.allowHellOnEarthFires && enhanced) {
                    world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
                }
                this.blightGround(world, pos.func_177977_b(), blockBelowID.func_177230_c(), currentRadius);
            } else if (blockID.func_185904_a().func_76220_a()) {
                this.blightGround(world, pos, blockID.func_177230_c(), currentRadius);
            } else if (blockBelowID.func_185904_a().func_76220_a()) {
                this.blightGround(world, pos.func_177977_b(), blockBelowID.func_177230_c(), currentRadius);
            }
        }
    }

    public void blightGround(World world, BlockPos pos, Block blockBelowID, int currentRadius) {
        int rand;
        if ((blockBelowID == Blocks.field_150346_d || blockBelowID == Blocks.field_150349_c || blockBelowID == Blocks.field_150391_bh || blockBelowID == Blocks.field_150458_ak || blockBelowID == Blocks.field_150354_m) && (rand = world.field_73012_v.nextInt(currentRadius < this.maxRadius / 3 ? 2 : (currentRadius < this.maxRadius / 2 ? 4 : 6))) == 0) {
            world.func_175656_a(pos, Blocks.field_150424_aL.func_176223_P());
        }
    }

    private IPowerSource findNewPowerSource(World world, BlockPos pos) {
        List<PowerSources.RelativePowerSource> sources = PowerSources.instance().get(world, pos);
        return sources != null && sources.size() > 0 ? sources.get(0).source() : null;
    }
}

