/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.common.IPowerSource;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;

public class RiteEffectInfusionRecharge
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectInfusionRecharge> DESERIALIZER = json -> new RiteEffectInfusionRecharge(JsonUtils.func_151208_a((JsonObject)json, (String)"charges", (int)10), JsonUtils.func_151208_a((JsonObject)json, (String)"radius", (int)4), JsonUtils.func_151221_a((JsonObject)json, (String)"upkeep_cost", (float)40.0f), JsonUtils.func_151208_a((JsonObject)json, (String)"lifetime", (int)0));
    private final float upkeepPowerCost;
    private final int charges;
    private final int radius;
    private final int ticksToLive;

    public RiteEffectInfusionRecharge(int charges, int radius, float upkeepPowerCost, int ticksToLive) {
        this.charges = charges;
        this.radius = radius;
        this.upkeepPowerCost = upkeepPowerCost;
        this.ticksToLive = ticksToLive;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (this.upkeepPowerCost > 0.0f) {
            IPowerSource powerSource = this.findNewPowerSource(world, pos);
            if (powerSource == null) {
                return RiteHandler.Result.ABORTED;
            }
            if (!powerSource.consumePower(this.upkeepPowerCost)) {
                return RiteHandler.Result.ABORTED;
            }
        }
        if (this.ticksToLive > 0 && stage.incrementAndGet() >= this.ticksToLive) {
            return RiteHandler.Result.COMPLETED;
        }
        int r = this.radius;
        AxisAlignedBB bounds = new AxisAlignedBB(pos.func_177982_a(-r, 0, -r), pos.func_177982_a(r, 1, r));
        for (EntityPlayer player : world.func_72872_a(EntityPlayer.class, bounds)) {
            int maxEnergy;
            int currentEnergy;
            if (!(player.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) <= (double)r) || (currentEnergy = Infusion.getCurrentEnergy(player)) >= (maxEnergy = Infusion.getMaxEnergy(player))) continue;
            Infusion.setCurrentEnergy(player, Math.min(currentEnergy + this.charges, maxEnergy));
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_189107_dL, SoundCategory.PLAYERS, 0.5f, 0.4f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.field_70165_t, player.field_70163_u, player.field_70161_v, 1.0f, 2.0f, EnumParticleTypes.SPELL_INSTANT), (Entity)player);
        }
        return RiteHandler.Result.UPKEEP;
    }

    private IPowerSource findNewPowerSource(World world, BlockPos pos) {
        List<PowerSources.RelativePowerSource> sources = PowerSources.instance().get(world, pos);
        return sources != null && sources.size() > 0 ? sources.get(0).source() : null;
    }
}

