/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;
import net.msrandom.witchery.rite.sacrifice.ItemRiteSacrifice;
import net.msrandom.witchery.util.WitcheryUtils;

public class RiteEffectItemSummoning
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectItemSummoning> DESERIALIZER = json -> {
        JsonElement particle;
        ArrayList<ItemRiteSacrifice.SummonedItemAction> actions = new ArrayList<ItemRiteSacrifice.SummonedItemAction>();
        JsonObject stack = json.getAsJsonObject("stack");
        JsonArray array = stack.getAsJsonArray("actions");
        if (array != null) {
            for (JsonElement element : array) {
                if (element.isJsonObject()) {
                    JsonObject jsonObject = element.getAsJsonObject();
                    Function1 serializer = (Function1)ItemRiteSacrifice.SummonedItemAction.DESERIALIZER_REGISTRY.get(new ResourceLocation(jsonObject.get("type").getAsString()));
                    actions.add((ItemRiteSacrifice.SummonedItemAction)serializer.invoke(jsonObject));
                    continue;
                }
                Function1 serializer = (Function1)ItemRiteSacrifice.SummonedItemAction.DESERIALIZER_REGISTRY.get(new ResourceLocation(element.getAsString()));
                actions.add((ItemRiteSacrifice.SummonedItemAction)serializer.invoke(new JsonObject()));
            }
        }
        EnumParticleTypes particles = (particle = json.get("particles")) == null ? EnumParticleTypes.SPELL : EnumParticleTypes.func_186831_a((String)particle.getAsString());
        return new RiteEffectItemSummoning(WitcheryUtils.parseStack(stack), actions, particles == null ? EnumParticleTypes.SPELL : particles, JsonUtils.func_151221_a((JsonObject)json, (String)"particle_offset", (float)0.5f), JsonUtils.func_151221_a((JsonObject)json, (String)"position", (float)1.5f), JsonUtils.func_151221_a((JsonObject)json, (String)"motion", (float)0.3f));
    };
    private final ItemStack stack;
    private final List<ItemRiteSacrifice.SummonedItemAction> actions;
    private final EnumParticleTypes particles;
    private final float particleOffset;
    private final float position;
    private final float motion;

    public RiteEffectItemSummoning(ItemStack stack, List<ItemRiteSacrifice.SummonedItemAction> actions, EnumParticleTypes particles, float particleOffset, float position, float motion) {
        this.stack = stack;
        this.actions = actions;
        this.particles = particles;
        this.particleOffset = particleOffset;
        this.position = position;
        this.motion = motion;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (!world.field_72995_K) {
            int failed = 0;
            ItemStack newStack = this.stack.func_77946_l();
            for (ItemRiteSacrifice.SummonedItemAction action : this.actions) {
                if (action.invoke(newStack, world, pos, ritual).booleanValue()) continue;
                ++failed;
            }
            if (!this.actions.isEmpty() && failed == this.actions.size()) {
                return RiteHandler.Result.ABORTED_REFUND;
            }
            EntityItem entity = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)((float)pos.func_177956_o() + this.position), (double)pos.func_177952_p() + 0.5, newStack);
            entity.field_70181_x = this.motion;
            world.func_72838_d((Entity)entity);
            entity.field_70170_p.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            WitcheryUtils.addNewParticles(world, this.particles, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 0.0, Math.min(MathHelper.func_76143_f((double)(Math.max((double)this.particleOffset, 1.0) * 20.0)), 300), this.particleOffset, this.particleOffset);
        }
        return RiteHandler.Result.COMPLETED;
    }
}

