/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.BlockFetish;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;
import net.msrandom.witchery.util.BlockUtil;

public class RiteEffectMovingEarth
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectMovingEarth> DESERIALIZER = json -> new RiteEffectMovingEarth(JsonUtils.func_151203_m((JsonObject)json, (String)"radius"), JsonUtils.func_151208_a((JsonObject)json, (String)"height", (int)8));
    private final int radius;
    private final int height;

    public RiteEffectMovingEarth(int radius, int height2) {
        this.radius = radius;
        this.height = height2;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (world.field_72995_K) {
            return RiteHandler.Result.COMPLETED;
        }
        if (stage.incrementAndGet() == 1) {
            world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 0.5f, 1.0f, EnumParticleTypes.PORTAL), world, pos);
        }
        int radius = this.radius + ritual.covenSize * 2;
        int AIR_SPACE = radius * 2;
        BlockPos depth = pos.func_177981_b(AIR_SPACE);
        while (depth.func_177956_o() >= pos.func_177956_o() - this.height) {
            this.drawFilledCircle(world, depth, radius, depth.func_177956_o() == pos.func_177956_o() - 1);
            depth = depth.func_177977_b();
        }
        AxisAlignedBB bounds = new AxisAlignedBB(pos.func_177982_a(-radius, 0, -radius), pos.func_177982_a(radius, AIR_SPACE, radius));
        for (Entity entity : world.func_72872_a(Entity.class, bounds)) {
            if (!(entity.func_174818_b(pos) <= (double)(radius * radius))) continue;
            if (entity instanceof EntityLivingBase) {
                entity.func_70634_a(entity.field_70165_t, entity.field_70163_u + 1.0, entity.field_70161_v);
                continue;
            }
            entity.field_70145_X = true;
            entity.func_70107_b(entity.field_70165_t, entity.field_70163_u + 1.0, entity.field_70161_v);
            entity.field_70145_X = false;
        }
        if (stage.get() < this.height - 1) {
            return RiteHandler.Result.UPKEEP;
        }
        return RiteHandler.Result.COMPLETED;
    }

    protected void drawFilledCircle(World world, BlockPos pos, int radius, boolean topLayer) {
        int x = radius;
        int radiusError = 1 - x;
        for (int z = 0; x >= z; ++z) {
            this.drawLine(world, pos.func_177982_a(-x, 0, z), pos.func_177982_a(x, 0, z), topLayer, radius, pos.func_177952_p());
            this.drawLine(world, pos.func_177982_a(-z, 0, x), pos.func_177982_a(z, 0, x), topLayer, radius, pos.func_177952_p());
            this.drawLine(world, pos.func_177982_a(-x, 0, -z), pos.func_177982_a(x, 0, -z), topLayer, radius, pos.func_177952_p());
            this.drawLine(world, pos.func_177982_a(-z, 0, -x), pos.func_177982_a(z, 0, -x), topLayer, radius, pos.func_177952_p());
            if (radiusError < 0) {
                radiusError += 2 * z + 1;
                continue;
            }
            radiusError += 2 * (z - --x + 1);
        }
    }

    protected void drawLine(World world, BlockPos x1, BlockPos x2, boolean topLayer, int radius, int midZ) {
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)x1, (BlockPos)x2)) {
            boolean edgeZ;
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            Block highBlock = world.func_180495_p(pos.func_177984_a()).func_177230_c();
            Block lowBlock = world.func_180495_p(pos.func_177977_b()).func_177230_c();
            if (block == Blocks.field_150350_a || !BlockUtil.isMovableBlock(block) || !BlockUtil.isMovableBlock(highBlock) || !BlockUtil.isMovableBlock(lowBlock)) continue;
            boolean bl = edgeZ = midZ + radius == x1.func_177952_p() || midZ - radius == x2.func_177952_p();
            if (!topLayer && (edgeZ || pos.equals((Object)x1) || pos.equals((Object)x2)) && world.field_73012_v.nextInt(7) == 0) continue;
            if (block.hasTileEntity(state)) {
                TileEntity tileEntity = world.func_175625_s(pos);
                if (tileEntity == null || block instanceof BlockFetish && !((BlockFetish)block).isSpectral()) continue;
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                world.func_180501_a(pos.func_177984_a(), state, 2);
                world.func_175690_a(pos.func_177984_a(), tileEntity);
                tileEntity.func_145829_t();
                continue;
            }
            world.func_180501_a(pos.func_177984_a(), state, 2);
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        }
    }

    @Override
    public int getRunTime() {
        return 5;
    }
}

