/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.WitcheryBlockLeaves;
import net.msrandom.witchery.block.WitcheryBlockSapling;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryWoodTypes;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;
import net.msrandom.witchery.util.BlockStatePredicate;
import net.msrandom.witchery.util.MutableBlock;

public class RiteEffectNaturesPower
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectNaturesPower> DESERIALIZER = json -> new RiteEffectNaturesPower(JsonUtils.func_151208_a((JsonObject)json, (String)"radius", (int)14), JsonUtils.func_151208_a((JsonObject)json, (String)"height", (int)8), JsonUtils.func_151208_a((JsonObject)json, (String)"duration", (int)150), JsonUtils.func_151208_a((JsonObject)json, (String)"expanse", (int)2));
    private final int radius;
    private final int height;
    private final int duration;
    private final int expanse;

    public RiteEffectNaturesPower(int radius, int height2, int duration, int expanse) {
        this.radius = radius;
        this.height = height2;
        this.duration = duration;
        this.expanse = expanse;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (world.field_72995_K) {
            return RiteHandler.Result.COMPLETED;
        }
        if (stage.incrementAndGet() < this.duration + ritual.covenSize * 5) {
            int modradius = this.radius + ritual.covenSize * 2;
            pos = pos.func_177982_a(world.field_73012_v.nextInt(modradius * 2) - modradius, -1, world.field_73012_v.nextInt(modradius * 2) - modradius);
            int height2 = -1;
            world.func_175718_b(2005, pos.func_177981_b(2), 0);
            Material material = world.func_180495_p(pos).func_185904_a();
            if (!material.func_76220_a() || !world.func_175623_d(pos.func_177984_a())) {
                for (int h = 1; h < this.height; ++h) {
                    material = world.func_180495_p(pos.func_177981_b(h)).func_185904_a();
                    if (material.func_76220_a() && world.func_175623_d(pos.func_177981_b(h + 1))) {
                        height2 = h;
                    } else {
                        material = world.func_180495_p(pos.func_177979_c(h)).func_185904_a();
                        BlockPos p = pos.func_177979_c(h - 1);
                        if (!material.func_76220_a() || !world.func_175623_d(p) && world.func_180495_p(p).func_177230_c() != Blocks.field_150433_aE) continue;
                        height2 = -h;
                    }
                    break;
                }
            } else {
                height2 = 0;
            }
            if (height2 != -1) {
                world.func_175718_b(2005, pos.func_177981_b(height2 + 1), 0);
                this.drawFilledCircle(world, pos.func_177981_b(height2), this.expanse + 1);
            }
            return RiteHandler.Result.UPKEEP;
        }
        return RiteHandler.Result.COMPLETED;
    }

    protected void drawFilledCircle(World world, BlockPos pos, int radius) {
        int x = radius;
        int radiusError = 1 - x;
        for (int z = 0; x >= z; ++z) {
            this.drawLine(world, pos.func_177982_a(-x, 0, z), pos.func_177982_a(x, 0, z), radius);
            this.drawLine(world, pos.func_177982_a(-z, 0, x), pos.func_177982_a(z, 0, x), radius);
            this.drawLine(world, pos.func_177982_a(-x, 0, -z), pos.func_177982_a(x, 0, -z), radius);
            this.drawLine(world, pos.func_177982_a(-z, 0, -x), pos.func_177982_a(z, 0, -x), radius);
            if (radiusError < 0) {
                radiusError += 2 * z + 1;
                continue;
            }
            radiusError += 2 * (z - --x + 1);
        }
    }

    protected void drawLine(World world, BlockPos x1, BlockPos x2, int radius) {
        BlockPos modX1 = radius > 1 && world.field_73012_v.nextInt(5) == 0 ? x1.func_177974_f() : x1;
        BlockPos modX2 = radius > 1 && world.field_73012_v.nextInt(5) == 0 ? x2.func_177976_e() : x2;
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)modX1, (BlockPos)modX2)) {
            this.drawPixel(world, pos);
        }
    }

    private boolean isNeighbourBlockID(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177974_f()).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(pos.func_177976_e()).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(pos.func_177968_d()).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(pos.func_177978_c()).func_177230_c() == Blocks.field_150355_j;
    }

    /*
     * Unable to fully structure code
     */
    protected void drawPixel(World world, BlockPos pos) {
        block6: {
            block7: {
                up = pos.func_177984_a();
                state = world.func_180495_p(pos);
                block = state.func_177230_c();
                above = world.func_180495_p(up);
                materialAbove = above.func_185904_a();
                if (materialAbove.func_76220_a()) break block6;
                matches = false;
                for (BlockStatePredicate naturePowerReplaceableBlock : WitcheryConfigOptions.naturePowerReplaceableBlocks) {
                    if (naturePowerReplaceableBlock.getBlock() != block || !naturePowerReplaceableBlock.getProperties().matches(state)) continue;
                    matches = true;
                    break;
                }
                if (!matches || world.field_73012_v.nextInt(8) == 0) break block7;
                if (materialAbove == Material.field_151582_l) ** GOTO lbl-1000
                v0 = world.field_73012_v.nextDouble();
                v1 = this.isNeighbourBlockID(world, pos) != false ? 0.7 : 0.02;
                if (v0 <= v1) {
                    world.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
                } else lbl-1000:
                // 2 sources

                {
                    world.func_175656_a(pos, Blocks.field_150349_c.func_176223_P());
                }
                block = Blocks.field_150349_c;
            }
            if (materialAbove != Material.field_151582_l && block != Blocks.field_150350_a && block != Blocks.field_150362_t && !(block instanceof WitcheryBlockLeaves) && world.field_73012_v.nextInt(4) == 0) {
                blocks = Arrays.asList(new MutableBlock[]{new MutableBlock(Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.OAK)), new MutableBlock(Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.SPRUCE)), new MutableBlock(Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.BIRCH)), new MutableBlock(Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.JUNGLE)), new MutableBlock(Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.ACACIA)), new MutableBlock(Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.DARK_OAK)), new MutableBlock(WitcheryWoodTypes.ROWAN.getSapling().func_176223_P()), new MutableBlock(WitcheryWoodTypes.ALDER.getSapling().func_176223_P()), new MutableBlock(WitcheryWoodTypes.HAWTHORN.getSapling().func_176223_P()), new MutableBlock(WitcheryBlocks.EMBER_MOSS.func_176223_P()), new MutableBlock(Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS), 7), new MutableBlock(Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.FERN), 7), new MutableBlock(Blocks.field_150338_P.func_176223_P()), new MutableBlock(Blocks.field_150337_Q.func_176223_P()), new MutableBlock(Blocks.field_150328_O.func_176223_P()), new MutableBlock(Blocks.field_150327_N.func_176223_P()), new MutableBlock(Blocks.field_150423_aK.func_176223_P()), new MutableBlock(Blocks.field_150440_ba.func_176223_P()), new MutableBlock(WitcheryBlocks.GLINT_WEED.func_176223_P())});
                ((MutableBlock)WeightedRandom.func_76271_a((Random)world.field_73012_v, blocks)).mutate(world, up, false);
            }
            if (world.field_73012_v.nextInt(3) == 0) {
                count = 0;
                ItemDye.func_179234_a((ItemStack)new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.WHITE.func_176767_b()), (World)world, (BlockPos)up);
                sapling = above.func_177230_c();
                while ((sapling == Blocks.field_150345_g || sapling instanceof WitcheryBlockSapling) && count++ < 8) {
                    ItemDye.func_179234_a((ItemStack)new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.WHITE.func_176767_b()), (World)world, (BlockPos)up);
                    sapling = above.func_177230_c();
                }
            }
        }
    }
}

