/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;
import net.msrandom.witchery.rite.sacrifice.ItemRiteSacrifice;
import net.msrandom.witchery.util.WitcheryUtils;

public class RiteEffectPartEarth
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectPartEarth> DESERIALIZER = json -> new RiteEffectPartEarth(ItemRiteSacrifice.parseIdentifier(json.get("foci").getAsString()), JsonUtils.func_151208_a((JsonObject)json, (String)"length", (int)60), JsonUtils.func_151208_a((JsonObject)json, (String)"width", (int)1), JsonUtils.func_151208_a((JsonObject)json, (String)"depth", (int)10));
    private static final Random RANDOM = new Random();
    private final long foci;
    private final int length;
    private final int width;
    private final int depth;

    public RiteEffectPartEarth(long foci, int length, int width, int depth) {
        this.foci = foci;
        this.length = length;
        this.width = width;
        this.depth = depth;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (stage.get() == 0 && ticks % 20 != 0) {
            return RiteHandler.Result.STARTING;
        }
        if (!world.field_72995_K) {
            RANDOM.setSeed(ritual.id);
            int width = this.width + (ritual.covenSize > 2 ? 2 : 0);
            int index = stage.getAndIncrement() + 4;
            BlockPos coord = pos.func_177977_b();
            Direction last = Direction.getFromHeading(coord, ((RiteEffect.SacrificedItem)ritual.sacrificedItems.get(this.foci)).getLocation());
            if (last == null) {
                last = Direction.NORTH;
            }
            for (int i = 1; i < this.length; ++i) {
                last = this.move(RANDOM, last, Math.max(20 - i / 2, 6));
                coord = coord.func_177982_a(last.x, 0, last.z);
                if (i != index) continue;
                this.drawFilledCircle(world, coord, width + (world.field_73012_v.nextInt(3) == 0 ? 1 : 0), this.depth - 2 + world.field_73012_v.nextInt(5));
                break;
            }
        }
        return stage.get() >= this.length - 5 ? RiteHandler.Result.COMPLETED : RiteHandler.Result.UPKEEP;
    }

    protected void drawFilledCircle(World world, BlockPos pos, int radius, int depth) {
        int x = radius;
        int radiusError = 1 - x;
        for (int z = 0; x >= z; ++z) {
            this.drawLine(world, pos.func_177982_a(-x, 0, z), pos.func_177982_a(x, 0, z), depth);
            this.drawLine(world, pos.func_177982_a(-z, 0, x), pos.func_177982_a(z, 0, x), depth);
            this.drawLine(world, pos.func_177982_a(-x, 0, -z), pos.func_177982_a(x, 0, -z), depth);
            this.drawLine(world, pos.func_177982_a(-z, 0, -x), pos.func_177982_a(z, 0, -x), depth);
            if (radiusError < 0) {
                radiusError += 2 * z + 1;
                continue;
            }
            radiusError += 2 * (z - --x + 1);
        }
    }

    protected void drawLine(World world, BlockPos x1, BlockPos x2, int depth) {
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)x1, (BlockPos)x2)) {
            this.drawPixel(world, pos, depth);
        }
    }

    protected void drawPixel(World world, BlockPos pos, int depth) {
        for (int d = 0; d < depth; ++d) {
            if (!WitcheryUtils.canBreak(world.func_180495_p(pos.func_177979_c(d)))) continue;
            world.func_175698_g(pos.func_177979_c(d));
        }
    }

    private Direction move(Random random, Direction last, int probability) {
        int val = random.nextInt(probability);
        switch (last) {
            case NORTH: {
                if (val == 0) {
                    return Direction.NORTH_EAST;
                }
                if (val == 1) {
                    return Direction.NORTH_WEST;
                }
                return Direction.NORTH;
            }
            case NORTH_EAST: {
                if (val == 0) {
                    return Direction.NORTH;
                }
                if (val == 1) {
                    return Direction.EAST;
                }
                return Direction.NORTH_EAST;
            }
            case EAST: {
                if (val == 0) {
                    return Direction.NORTH_EAST;
                }
                if (val == 1) {
                    return Direction.SOUTH_EAST;
                }
                return Direction.EAST;
            }
            case SOUTH_EAST: {
                if (val == 0) {
                    return Direction.EAST;
                }
                if (val == 1) {
                    return Direction.SOUTH;
                }
                return Direction.SOUTH_EAST;
            }
            case SOUTH: {
                if (val == 0) {
                    return Direction.SOUTH_EAST;
                }
                if (val == 1) {
                    return Direction.SOUTH_WEST;
                }
                return Direction.SOUTH;
            }
            case SOUTH_WEST: {
                if (val == 0) {
                    return Direction.SOUTH;
                }
                if (val == 1) {
                    return Direction.WEST;
                }
                return Direction.SOUTH_WEST;
            }
            case WEST: {
                if (val == 0) {
                    return Direction.SOUTH_WEST;
                }
                if (val == 1) {
                    return Direction.NORTH_WEST;
                }
                return Direction.WEST;
            }
        }
        if (val == 0) {
            return Direction.WEST;
        }
        if (val == 1) {
            return Direction.NORTH;
        }
        return Direction.NORTH_WEST;
    }

    @Override
    public int getRunTime() {
        return 1;
    }

    private static enum Direction {
        WEST(-1, 0),
        NORTH_WEST(-1, -1),
        NORTH(0, -1),
        NORTH_EAST(1, -1),
        EAST(1, 0),
        SOUTH_EAST(1, 1),
        SOUTH(0, 1),
        SOUTH_WEST(-1, 1);

        private final int x;
        private final int z;

        private Direction(int x, int z) {
            this.x = x;
            this.z = z;
        }

        private static Direction getFromHeading(BlockPos original, BlockPos destination) {
            double x = original.func_177958_n() - destination.func_177958_n();
            double z = original.func_177952_p() - destination.func_177952_p();
            double yaw = Math.atan2(z, x);
            if (yaw > -0.39269908169872414 && yaw <= 0.39269908169872414) {
                return WEST;
            }
            if (yaw > 0.39269908169872414 && yaw <= 1.1780972450961724) {
                return NORTH_WEST;
            }
            if (yaw > 1.1780972450961724 && yaw <= 1.9634954084936207) {
                return NORTH;
            }
            if (yaw > 1.9634954084936207 && yaw <= 2.748893571891069) {
                return NORTH_EAST;
            }
            if (yaw > 2.748893571891069 || yaw <= -2.748893571891069) {
                return EAST;
            }
            if (yaw > -2.748893571891069 && yaw <= -1.9634954084936207) {
                return SOUTH_EAST;
            }
            if (yaw > -1.9634954084936207 && yaw <= -1.1780972450961724) {
                return SOUTH;
            }
            return SOUTH_WEST;
        }
    }
}

