/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;

public class RiteEffectPriorIncarnation
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectPriorIncarnation> DESERIALIZER = json -> new RiteEffectPriorIncarnation(JsonUtils.func_151208_a((JsonObject)json, (String)"radius", (int)5), JsonUtils.func_151208_a((JsonObject)json, (String)"area_of_effect", (int)16));
    public static final String PRIOR_INV_KEY = "WitcheryPriIncInv";
    public static final String PRIOR_USR_KEY = "WitcheryPriIncUsr";
    public static final String PRIOR_LOC_KEY = "WitcheryPriIncLoc";
    private final int radius;
    private final int aoe;

    public RiteEffectPriorIncarnation(int radius, int aoe) {
        this.radius = radius;
        this.aoe = aoe;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (stage.get() == 0) {
            return RiteHandler.Result.STARTING;
        }
        if (!world.field_72995_K) {
            int r = this.radius;
            AxisAlignedBB bounds = new AxisAlignedBB(pos.func_177982_a(-r, 0, -r), pos.func_177982_a(r, 1, r));
            boolean found = false;
            for (EntityPlayer player2 : world.func_72872_a(EntityPlayer.class, bounds)) {
                double z;
                double y;
                NBTTagCompound nbt;
                if (!(player2.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) <= (double)r) || !(nbt = player2.getEntityData()).func_74764_b(PRIOR_INV_KEY) || !nbt.func_74764_b("WitcheryPriIncLocX") || !nbt.func_74764_b("WitcheryPriIncLocY") || !nbt.func_74764_b("WitcheryPriIncLocZ")) continue;
                NBTTagList tagList = nbt.func_150295_c(PRIOR_INV_KEY, 10);
                double x = nbt.func_74769_h("WitcheryPriIncLocX");
                double dSq = pos.func_177954_c(x, y = nbt.func_74769_h("WitcheryPriIncLocY"), z = nbt.func_74769_h("WitcheryPriIncLocZ"));
                if (dSq > (double)(this.aoe * this.aoe) || tagList.func_74745_c() <= 0) continue;
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    NBTTagCompound tag = tagList.func_150305_b(i);
                    ItemStack stack = new ItemStack(tag);
                    if (stack.func_190926_b()) continue;
                    world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack));
                }
                EntitySkeleton skeleton = new EntitySkeleton(world);
                skeleton.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0f, 0.0f);
                skeleton.func_96094_a(player2.func_70005_c_());
                world.func_72838_d((Entity)skeleton);
                nbt.func_82580_o(PRIOR_INV_KEY);
                nbt.func_82580_o("WitcheryPriIncLocX");
                nbt.func_82580_o("WitcheryPriIncLocY");
                nbt.func_82580_o("WitcheryPriIncLocZ");
                found = true;
            }
            if (found) {
                world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 0.5f, 0.4f / ((float)world.field_73012_v.nextDouble() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 3.0f, 3.0f, EnumParticleTypes.EXPLOSION_HUGE), world, pos);
            } else {
                world.func_184133_a(null, pos, SoundEvents.field_187688_dI, SoundCategory.PLAYERS, 0.5f, 0.4f / ((float)world.field_73012_v.nextDouble() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 1.0f, 2.0f, EnumParticleTypes.SMOKE_NORMAL), world, pos);
            }
        }
        return RiteHandler.Result.COMPLETED;
    }
}

