/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.common.IPowerSource;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;

public abstract class RiteEffectProtectionCircle
extends RiteEffect {
    protected final int radius;
    protected final float upkeepPowerCost;
    protected final int ticksToLive;

    public RiteEffectProtectionCircle(int radius, float upkeepPowerCost, int ticksToLive) {
        this.radius = radius;
        this.upkeepPowerCost = upkeepPowerCost;
        this.ticksToLive = ticksToLive;
    }

    protected abstract void update(World var1, BlockPos var2, int var3, int var4);

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (ticks < 20) {
            return RiteHandler.Result.STARTING;
        }
        if (ticks == 20) {
            world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
        }
        if (this.upkeepPowerCost > 0.0f) {
            IPowerSource powerSource = this.findNewPowerSource(world, pos);
            if (powerSource == null) {
                return RiteHandler.Result.ABORTED;
            }
            if (!powerSource.consumePower(this.upkeepPowerCost)) {
                return RiteHandler.Result.ABORTED;
            }
        }
        if (this.ticksToLive > 0 && (long)ticks % 20L == 0L && stage.incrementAndGet() >= this.ticksToLive) {
            return RiteHandler.Result.COMPLETED;
        }
        this.update(world, pos, this.radius, ticks);
        return RiteHandler.Result.UPKEEP;
    }

    private IPowerSource findNewPowerSource(World world, BlockPos pos) {
        List<PowerSources.RelativePowerSource> sources = PowerSources.instance().get(world, pos);
        return sources != null && sources.size() > 0 ? sources.get(0).source() : null;
    }

    @Override
    public int getRunTime() {
        return 1;
    }
}

