/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import kotlin.jvm.functions.Function1;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.BlockBarrier;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.rite.effect.RiteEffectProtectionCircle;

public class RiteEffectProtectionCircleBarrier
extends RiteEffectProtectionCircle {
    public static final Function1<JsonObject, RiteEffectProtectionCircleBarrier> DESERIALIZER = json -> new RiteEffectProtectionCircleBarrier(JsonUtils.func_151203_m((JsonObject)json, (String)"radius"), JsonUtils.func_151203_m((JsonObject)json, (String)"height"), JsonUtils.func_151217_k((JsonObject)json, (String)"power"), JsonUtils.func_151212_i((JsonObject)json, (String)"block_players"), JsonUtils.func_151208_a((JsonObject)json, (String)"lifetime", (int)0));
    protected static final int TICKS_TO_LIVE_WITHOUT_PULSE = 30;
    protected final int height;
    protected final boolean blockPlayers;

    public RiteEffectProtectionCircleBarrier(int radius, int height2, float upkeepPowerCost, boolean blockPlayers, int ticksToLive) {
        super(radius, upkeepPowerCost, ticksToLive);
        this.height = height2;
        this.blockPlayers = blockPlayers;
    }

    @Override
    protected void update(World world, BlockPos pos, int radius, int ticks) {
        if ((long)ticks % 20L == 0L) {
            this.drawFilledCircle(world, pos.func_177977_b(), radius);
            this.drawCircleCylinder(world, pos, radius);
            this.drawFilledCircle(world, pos.func_177981_b(this.height), radius);
        }
    }

    protected void drawCircleCylinder(World world, BlockPos pos, int radius) {
        int x = radius;
        int radiusError = 1 - x;
        for (int z = 0; x >= z; ++z) {
            this.drawPixelColumn(world, pos.func_177982_a(x, 0, z));
            this.drawPixelColumn(world, pos.func_177982_a(z, 0, x));
            this.drawPixelColumn(world, pos.func_177982_a(-x, 0, z));
            this.drawPixelColumn(world, pos.func_177982_a(-z, 0, x));
            this.drawPixelColumn(world, pos.func_177982_a(-x, 0, -z));
            this.drawPixelColumn(world, pos.func_177982_a(-z, 0, -x));
            this.drawPixelColumn(world, pos.func_177982_a(x, 0, -z));
            this.drawPixelColumn(world, pos.func_177982_a(z, 0, -x));
            if (radiusError < 0) {
                radiusError += 2 * z + 1;
                continue;
            }
            radiusError += 2 * (z - --x + 1);
        }
    }

    protected void drawPixelColumn(World world, BlockPos pos) {
        for (BlockPos y : BlockPos.func_177980_a((BlockPos)pos, (BlockPos)pos.func_177981_b(this.height - 1))) {
            this.drawPixel(world, y);
        }
    }

    protected void drawPixel(World world, BlockPos pos) {
        boolean isBarrier;
        IBlockState state = world.func_180495_p(pos);
        boolean bl = isBarrier = state.func_177230_c() == WitcheryBlocks.BARRIER;
        if (state.func_177230_c() == Blocks.field_150350_a || state.func_185904_a().func_76222_j() || isBarrier) {
            BlockBarrier.setBlock(world, pos, 30, this.blockPlayers, null, isBarrier);
        }
    }

    protected void drawFilledCircle(World world, BlockPos pos, int radius) {
        int x = radius;
        int radiusError = 1 - x;
        for (int z = 0; x >= z; ++z) {
            this.drawLine(world, pos.func_177982_a(-x, 0, z), pos.func_177982_a(x, 0, z));
            this.drawLine(world, pos.func_177982_a(-z, 0, x), pos.func_177982_a(z, 0, x));
            this.drawLine(world, pos.func_177982_a(-x, 0, -z), pos.func_177982_a(x, 0, -z));
            this.drawLine(world, pos.func_177982_a(-z, 0, -x), pos.func_177982_a(z, 0, -x));
            if (radiusError < 0) {
                radiusError += 2 * z + 1;
                continue;
            }
            radiusError += 2 * (z - --x + 1);
        }
    }

    protected void drawLine(World world, BlockPos x1, BlockPos x2) {
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)x1, (BlockPos)x2)) {
            this.drawPixel(world, pos);
        }
    }
}

