/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldInfo;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.entity.passive.EntityToad;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;

public class RiteEffectRainOfToads
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectRainOfToads> DESERIALIZER = json -> new RiteEffectRainOfToads(JsonUtils.func_151208_a((JsonObject)json, (String)"min_radius", (int)5), JsonUtils.func_151208_a((JsonObject)json, (String)"max_radius", (int)16), JsonUtils.func_151208_a((JsonObject)json, (String)"bolts", (int)10));
    private final int minRadius;
    private final int maxRadius;
    private final int bolts;

    public RiteEffectRainOfToads(int minRadius, int maxRadius, int bolts) {
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
        this.bolts = bolts;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (ritual.covenSize < 1) {
            EntityPlayer player = ritual.getInitiatingPlayer(world);
            world.func_184133_a(null, pos, SoundEvents.field_187688_dI, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            if (player != null) {
                player.func_145747_a(new TextComponentTranslation("rite.witchery.weak_coven", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
            return RiteHandler.Result.ABORTED_REFUND;
        }
        switch (stage.incrementAndGet()) {
            case 1: 
            case 2: 
            case 3: {
                this.spawnBolt(world, pos);
                return RiteHandler.Result.STARTING;
            }
            case 4: {
                if (world instanceof WorldServer && !world.func_72896_J()) {
                    WorldInfo worldinfo = world.func_72912_H();
                    int i = (300 + world.field_73012_v.nextInt(600)) * 20;
                    worldinfo.func_76080_g(i);
                    worldinfo.func_76084_b(true);
                }
                this.spawnBolt(world, pos);
                return RiteHandler.Result.STARTING;
            }
        }
        int activeRadius = this.maxRadius - this.minRadius;
        for (int n = 0; n < world.field_73012_v.nextInt(this.bolts) + 8; ++n) {
            int az;
            int ax = world.field_73012_v.nextInt(activeRadius * 2 + 1);
            if (ax > activeRadius) {
                ax += this.minRadius * 2;
            }
            if ((az = world.field_73012_v.nextInt(activeRadius * 2 + 1)) > activeRadius) {
                az += this.minRadius * 2;
            }
            if (!world.func_175623_d(pos = world.func_175672_r(pos.func_177982_a(ax - this.maxRadius, 0, az - this.maxRadius)))) continue;
            EntityToad toad2 = new EntityToad(world);
            toad2.func_70012_b(pos.func_177958_n(), pos.func_177956_o() + 8 + world.field_73012_v.nextInt(7), pos.func_177952_p(), 0.0f, 0.0f);
            toad2.setLifetime(30);
            world.func_72838_d((Entity)toad2);
        }
        return stage.get() < 200 ? RiteHandler.Result.UPKEEP : RiteHandler.Result.COMPLETED;
    }

    private void spawnBolt(World world, BlockPos pos) {
        int activeRadius = this.maxRadius - this.minRadius;
        int ax = world.field_73012_v.nextInt(activeRadius * 2 + 1);
        if (ax > activeRadius) {
            ax += this.minRadius * 2;
        }
        int x = pos.func_177958_n() - this.maxRadius + ax;
        int az = world.field_73012_v.nextInt(activeRadius * 2 + 1);
        if (az > activeRadius) {
            az += this.minRadius * 2;
        }
        int z = pos.func_177952_p() - this.maxRadius + az;
        EntityLightningBolt bolt = new EntityLightningBolt(world, (double)x, (double)pos.func_177956_o(), (double)z, false);
        world.func_72942_c((Entity)bolt);
    }

    @Override
    public int getRunTime() {
        return 30;
    }
}

